//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXSHChooseColor.h
 * @brief		J[I_CAONX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXSHChooseColor_H_
#define INCG_IRIS_WXSHChooseColor_H_

//======================================================================
// include
#include "iris_object.h"
#include "c++0x/cpp0x_type_traits.hpp"
#include <commdlg.h>

namespace iris {
namespace wx
{

//======================================================================
// declare
template<typename CHARTYPE_>class CTSHChooseColor;

//======================================================================
// typedef
typedef CTSHChooseColor<CHAR>	CSHChooseColorA;
typedef CTSHChooseColor<WCHAR>	CSHChooseColorW;
typedef CTSHChooseColor<TCHAR>	CSHChooseColor;

//======================================================================
// class
/**
 * @brief	J[I_CAONX
*/
template<typename CHARTYPE_>
class CTSHChooseColor : public IIrisObject
{
private:
	typedef CHARTYPE_		_Mychar;
	typedef CHARTYPE_		*_Mylpstr;
	typedef const CHARTYPE_	*_Mylpcstr;
	typedef CTSHChooseColor<CHARTYPE_>	_Myt;
public:
	typedef typename iml::type_select< (cpp0x::is_same<_Mychar, WCHAR>::value), CHOOSECOLORW, CHOOSECOLORA >::type XCHOOSECOLOR;
	typedef XCHOOSECOLOR	*LPXCHOOSECOLOR;

public:
	// J
	static	BOOL	Show(HWND hOwner, LPCOLORREF pResult, LPCOLORREF pCustColors, DWORD Flags
		, _Mylpcstr lpTemplateName=nullptr, HINSTANCE hInstance=nullptr, LPCCHOOKPROC lpfnHook=nullptr, LPARAM lCustData=0);

	// 
	static BOOL		Choose(LPXCHOOSECOLOR cc);
};

}	// end of namespace wx
}	// end of namespace iris

#endif
