//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXShellMailTo.cpp
 * @brief		mailto⏕NXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXShellMailTo_CPP_

//======================================================================
// include
#include "WXShellMailTo.h"
#include "WXSHExecute.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CMailTo::CMailTo(void)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CMailTo::~CMailTo(void)
{
}

/**********************************************************************//**
 *
 * s
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= eEBhEnh
 * @param [in]	lpSubject	= 
 * @param [in]	lpBody		= {
 * @param [in]	nShowCmd	= \tO
*//***********************************************************************/
void CMailTo::MailTo(HWND hWnd, LPCTSTR lpSubject, LPCTSTR lpBody, int nShowCmd)
{
#define MAILTO_TAG(tag)		TEXT("&")TEXT(tag)
#define MAILTO_TAG1(tag)	TEXT("?")TEXT(tag)

	std::_tstring	mailto = TEXT("mailto:");
	// \z
	// To
	{
		strlist::iterator it  = m_To.begin();
		strlist::iterator end = m_To.end();
		if( it != end )
		{
			mailto += MAILTO_TAG1("to=");
			while(1)
			{
				mailto += (*it);
				++it;
				if( it == end ) break;
				mailto += TEXT(", ");
			}
		}
	}

	// Cc
	{
		strlist::iterator it  = m_Cc.begin();
		strlist::iterator end = m_Cc.end();
		if( it != end )
		{
			mailto += MAILTO_TAG("cc=");
			while(1)
			{
				mailto += (*it);
				++it;
				if( it == end ) break;
				mailto += TEXT(", ");
			}
		}
	}

	// Bcc
	{
		strlist::iterator it  = m_Bcc.begin();
		strlist::iterator end = m_Bcc.end();
		if( it != end )
		{
			mailto += MAILTO_TAG("bcc=");
			while(1)
			{
				mailto += (*it);
				++it;
				if( it == end ) break;
				mailto += TEXT(", ");
			}
		}
	}

	// subject
	if( lpSubject != nullptr )	
	{
		mailto += MAILTO_TAG("subject=");
		mailto += lpSubject;
	}

	// body
	if( lpBody != nullptr )
	{
		mailto += MAILTO_TAG("body=");
		mailto += lpBody;
	}
	CSHExecute::Run(hWnd, TEXT("open"), mailto.c_str(), nullptr, nullptr, nShowCmd);
}

}	// end of namespace wx
}	// end of namespace iris

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "../debug/unittest/WXDebugUnitTest.h"
#include "iris_using.h"

//======================================================================
// test
IRIS_UNITTEST(CWXShellMailToUnitTest, Func)
{
	CMailTo mailto;
	mailto.AddTo(TEXT("test1@test.co.jp"));
	mailto.AddTo(TEXT("test2@test.co.jp"));
	mailto.AddTo(TEXT("test3@test.co.jp"));
	mailto.AddTo(TEXT("test4@test.co.jp"));

	mailto.AddCc(TEXT("test1@test.co.jp"));
	mailto.AddCc(TEXT("test2@test.co.jp"));
	mailto.AddCc(TEXT("test3@test.co.jp"));
	mailto.ClearCc();
	mailto.AddCc(TEXT("test4@test.co.jp"));

	mailto.ClearBcc();
	mailto.AddBcc(TEXT("test1@test.co.jp"));
	mailto.AddBcc(TEXT("test2@test.co.jp"));
	mailto.AddBcc(TEXT("test3@test.co.jp"));
	mailto.AddBcc(TEXT("test4@test.co.jp"));

	mailto.MailTo(HWND_DESKTOP, TEXT(""), TEXT("{"), SW_SHOWNORMAL);
}

#endif	// #if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
