//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXCSIDL.cpp
 * @brief		CSIDL t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXCSIDL_CPP_

//======================================================================
// include
#include "WXCSIDL.h"
#include "shlobj_inchead.h"

//======================================================================
// link

namespace iris {
namespace wx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 * 
 ----------------------------------------------------------------------
 * @param [in]	CSIDL	= CSIDL l(CSIDL_***)
*//***********************************************************************/
template<>
CTCSIDLPath<CHAR>::CTCSIDLPath(int CSIDL)
{
#if !defined(IRIS_WIN32_WCE)
	SHGetFolderPathA(nullptr, CSIDL, nullptr, 0, m_Path);
#endif
}

/**********************************************************************//**
 *
 * RXgN^
 * 
 ----------------------------------------------------------------------
 * @param [in]	CSIDL	= CSIDL l(CSIDL_***)
*//***********************************************************************/
template<>
CTCSIDLPath<WCHAR>::CTCSIDLPath(int CSIDL)
{
#if !defined(IRIS_WIN32_WCE) || defined(UNDER_NT)
	SHGetFolderPathW(nullptr, CSIDL, nullptr, 0, m_Path);
#endif
}

template class CTCSIDLPath<CHAR>;
template class CTCSIDLPath<WCHAR>;

}	// end of namespace wx
}	// end of namespace iris


#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))

//======================================================================
// include
#include "unit/UnitCore.h"
#include "iris_iostream.h"
#include "iris_using.h"

#define CSIDL_LIST(x)	{						\
						  x(CSIDL_DESKTOP    )	\
						, x(CSIDL_INTERNET   )	\
						, x(CSIDL_PROGRAMS   )	\
						, x(CSIDL_CONTROLS   )	\
						, x(CSIDL_PRINTERS   )	\
						, x(CSIDL_PERSONAL   )	\
						, x(CSIDL_FAVORITES  )	\
						, x(CSIDL_STARTUP    )	\
						, x(CSIDL_RECENT     )	\
						, x(CSIDL_SENDTO     )	\
						, x(CSIDL_BITBUCKET  )	\
						, x(CSIDL_STARTMENU  )	\
						, x(CSIDL_MYDOCUMENTS)	\
						, x(CSIDL_MYMUSIC                )	\
						, x(CSIDL_MYVIDEO                )	\
						, x(CSIDL_DESKTOPDIRECTORY       )	\
						, x(CSIDL_DRIVES                 )	\
						, x(CSIDL_NETWORK                )	\
						, x(CSIDL_NETHOOD                )	\
						, x(CSIDL_FONTS                  )	\
						, x(CSIDL_TEMPLATES              )	\
						, x(CSIDL_COMMON_STARTMENU       )	\
						, x(CSIDL_COMMON_PROGRAMS        )	\
						, x(CSIDL_COMMON_STARTUP         )	\
						, x(CSIDL_COMMON_DESKTOPDIRECTORY)	\
						, x(CSIDL_APPDATA                )	\
						, x(CSIDL_PRINTHOOD              )	\
						, x(CSIDL_LOCAL_APPDATA)	\
						, x(CSIDL_ALTSTARTUP       )	\
						, x(CSIDL_COMMON_ALTSTARTUP)	\
						, x(CSIDL_COMMON_FAVORITES )	\
						, x(CSIDL_INTERNET_CACHE )	\
						, x(CSIDL_COOKIES        )	\
						, x(CSIDL_HISTORY        )	\
						, x(CSIDL_COMMON_APPDATA )	\
						, x(CSIDL_WINDOWS        )	\
						, x(CSIDL_SYSTEM         )	\
						, x(CSIDL_PROGRAM_FILES  )	\
						, x(CSIDL_MYPICTURES     )	\
						, x(CSIDL_PROFILE         )	\
						, x(CSIDL_SYSTEMX86       )	\
						, x(CSIDL_PROGRAM_FILESX86)	\
						, x(CSIDL_PROGRAM_FILES_COMMON)	\
						, x(CSIDL_PROGRAM_FILES_COMMONX86)	\
						, x(CSIDL_COMMON_TEMPLATES)	\
						, x(CSIDL_COMMON_DOCUMENTS )	\
						, x(CSIDL_COMMON_ADMINTOOLS)	\
						, x(CSIDL_ADMINTOOLS       )	\
						, x(CSIDL_CONNECTIONS    )	\
						, x(CSIDL_COMMON_MUSIC   )	\
						, x(CSIDL_COMMON_PICTURES)	\
						, x(CSIDL_COMMON_VIDEO   )	\
						, x(CSIDL_RESOURCES      )	\
						, x(CSIDL_RESOURCES_LOCALIZED)	\
						, x(CSIDL_COMMON_OEM_LINKS)	\
						, x(CSIDL_CDBURN_AREA)	\
						, x(CSIDL_COMPUTERSNEARME)	\
					}

//======================================================================
// test
IRIS_UNITTEST(CWXCSIDLPathUnitTest, ListUp)
{
#define data(n)	n
#define text(n)	#n
	int csidls[] = CSIDL_LIST(data);
	const char* csidls_name[] = CSIDL_LIST(text);
	for( int i=0; i < elementof(csidls); ++i )
	{
		CCSIDLPath csidl(csidls[i]);
		std::cout << csidls_name[i] << std::endl;
		std::cout << "    ";
		std::tcout << csidl << std::endl;
	}


}

#endif
