//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXStaringTable.h
 * @brief		StringTablet@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXStaringTable_H_
#define INCG_IRIS_WXStaringTable_H_

//======================================================================
// include
#include "iris_object.h"
#include <map>

/*
// L`incldeOɐ錾Ă
// cpp̒`ƒu邱Ƃł
// ŏ
#define STRING_TABLE_LENGTH_MIN		64
// ő啶
// Ȃ̏ꍇ͒`Ȃ
#define STRING_TABLE_LENGTH_MAX		4096
// 擾x
// (STRING_TABLE_LENGTH_MINSTRING_TABLE_ACCURACYZẴobt@𐶐B)
#define STRING_TABLE_ACCURACY		64	
*/

namespace iris {
namespace wx
{

//======================================================================
// declare
template<typename CHARTYPE_>class CTStringTable;

//======================================================================
// typedef
typedef CTStringTable<CHAR>		CStringTableA;
typedef CTStringTable<WCHAR>	CStringTableW;
typedef CTStringTable<TCHAR>	CStringTable;

//======================================================================
// class
//! StringTableA NX
template<typename CHARTYPE_>
class CTStringTable : public INonCopyable<>
{
	typedef CHARTYPE_					_Mychar;
	typedef CHARTYPE_					*_Mylpstr;
	typedef std::pair<HINSTANCE, UINT>	_Mykey;
	typedef std::map<_Mykey, _Mylpstr>	_Mymap;
	typedef typename _Mymap::iterator	iterator;
	mutable	_Mymap m_StringArray;	//!< LbV
public:
	// RXgN^
	CTStringTable(void);
	// fXgN^
	~CTStringTable(void);
public:
	// 擾
	// pDefString = 擾ɎsƂɕԂ
	_Mylpstr	Get(HINSTANCE hInst, UINT uID, _Mylpstr pDefString=nullptr)	const;
	_Mylpstr	Get(UINT uID, _Mylpstr pDefString=nullptr)	const;

public:
	// \[X烍[h
	static int Load(HINSTANCE hInstance, UINT uID, _Mylpstr lpBuffer, int cchBufferMax);
};

}	// end of namespace wx
}	// end of namespace iris

#endif
