//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXRegistry.cpp
 * @brief		WXgNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXRegistry_CPP_

//======================================================================
// include
#include "WXRegistry.h"
#include "iris_debug.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CRegistry::CRegistry(void)
: m_hKey(nullptr)
{
}

/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	hKey	= ֘AtL[
*//***********************************************************************/
CRegistry::CRegistry(HKEY hKey)
: m_hKey(nullptr)
{
	Attach(hKey);
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CRegistry::~CRegistry(void)
{
	Close();
}

/**********************************************************************//**
 *
 * ֘At
 *
 * @note	L[Ȃ̂Œ
 *
 ----------------------------------------------------------------------
 * @param [in]	hKey		= Vnh
 * @return	ȑÕnh
*//***********************************************************************/
HKEY CRegistry::Attach(HKEY hKey)
{
	HKEY hPre = m_hKey;
	m_hKey = hKey;
	return hPre;
}

/**********************************************************************//**
 *
 * ֘At
 *
 * @note	L[Ȃ̂Œ
 *
 ----------------------------------------------------------------------
 * @return	ȑÕnh
*//***********************************************************************/
HKEY CRegistry::Detach(void)
{
	HKEY hPre = m_hKey;
	m_hKey = nullptr;
	return hPre;
}

/**********************************************************************//**
 *
 * J
 *
 ----------------------------------------------------------------------
 * @param [in]	hKey		= 
 * @param [in]	lpSubKey	= 
 * @return	
*//***********************************************************************/
template<>
BOOL CRegistry::Open<CHAR>(HKEY hKey, LPCSTR  lpSubKey)
{
#if	!defined(IRIS_WIN32_WCE)
	Close();
	if( RegOpenKeyA(hKey, lpSubKey, &m_hKey) != ERROR_SUCCESS )
		return FALSE;
	return TRUE;
#else
	return FALSE;
#endif
}
/// CRegistry::Open Q
template<>
BOOL CRegistry::Open<WCHAR>(HKEY hKey, LPCWSTR lpSubKey)
{
	Close();
	if( RegOpenKeyW(hKey, lpSubKey, &m_hKey) != ERROR_SUCCESS )
		return FALSE;
	return TRUE;
}

/**********************************************************************//**
 *
 * J
 *
 ----------------------------------------------------------------------
 * @param [in]	hKey		= L[nh
 * @param [in]	lpSubKey	= TuL[
 * @param [in]	dwOptions	= \̈(0)
 * @param [in]	samDesired	= KEY_***
 * @return	
*//***********************************************************************/
template<>
BOOL CRegistry::OpenEx<CHAR>(HKEY hKey, LPCSTR  lpSubKey, DWORD dwOptions, REGSAM samDesired)
{
#if	!defined(IRIS_WIN32_WCE)
	Close();
	if( RegOpenKeyExA(hKey, lpSubKey, dwOptions, samDesired, &m_hKey) != ERROR_SUCCESS )
		return FALSE;
	return TRUE;
#else
	return FALSE;
#endif
}
/// CRegistry::OpenEx Q
template<>
BOOL CRegistry::OpenEx<WCHAR>(HKEY hKey, LPCWSTR lpSubKey, DWORD dwOptions, REGSAM samDesired)
{
	Close();
	if( RegOpenKeyExW(hKey, lpSubKey, dwOptions, samDesired, &m_hKey) != ERROR_SUCCESS )
		return FALSE;
	return TRUE;
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CRegistry::Close(void)
{
	if( RegCloseKey(m_hKey) != ERROR_SUCCESS )
		return FALSE;
	return TRUE;
}

/**********************************************************************//**
 *
 * l擾
 *
 ----------------------------------------------------------------------
 * @param [in]	lpSubKey	= 
 * @param [in]	lpValue		= 
 * @param [in]	lpcbValue	= 
 * @return	
*//***********************************************************************/
template<>
BOOL CRegistry::QueryValue<CHAR>(LPCSTR  lpSubKey, LPSTR  lpValue, PLONG lpcbValue) const
{
#if	!defined(IRIS_WIN32_WCE)
	if( RegQueryValueA(m_hKey, lpSubKey, lpValue, lpcbValue) != ERROR_SUCCESS )
		return FALSE;
	return TRUE;
#else
	return FALSE;
#endif
}
/// CRegistry::QueryValue Q
template<>
BOOL CRegistry::QueryValue<WCHAR>(LPCWSTR lpSubKey, LPWSTR lpValue, PLONG lpcbValue) const
{
	if( RegQueryValueW(m_hKey, lpSubKey, lpValue, lpcbValue) != ERROR_SUCCESS )
		return FALSE;
	return TRUE;
}

/**********************************************************************//**
 *
 * l擾
 *
 ----------------------------------------------------------------------
 * @param [in]	lpSubKey	= 
 * @param [in]	lpValue		= 
 * @param [in]	lpcbValue	= 
 * @return	
*//***********************************************************************/
template<>
BOOL CRegistry::QueryValueEx<CHAR>(LPCSTR  lpValueName, LPDWORD lpType, LPBYTE lpData, LPDWORD lpcbData) const
{
#if	!defined(IRIS_WIN32_WCE)
	if( RegQueryValueExA(m_hKey, lpValueName, nullptr, lpType, lpData, lpcbData) != ERROR_SUCCESS )
		return FALSE;
	return TRUE;
#else
	return FALSE;
#endif
}
/// CRegistry::QueryValue Q
template<>
BOOL CRegistry::QueryValueEx<WCHAR>(LPCWSTR lpValueName, LPDWORD lpType, LPBYTE lpData, LPDWORD lpcbData) const
{
	if( RegQueryValueExW(m_hKey, lpValueName, nullptr, lpType, lpData, lpcbData) != ERROR_SUCCESS )
		return FALSE;
	return TRUE;
}

/**********************************************************************//**
 *
 * lݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	lpSubKey	= 
 * @param [in]	dwType		= 
 * @param [in]	lpData		= 
 * @param [in]	cbData		= 
 * @return	
*//***********************************************************************/
template<>
BOOL CRegistry::SetValue<CHAR>(LPCSTR  lpSubKey, DWORD dwType, LPCSTR  lpData, DWORD cbData)
{
#if	!defined(IRIS_WIN32_WCE)
	if( RegSetValueA(m_hKey, lpSubKey, dwType, lpData, cbData) != ERROR_SUCCESS )
		return FALSE;
	return TRUE;
#else
	return FALSE;
#endif
}
/// CRegistry::SetValue Q
template<>
BOOL CRegistry::SetValue<WCHAR>(LPCWSTR lpSubKey, DWORD dwType, LPCWSTR lpData, DWORD cbData)
{
	if( RegSetValueW(m_hKey, lpSubKey, dwType, lpData, cbData) != ERROR_SUCCESS )
		return FALSE;
	return TRUE;
}

/**********************************************************************//**
 *
 * lݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	lpValueName	= 
 * @param [in]	dwType		= 
 * @param [in]	lpData		= 
 * @param [in]	cbData		= 
 * @return	
*//***********************************************************************/
template<>
BOOL CRegistry::SetValueEx<CHAR>(LPCSTR  lpValueName, DWORD dwType, const BYTE* lpData, DWORD cbData)
{
#if	!defined(IRIS_WIN32_WCE)
	if( RegSetValueExA(m_hKey, lpValueName, 0, dwType, lpData, cbData) != ERROR_SUCCESS )
		return FALSE;
	return TRUE;
#else
	return FALSE;
#endif
}
/// CRegistry::SetValueEx Q
template<>
BOOL CRegistry::SetValueEx<WCHAR>(LPCWSTR lpValueName, DWORD dwType, const BYTE* lpData, DWORD cbData)
{
	if( RegSetValueExW(m_hKey, lpValueName, 0, dwType, lpData, cbData) != ERROR_SUCCESS )
		return FALSE;
	return TRUE;
}

/**********************************************************************//**
 *
 * CfbNX擾
 *
 ----------------------------------------------------------------------
 * @param [in]	dwIndex				= CfbNX
 * @param [out]	lpName				= o̓obt@
 * @param [in]	cchName				= o̓obt@TCY
 * @return	
*//***********************************************************************/
template<>
LSTATUS CRegistry::EnumKey<CHAR>(DWORD dwIndex, LPSTR  lpName, DWORD cchName)
{
#if	!defined(IRIS_WIN32_WCE)
	return RegEnumKeyA(m_hKey, dwIndex, lpName, cchName);
#else
	return ERROR_INVALID_FUNCTION;
#endif
}
/// CRegistry::EnumKey Q
template<>
LSTATUS CRegistry::EnumKey<WCHAR>(DWORD dwIndex, LPWSTR lpName, DWORD cchName)
{
	return RegEnumKeyW(m_hKey, dwIndex, lpName, cchName);
}

/**********************************************************************//**
 *
 * CfbNX擾
 *
 ----------------------------------------------------------------------
 * @param [in]	dwIndex				= CfbNX
 * @param [out]	lpName				= L[
 * @param [out]	lpcchName			= L[̏o̓TCY
 * @param [in]	lpReserved			= \̈
 * @param [out]	lpClass				= 
 * @param [out]	lpcchClass			= 
 * @param [in]	lpftLastWriteTime	= 
 * @return	
*//***********************************************************************/
template<>
LSTATUS CRegistry::EnumKeyEx<CHAR>(DWORD dwIndex, LPSTR  lpName, LPDWORD lpcchName, LPDWORD lpReserved, LPSTR  lpClass, LPDWORD lpcchClass, PFILETIME lpftLastWriteTime)
{
#if	!defined(IRIS_WIN32_WCE)
	return RegEnumKeyExA(m_hKey, dwIndex, lpName, lpcchName, lpReserved, lpClass, lpcchClass, lpftLastWriteTime);
#else
	return ERROR_INVALID_FUNCTION;
#endif
}
/// CRegistry::EnumKeyEx Q
template<>
LSTATUS CRegistry::EnumKeyEx<WCHAR>(DWORD dwIndex, LPWSTR lpName, LPDWORD lpcchName, LPDWORD lpReserved, LPWSTR lpClass, LPDWORD lpcchClass, PFILETIME lpftLastWriteTime)
{
	return RegEnumKeyExW(m_hKey, dwIndex, lpName, lpcchName, lpReserved, lpClass, lpcchClass, lpftLastWriteTime);
}

/**********************************************************************//**
 *
 * 񋓏 
 *
 ----------------------------------------------------------------------
 * @param [in]	pfnEnumProc		= ֐
 * @return	
*//***********************************************************************/
BOOL CRegistry::EnumKeyProc(PFN_EnumProc pfnEnumProc, LPVOID lpArg)
{
	IRIS_ASSERT( pfnEnumProc != nullptr );
	if( !IsValid() ) return FALSE;
	CHAR key[MAX_PATH];
	DWORD key_size = MAX_PATH;
	DWORD dwIndex = 0;
	do
	{
		LSTATUS lstatus = EnumKey(dwIndex, key, key_size);
		if( lstatus == ERROR_NO_MORE_ITEMS ) break;
		IRIS_ASSERT( lstatus == ERROR_SUCCESS );

		CRegistry reg;
		if( reg.Open(m_hKey, key) )
		{
			if( !(*pfnEnumProc)(reg, dwIndex, lpArg) )
			{
				break;
			}
		}
	} while(++dwIndex);
	return TRUE;
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @param [in]	si		= 
 * @param [in]	sd		= 
 * @return	
*//***********************************************************************/
BOOL CRegistry::SetKeySecurity(SECURITY_INFORMATION si, PSECURITY_DESCRIPTOR sd)
{
#if	!defined(IRIS_WIN32_WCE)
	if( RegSetKeySecurity(m_hKey, si, sd) != ERROR_SUCCESS )
		return FALSE;
	return TRUE;
#else
	return FALSE;
#endif
}

/**********************************************************************//**
 *
 * lݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	lpFile					= 
 * @param [in]	lpSecurityAttributes	= 
 * @return	
*//***********************************************************************/
template<>
BOOL CRegistry::SaveKey<CHAR>(LPCSTR  lpFile, LPSECURITY_ATTRIBUTES lpSecurityAttributes)
{
#if	!defined(IRIS_WIN32_WCE)
	if( RegSaveKeyA(m_hKey, lpFile, lpSecurityAttributes) != ERROR_SUCCESS )
		return FALSE;
	return TRUE;
#else
	return FALSE;
#endif
}
/// CRegistry::SaveKey Q
template<>
BOOL CRegistry::SaveKey<WCHAR>(LPCWSTR lpFile, LPSECURITY_ATTRIBUTES lpSecurityAttributes)
{
#if	!defined(IRIS_WIN32_WCE) || defined(UNDER_NT)
	if( RegSaveKeyW(m_hKey, lpFile, lpSecurityAttributes) != ERROR_SUCCESS )
		return FALSE;
	return TRUE;
#else
	return FALSE;
#endif
}

}	// end of namespace wx
}	// end of namespace iris
