//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXUserProfile.cpp
 * @brief		userenv t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXUserProfile_CPP_

//======================================================================
// include
#include "WXUserProfile.h"

#if !defined(IRIS_WIN32_WCE)

#include <userenv.h>

//======================================================================
// link
#pragma comment ( lib, "userenv.lib" )

namespace iris {
namespace wx
{

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CUserProfile::CUserProfile(void)
: m_hProfile(nullptr)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CUserProfile::~CUserProfile(void)
{
	Unload();
}

/**********************************************************************//**
 *
 * [U[vt@Cǂݍ
 *
 -----------------------------------------------------------------------
 * @param [in]	lpszUsername	= [U[
 * @param [in]	lpszProfilePath	= ړ[U[vt@C̃pX
 * @param [in]	lpszDefaultPath	= ftHg̃vt@C̃pX
 * @param [in]	lpszServerName	= hCRg[
 * @param [in]	lpszPolicyPath	= |V[t@C̃pX
 * @return	
*//***********************************************************************/
template<>
BOOL CUserProfile::Load<CHAR>(LPSTR lpszUsername, LPSTR lpszProfilePath, LPSTR lpszDefaultPath, LPSTR lpszServerName, LPSTR lpszPolicyPath)
{
	PROFILEINFOA pi = {0};
	pi.dwSize = sizeof(pi);
	pi.lpUserName		= lpszUsername;
	pi.lpProfilePath	= lpszProfilePath;
	pi.lpDefaultPath	= lpszDefaultPath;
	pi.lpServerName		= lpszServerName;
	pi.lpPolicyPath		= lpszPolicyPath;
	if( !::LoadUserProfileA(m_hObject, &pi) ) return FALSE;
	Unload();
	m_hProfile = pi.hProfile;
	return TRUE;
}
template<>
BOOL CUserProfile::Load<WCHAR>(LPWSTR lpszUsername, LPWSTR lpszProfilePath, LPWSTR lpszDefaultPath, LPWSTR lpszServerName, LPWSTR lpszPolicyPath)
{
	PROFILEINFOW pi = {0};
	pi.dwSize = sizeof(pi);
	pi.lpUserName		= lpszUsername;
	pi.lpProfilePath	= lpszProfilePath;
	pi.lpDefaultPath	= lpszDefaultPath;
	pi.lpServerName		= lpszServerName;
	pi.lpPolicyPath		= lpszPolicyPath;
	if( !::LoadUserProfileW(m_hObject, &pi) ) return FALSE;
	Unload();
	m_hProfile = pi.hProfile;
	return TRUE;
}

/**********************************************************************//**
 *
 * [U[vt@C
 *
 -----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CUserProfile::Unload(void)
{
	BOOL ret = TRUE;
	if(	m_hProfile != nullptr )
	{
		ret = ::UnloadUserProfile(m_hObject, m_hProfile);
		m_hProfile = nullptr;
	}
	return ret;
}

}	// end of namespace wx
}	// end of namespace iris

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "../../debug/unittest/WXDebugUnitTest.h"
#include "../../etc/toolhelp/WXFindProcess.h"
#include "../WXProcess.h"
#include "iris_using.h"
#include <tchar.h>

//======================================================================
// test
IRIS_UNITTEST(CWXUserProfile, ParentEnv)
{
	//CFindProcess fp;
	//DWORD dwID = fp.FindParentProcessId(::GetCurrentProcessId());
	//if( dwID == 0 ) return;

	//CProcess proc;
	//ASSERT_TRUE( proc.Open(dwID) );

	//CUserProfile env;
	//ASSERT_TRUE( env.OpenFromProcess(proc, TOKEN_QUERY) );

	//ASSERT_TRUE( env.Load() );

	//TCHAR path[MAX_PATH];
	//ASSERT_TRUE( env.ExpandEnvironmentStrings(IRIS_TEXT("%hoge%"), path, MAX_PATH) );
	//
	//_putts(path);
}

#endif	// #if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))

#endif
