//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXPCName.h
 * @brief		PC 擾NX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXPCName_H_
#define INCG_IRIS_WXPCName_H_

//======================================================================
// include
#include "iris_object.h"

namespace iris {
namespace wx
{

#if (_WIN32_WINNT < 0x0500)

typedef enum _COMPUTER_NAME_FORMAT
{
	ComputerNameNetBIOS,
	ComputerNameDnsHostname,
	ComputerNameDnsDomain,
	ComputerNameDnsFullyQualified,
	ComputerNamePhysicalNetBIOS,
	ComputerNamePhysicalDnsHostname,
	ComputerNamePhysicalDnsDomain,
	ComputerNamePhysicalDnsFullyQualified,
	ComputerNameMax
} COMPUTER_NAME_FORMAT;

#endif

//======================================================================
// declare
template<typename CHARTYPE_, COMPUTER_NAME_FORMAT FORMAT>class CTPCName;

//======================================================================
// class
template<COMPUTER_NAME_FORMAT FORMAT=ComputerNameNetBIOS>class CPCNameA : public CTPCName< CHAR, FORMAT> {};
template<COMPUTER_NAME_FORMAT FORMAT=ComputerNameNetBIOS>class CPCNameW : public CTPCName<WCHAR, FORMAT> {};
template<COMPUTER_NAME_FORMAT FORMAT=ComputerNameNetBIOS>class CPCName  : public CTPCName<TCHAR, FORMAT> {};

/**
 * @brief	PC NX
*/
template<typename CHARTYPE_, COMPUTER_NAME_FORMAT FORMAT=ComputerNameNetBIOS>
class CTPCName : public IIrisObject
{
	typedef CTPCName<CHARTYPE_, FORMAT>	_Myt;

	struct detail
	{
		template<typename CHARTYPE_>
		static BOOL GetName(COMPUTER_NAME_FORMAT format, CHARTYPE_* dst, LPDWORD lpdwSize);

		template<>
		static BOOL GetName(COMPUTER_NAME_FORMAT format, LPSTR dst, LPDWORD lpdwSize)
		{
#if (_WIN32_WINNT >= 0x0500)
			return GetComputerNameExA(format, dst, lpdwSize);
#else
			return GetComputerNameA(dst, lpdwSize);
#endif
		}
		template<>
		static BOOL GetName(COMPUTER_NAME_FORMAT format,LPWSTR dst, LPDWORD lpdwSize)
		{
#if (_WIN32_WINNT >= 0x0500)
			return GetComputerNameExW(format, dst, lpdwSize);
#else
			return GetComputerNameW(dst, lpdwSize);
#endif
		}
	};
public:
	static const COMPUTER_NAME_FORMAT	NAME_FORMAT;

protected:
	typedef	CHARTYPE_			_Mychar;
	typedef CHARTYPE_			*_Mylpstr;
	typedef const CHARTYPE_		*_Mylpcstr;

protected:
	_Mychar	m_Name[MAX_COMPUTERNAME_LENGTH];

public:
	/**
	 * @breif	RXgN^
	*/
	CTPCName(void)
	{
		DWORD dwSize = MAX_COMPUTERNAME_LENGTH;
		detail::GetName(FORMAT, m_Name,  &dwSize);
	}
public:
	operator _Mylpstr   (void)			{ return GetName(); }
	operator _Mylpcstr  (void)	const	{ return GetName(); }
	_Mylpstr 	operator ()	(void)		{ return GetName(); }
	_Mylpcstr 	operator ()	(void) const{ return GetName(); }

public:

	_Mychar		operator [] (int nIndex) const			{ return m_Name[nIndex]; }

public:
	_Mylpstr	GetName(void)			{ return m_Name; }
	_Mylpcstr	GetName(void)	const	{ return m_Name; }

};

}	// end of namespace wx
}	// end of namespace iris

#endif
