//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXProcess.cpp
 * @brief		vZXNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXProcess_CPP_

//======================================================================
// include
#include "WXProcess.h"
#include "../control/search/WXFindWindow.h"
#include "../../../../iris_debug.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 * 
*//***********************************************************************/
CProcess::CProcess(void)
{
}

/**********************************************************************//**
 *
 * RXgN^
 * 
 ----------------------------------------------------------------------
 * @param [in]	hProcess	= ֘AtvZX
*//***********************************************************************/
CProcess::CProcess(HANDLE hProcess)
: ISyncObject(hProcess)
{
}

/**********************************************************************//**
 *
 * fXgN^
 * 
*//***********************************************************************/
CProcess::~CProcess(void)
{
	if( !IsExist() ) Detach();
}

/**********************************************************************//**
 *
 * 쐬
 * 
 ----------------------------------------------------------------------
 * @param [in]	lpApplicationName	= s\t@C
 * @param [in]	lpCmdLine			= R}hC
 * @param [in]	lpProcessAttr		= vZX̃ZLeBLqq
 * @param [in]	lpThreadAttr		= Xbh̃ZLeBLqq
 * @param [in]	bInheritHandles		= nȟpIvV
 * @param [in]	dwCreationFlags		= 쐬tO(CREATE_*** etc...)
 * @param [in]	lpEnvironment		= VubN
 * @param [in]	lpCurrentDirectory	= ƃfBNg
 * @param [in]	lpStartupInfo		= Jnp[^
 * @param [out]	lppi				= vZXo
 * @return	
*//***********************************************************************/
template<>
BOOL CProcess::Create<CHAR>(LPCSTR  lpApplicationName, LPSTR  lpCmdLine
					   , LPSECURITY_ATTRIBUTES lpProcessAttr, LPSECURITY_ATTRIBUTES lpThreadAttr
					   , BOOL bInheritHandles, DWORD dwCreationFlags
					   , LPVOID lpEnvironment, LPCSTR  lpCurrentDirectory
					   , LPSTARTUPINFOA lpStartupInfo, LPPROCESS_INFORMATION lppi)
{
#if	!defined(IRIS_WIN32_WCE)
	IRIS_ASSERTMSG( !IsBadWritePtr(lpCmdLine, sizeof(CHAR)), "ݕsȃ̈悪n܂" );
	PROCESS_INFORMATION pi;
	STARTUPINFOA si;
	if( lpStartupInfo == nullptr )
	{
		ZeroMemory(&si, sizeof(si));
		si.cb		= sizeof(si);
		lpStartupInfo = &si;
	}

	if( !::CreateProcessA(lpApplicationName, lpCmdLine, lpProcessAttr, lpThreadAttr
							, bInheritHandles, dwCreationFlags, lpEnvironment
							, lpCurrentDirectory
							, lpStartupInfo, &pi)
							)
	{
		return FALSE;
	}
	return _Create(lppi, &pi);
#else
	return FALSE;
#endif
}
template<>
BOOL CProcess::Create<WCHAR>(LPCWSTR lpApplicationName, LPWSTR lpCmdLine
					   , LPSECURITY_ATTRIBUTES lpProcessAttr, LPSECURITY_ATTRIBUTES lpThreadAttr
					   , BOOL bInheritHandles, DWORD dwCreationFlags
					   , LPVOID lpEnvironment, LPCWSTR lpCurrentDirectory
					   , LPSTARTUPINFOW lpStartupInfo, LPPROCESS_INFORMATION lppi)
{
	IRIS_ASSERTMSG( !IsBadWritePtr(lpCmdLine, sizeof(WCHAR)), "ݕsȃ̈悪n܂" );
	PROCESS_INFORMATION pi;
	STARTUPINFOW si;
	if( lpStartupInfo == nullptr )
	{
		ZeroMemory(&si, sizeof(si));
		si.cb		= sizeof(si);
		lpStartupInfo = &si;
	}
	if( !::CreateProcessW(lpApplicationName, lpCmdLine, lpProcessAttr, lpThreadAttr
							, bInheritHandles, dwCreationFlags, lpEnvironment
#if	!defined(IRIS_WIN32_WCE)
							, lpCurrentDirectory
#else
							, const_cast<LPWSTR>(lpCurrentDirectory)
#endif
							, lpStartupInfo, &pi) )
	{
		return FALSE;
	}
	return _Create(lppi, &pi);
}

/**********************************************************************//**
 *
 * 쐬
 * 
 ----------------------------------------------------------------------
 * @param [in]	hToken				= OIĂ郆[U[\g[Nnh
 * @param [in]	lpApplicationName	= s\t@C
 * @param [in]	lpCmdLine			= R}hC
 * @param [in]	lpProcessAttr		= vZX̃ZLeBLqq
 * @param [in]	lpThreadAttr		= Xbh̃ZLeBLqq
 * @param [in]	bInheritHandles		= nȟpIvV
 * @param [in]	dwCreationFlags		= 쐬tO(CREATE_*** etc...)
 * @param [in]	lpEnvironment		= VubN
 * @param [in]	lpCurrentDirectory	= ƃfBNg
 * @param [in]	lpStartupInfo		= Jnp[^
 * @param [out]	lppi				= vZXo
 * @return	
*//***********************************************************************/
#if	!defined(IRIS_WIN32_WCE)
template<>
BOOL CProcess::CreateAsUser<CHAR>(HANDLE hToken, LPCSTR  lpApplicationName, LPSTR  lpCmdLine
					   , LPSECURITY_ATTRIBUTES lpProcessAttr, LPSECURITY_ATTRIBUTES lpThreadAttr
					   , BOOL bInheritHandles, DWORD dwCreationFlags
					   , LPVOID lpEnvironment, LPCSTR  lpCurrentDirectory
					   , LPSTARTUPINFOA lpStartupInfo, LPPROCESS_INFORMATION lppi)
{
	PROCESS_INFORMATION pi;
	if( !CreateProcessAsUserA(hToken, lpApplicationName, lpCmdLine, lpProcessAttr, lpThreadAttr
							, bInheritHandles, dwCreationFlags, lpEnvironment, lpCurrentDirectory
							, lpStartupInfo, &pi) )
	{
		return FALSE;
	}
	return _Create(lppi, &pi);
}
/// CProcess::CreateAsUser Q
template<>
BOOL CProcess::CreateAsUser<WCHAR>(HANDLE hToken, LPCWSTR lpApplicationName, LPWSTR lpCmdLine
					   , LPSECURITY_ATTRIBUTES lpProcessAttr, LPSECURITY_ATTRIBUTES lpThreadAttr
					   , BOOL bInheritHandles, DWORD dwCreationFlags
					   , LPVOID lpEnvironment, LPCWSTR lpCurrentDirectory
					   , LPSTARTUPINFOW lpStartupInfo, LPPROCESS_INFORMATION lppi)
{
	PROCESS_INFORMATION pi;
	if( !CreateProcessAsUserW(hToken, lpApplicationName, lpCmdLine, lpProcessAttr, lpThreadAttr
							, bInheritHandles, dwCreationFlags, lpEnvironment, lpCurrentDirectory
							, lpStartupInfo, &pi) )
	{
		return FALSE;
	}
	return _Create(lppi, &pi);
}
#endif

/**********************************************************************//**
 *
 * vZXN܂őҋ@
 * 
*//***********************************************************************/
void CProcess::WaitWakeup(void)
{
	if( !IsValid() ) return;
	while( Wait(0) != WAIT_TIMEOUT )
	{
		Sleep(1);
	}
}

/**********************************************************************//**
 *
 * vZXI
 * 
 ----------------------------------------------------------------------
 * @param [in]	dwTimeout	= Is܂ł̏I҂^CAEg(mb)
*//***********************************************************************/
void CProcess::Destroy(DWORD dwTimeout)
{
	if( !IsValid() ) return;

#if	!defined(IRIS_WIN32_WCE)
#if 0
	struct impl
	{
		static BOOL CALLBACK EnumFunc(HWND hWnd, LPARAM lParam)
		{
			DWORD tpid = (DWORD)lParam;
			DWORD wpid = 0;
			GetWindowThreadProcessId(hWnd, &wpid);
			if( tpid == wpid )
			{
				::SendMessage(hWnd, WM_CLOSE, 0, 0);
				return FALSE;
			}
			return TRUE;
;		}
	};

	EnumWindows(impl::EnumFunc, GetProcessId());

#else
	HWND hWnd = CFindWindow::FindWindow(GetDesktopWindow(), nullptr, CFindWindow::ProcessIdOp<>(GetProcessId()));
	if( hWnd != nullptr )
	{
		::PostMessage(hWnd, WM_CLOSE, 0, 0);
		//DestroyWindow(hWnd);
	}
#endif
#endif

	if( Wait(dwTimeout) == WAIT_TIMEOUT )
	{
		Terminate(1);
	}

	Close();
}

/**********************************************************************//**
 *
 * vZXI
 * 
 ----------------------------------------------------------------------
 * @param [in]	uExitCode	= IR[h
 * @retrun 
*//***********************************************************************/
BOOL CProcess::Terminate(UINT uExitCode)
{
	return ::TerminateProcess(m_hObject, uExitCode);
}

/**********************************************************************//**
 *
 * vZXIĂ邩ǂ
 * 
 ----------------------------------------------------------------------
 * @retrun ^Ul
*//***********************************************************************/
BOOL CProcess::IsExit(void) const
{
	DWORD dwCode;
	if( !::GetExitCodeProcess(m_hObject, &dwCode) ) return TRUE;
	return IRIS_TO_BOOL( dwCode != STILL_ACTIVE );
}

/**********************************************************************//**
 *
 * vZXNďI҂
 * 
 ----------------------------------------------------------------------
 * @param [in]	lpApplicationName	= s\t@C
 * @param [in]	lpCmdLine			= R}hC
 * @param [in]	lpProcessAttr		= vZX̃ZLeBLqq
 * @param [in]	lpThreadAttr		= Xbh̃ZLeBLqq
 * @param [in]	bInheritHandles		= nȟpIvV
 * @param [in]	dwCreationFlags		= 쐬tO(CREATE_*** etc...)
 * @param [in]	lpEnvironment		= VubN
 * @param [in]	lpCurrentDirectory	= ƃfBNg
 * @param [in]	lpStartupInfo		= Jnp[^
 * @return	IR[h
*//***********************************************************************/
template<>
DWORD CProcess::RunWait<CHAR>(LPCSTR lpApplicationName, LPSTR lpCmdLine
						, LPSECURITY_ATTRIBUTES lpProcessAttr, LPSECURITY_ATTRIBUTES lpThreadAttr
						, BOOL bInheritHandles, DWORD dwCreationFlags
						, LPVOID lpEnvironment, LPCSTR lpCurrentDirectory
						, LPSTARTUPINFOA lpStartupInfo)
{
	PROCESS_INFORMATION pi;
	Close();
	if( !Create(lpApplicationName, lpCmdLine, lpProcessAttr, lpThreadAttr
		, bInheritHandles, dwCreationFlags, lpEnvironment, lpCurrentDirectory
		, lpStartupInfo, &pi) ) return 1;
	CloseHandle(pi.hThread);
	Wait(INFINITE);
	return GetExitCode();
}
template<>
DWORD CProcess::RunWait<WCHAR>(LPCWSTR lpApplicationName, LPWSTR lpCmdLine
							  , LPSECURITY_ATTRIBUTES lpProcessAttr, LPSECURITY_ATTRIBUTES lpThreadAttr
							  , BOOL bInheritHandles, DWORD dwCreationFlags
							  , LPVOID lpEnvironment, LPCWSTR lpCurrentDirectory
							  , LPSTARTUPINFOW lpStartupInfo)
{
	PROCESS_INFORMATION pi;
	Close();
	if( !Create(lpApplicationName, lpCmdLine, lpProcessAttr, lpThreadAttr
		, bInheritHandles, dwCreationFlags, lpEnvironment, lpCurrentDirectory
		, lpStartupInfo, &pi) ) return 1;
	CloseHandle(pi.hThread);
	Wait(INFINITE);
	return GetExitCode();
}

/**********************************************************************//**
 *
 * vZX̏IR[h̎擾
 * 
 ----------------------------------------------------------------------
 * @return	IR[h
*//***********************************************************************/
DWORD CProcess::GetExitCode(void) const
{
	DWORD dwCode = 0;
	::GetExitCodeProcess(m_hObject, &dwCode);
	return dwCode;
}

#if	!defined(IRIS_WIN32_WCE)
/**********************************************************************//**
 *
 * vZXID̎擾
 * 
 ----------------------------------------------------------------------
 * @return	vZXID
*//***********************************************************************/
DWORD CProcess::GetProcessId(void) const
{
	return ::GetProcessId(m_hObject);
}

/**********************************************************************//**
 *
 * vZX̎ԏ̎擾
 * 
 ----------------------------------------------------------------------
 * @param [out]	lpCreationTime	= vZX̍쐬
 * @param [out]	lpExitTime		= vZX̏I
 * @param [out]	lpKernelTime	= vZX̃J[l[hł̌oߎ
 * @param [out]	lpUserTime		= vZX̃[U[[hł̌oߎ
 * @return	
*//***********************************************************************/
BOOL CProcess::GetProcessTimes(LPFILETIME lpCreationTime, LPFILETIME lpExitTime, LPFILETIME lpKernelTime, LPFILETIME lpUserTime) const
{
	return ::GetProcessTimes(m_hObject, lpCreationTime, lpExitTime, lpKernelTime, lpUserTime);
}

/**********************************************************************//**
 *
 * vZX̃J[l[hł̌oߎԂ擾
 * 
 ----------------------------------------------------------------------
 * @param [out]	lpKernelTime	= vZX̃J[l[hł̌oߎ
 * @return	
*//***********************************************************************/
BOOL CProcess::GetProcessKernelTime(LPFILETIME lpKernelTime) const
{
	return ::GetProcessTimes(m_hObject, nullptr, nullptr, lpKernelTime, nullptr);
}
#endif

/**********************************************************************//**
 *
 * J
 * 
 ----------------------------------------------------------------------
 * @param [in]	dwProcessId		= vZXID
 * @param [in]	dwDesiredAccess	= (PROCESS_***)
 * @param [in]	bInheritHandle	= p邩ǂ
 * @return	
*//***********************************************************************/
BOOL CProcess::Open(DWORD dwProcessId, DWORD dwDesiredAccess, BOOL bInheritHandle)
{
	HANDLE hProcess = ::OpenProcess(dwDesiredAccess, bInheritHandle, dwProcessId);
	if( hProcess == nullptr ) return FALSE;
	return TryAttach(hProcess);
}

/**********************************************************************//**
 *
 * J
 * 
 ----------------------------------------------------------------------
 * @param [out]	lppid	= vZXo
 * @param [in]	lppis	= vZX
 * @return	
*//***********************************************************************/
BOOL CProcess::_Create(LPPROCESS_INFORMATION lppid, LPPROCESS_INFORMATION lppis)
{
	IRIS_ASSERT( lppis != nullptr );
	if( lppid == nullptr ) 
	{
		::CloseHandle(lppis->hThread);
		return TryAttach(lppis->hProcess);
	}

	*lppid = *lppis;
	Attach(lppis->hProcess);	// lppid ɏo͂ł̂ŁA֘AtsĂOKƂ
	return TRUE;
}

// CProcessInfo
/**********************************************************************//**
 *
 * fXgN^
 * 
*//***********************************************************************/
CProcessInfo::~CProcessInfo(void)
{
}

/**********************************************************************//**
 *
 * nh
 * 
*//***********************************************************************/
void CProcessInfo::Close(void)
{
	if( m_Info.hProcess != nullptr )
	{
		CloseHandle(m_Info.hProcess);
		m_Info.hProcess = nullptr;
	}
	if( m_Info.hThread != nullptr )
	{
		CloseHandle(m_Info.hThread);
		m_Info.hProcess = nullptr;
	}
}

/**********************************************************************//**
 *
 * vZXI
 * 
*//***********************************************************************/
void CProcessInfo::Exit(void)
{
	if( m_Info.hThread != nullptr )
		PostThreadMessage(m_Info.dwThreadId, WM_QUIT, 0, 0);
}

}	// end of namespace wx
}	// end of namespace iris

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "../../../../unit/UnitCore.h"
#include "../../../../iris_using.h"
#include "../../../../iris_iostream.h"

//======================================================================
// test
IRIS_UNITTEST(CWXProcess, Create)
{
	CHAR cmd[256];
	std::cout << "> ";
	std::safe_cin >> cmd;
	std::string argv = cmd;
	while(1)
	{
		if( std::safe_cin.peek() == 0x0a )
		{
			break;
		}
		std::cin >> cmd;
		argv += " ";
		argv += cmd;
	}
	SECURITY_ATTRIBUTES securityAttr;
	ZeroMemory( &securityAttr, sizeof(securityAttr) );
	securityAttr.nLength = sizeof(securityAttr);
	securityAttr.bInheritHandle = TRUE;
	securityAttr.lpSecurityDescriptor = NULL;
	CProcess proc;
	CStartupInfoA si;
	si.GetSelf();
	si.UseStdHandles();
	si.Show();
	proc.Create<CHAR>(nullptr, (LPSTR)argv.c_str(), &securityAttr, nullptr
		, TRUE, 0, nullptr, nullptr, si, nullptr);

	proc.Join();
}

#endif
