//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXPipe.h
 * @brief		pCvNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXPipe_H_
#define INCG_IRIS_WXPipe_H_

//======================================================================
// include
#include "../io/WXHFile.h"

#if	defined(IRIS_WIN32_WCE)
#error	not support.
#endif

namespace iris {
namespace wx
{

//======================================================================
// class
/// OtpCvNX
class CNamedPipe : public CHFile
{
public:
	// RXgN^
	CNamedPipe(void);
	CNamedPipe(HANDLE hFile);
	// fXgN^
	virtual ~CNamedPipe(void);

public:
	// 쐬
	BOOL	Create (LPCTSTR lpPipeName, DWORD dwOpenMode, DWORD dwPipeMode, DWORD nMaxInstance
					, DWORD nOutBufferSize, DWORD nInBufferSize, DWORD nTimeout, LPSECURITY_ATTRIBUTES lpSecurityAttributes);
	BOOL	CreateA(LPCSTR  lpPipeName, DWORD dwOpenMode, DWORD dwPipeMode, DWORD nMaxInstance
					, DWORD nOutBufferSize, DWORD nInBufferSize, DWORD nTimeout, LPSECURITY_ATTRIBUTES lpSecurityAttributes);
	BOOL	CreateW(LPCWSTR lpPipeName, DWORD dwOpenMode, DWORD dwPipeMode, DWORD nMaxInstance
					, DWORD nOutBufferSize, DWORD nInBufferSize, DWORD nTimeout, LPSECURITY_ATTRIBUTES lpSecurityAttributes);

	// ڑ
	BOOL	Connect(LPOVERLAPPED lpOverlapped);
	// ؒf
	BOOL	Disconnect(void);

	// pCṽf[^Rs[я̎擾
	BOOL	Peek(LPVOID lpBuffer, DWORD dwBufferSize, LPDWORD lpBytesRead, LPDWORD lpTotalBytesAvail, LPDWORD lpBytesLeftThisMessage);
	// pCv̑
	BOOL	Transact(LPVOID lpInBuffer, DWORD dwInBufferSize, LPVOID lpOutBuffer, DWORD dwOutBufferSize, LPDWORD lpBytesRead, LPOVERLAPPED lpOverlapped);

public:
	// Ԃ̎擾
	BOOL	GetState (LPDWORD lpState, LPDWORD lpCurInstances, LPDWORD lpMaxCollectionCount, LPDWORD lpCollectDataTimeout
				, LPTSTR lpUserName, DWORD nMaxUserNameSize) const;
	BOOL	GetStateA(LPDWORD lpState, LPDWORD lpCurInstances, LPDWORD lpMaxCollectionCount, LPDWORD lpCollectDataTimeout
				, LPSTR  lpUserName, DWORD nMaxUserNameSize) const;
	BOOL	GetStateW(LPDWORD lpState, LPDWORD lpCurInstances, LPDWORD lpMaxCollectionCount, LPDWORD lpCollectDataTimeout
				, LPWSTR lpUserName, DWORD nMaxUserNameSize) const;

	// Ԃ̐ݒ
	BOOL	SetState(LPDWORD lpMode, LPDWORD lpMaxCollectionCount, LPDWORD lpCollectDataTimeout);

	// ̎擾
	BOOL	GetInfo(LPDWORD lpFlags, LPDWORD lpOutBufferSize, LPDWORD lpInBufferSize, LPDWORD lpMaxInstances)	const;

public:

	// ZLeB̎擾
	BOOL	GetAttribute(PIPE_ATTRIBUTE_TYPE AttributeType, LPSTR lpAttributeName
				, LPVOID lpAttributeValue, PSIZE_T lpAttributeValueLength) const;
	// ZLeB̐ݒ
	BOOL	SetAttribute(PIPE_ATTRIBUTE_TYPE AttributeType, LPSTR lpAttributeName
				, LPVOID lpAttributeValue, SIZE_T AttributeValueLength);

	// NCAgPC擾
	BOOL	GetClientComputerName (LPTSTR lpName, DWORD dwLength) const;
	BOOL	GetClientComputerNameA(LPSTR  lpName, DWORD dwLength) const;
	BOOL	GetClientComputerNameW(LPWSTR lpName, DWORD dwLength) const;

	// NCAg̃vZXID擾
	BOOL	GetClientProcessID(PULONG lpProcessID) const;
	// NCAg̃ZbVID擾
	BOOL	GetClientSessionID(PULONG lpSessionID) const;
	// T[o[̃vZXID擾
	BOOL	GetServerProcessID(PULONG lpProcessID) const;
	// T[o[̃ZbVID擾
	BOOL	GetServerSessionID(PULONG lpSessionID) const;

};

/// OȂpCvNX
class CPipe : public INonCopyable<CPipe>
{
protected:
	CNamedPipe	m_ReadPipe;		//!< ǂݎppCv
	CNamedPipe	m_WritePipe;	//!< ݗppCv
public:
	// RXgN^
	CPipe(void);
	CPipe(HANDLE hRead, HANDLE hWrite);
	// fXgN^
	~CPipe(void);

public:
	// ֘At
	BOOL	Attach(HANDLE hRead, HANDLE hWrite);
	// ֘At̉
	BOOL	Detach(PHANDLE hRead, PHANDLE hWrite);
public:
	// 쐬
	BOOL	Create(LPSECURITY_ATTRIBUTES lpAttribute=nullptr, DWORD dwSize=0);
	// 
	bool	Close(void);

public:
	/// ǂݎppCv̎擾
	CNamedPipe&	GetReadPipe(void)	{ return m_ReadPipe; }
	/// ݗppCv̎擾
	CNamedPipe&	GetWritePipe(void)	{ return m_WritePipe; }
};


}	// end of namespace wx
}	// end of namespace iris

#endif
