//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXInternetFile.cpp
 * @brief		C^[lbgt@CNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXInternetFile_CPP_

//======================================================================
// include
#include "WXInternetFile.h"

//======================================================================
#pragma comment ( lib, "wininet.lib" )

namespace iris {
namespace wx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CInternetFile::CInternetFile(void)
{
}

/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	hFile		= ֘Atnh
*//***********************************************************************/
CInternetFile::CInternetFile(HINTERNET hFile)
: CInetBase(hFile)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CInternetFile::~CInternetFile(void)
{
}

/**********************************************************************//**
 *
 * t@Cobt@TCY̎擾
 *
 ----------------------------------------------------------------------
 * @param [out]	lpdwAvailable	= o
 * @param [in]	dwFlags			= tO(INTERNET_FLAG_***)
 * @param [in]	dwContext		= 0
 * @return	
*//***********************************************************************/
BOOL CInternetFile::QueryDataAvailable(LPDWORD lpdwAvailable, DWORD dwFlags, DWORD_PTR dwContext)
{
	return InternetQueryDataAvailable(m_hInternet, lpdwAvailable, dwFlags, dwContext);
}

/**********************************************************************//**
 *
 * Ǎ
 *
 ----------------------------------------------------------------------
 * @param [out]	lpBuffer		= o̓obt@
 * @param [in]	dwBufferSize	= o̓obt@TCY
 * @param [in]	lpdwReadSize	= Ǎ݃TCY
 * @return	
*//***********************************************************************/
BOOL CInternetFile::Read(LPVOID lpBuffer, DWORD dwBufferSize, LPDWORD lpdwReadSize)
{
	return InternetReadFile(m_hInternet, lpBuffer, dwBufferSize, lpdwReadSize);
}

/**********************************************************************//**
 *
 * Ǎ
 *
 ----------------------------------------------------------------------
 * @param [out]	lpBuffers		= o̓obt@(LPINTERNET_BUFFERS)
 * @param [in]	dwFlags			= 
 * @param [in]	dwContext		= 0
 * @return	
*//***********************************************************************/
BOOL CInternetFile::ReadEx (LPINTERNET_BUFFERS  lpBuffers, DWORD dwFlags, DWORD_PTR dwContext)
{
	return InternetReadFileEx (m_hInternet, lpBuffers, dwFlags, dwContext);
}
/// CInternetFile::ReadFileEx Q
BOOL CInternetFile::ReadExA(LPINTERNET_BUFFERSA lpBuffers, DWORD dwFlags, DWORD_PTR dwContext)
{
	return InternetReadFileExA(m_hInternet, lpBuffers, dwFlags, dwContext);
}
/// CInternetFile::ReadFileEx Q
BOOL CInternetFile::ReadExW(LPINTERNET_BUFFERSW lpBuffers, DWORD dwFlags, DWORD_PTR dwContext)
{
	return InternetReadFileExW(m_hInternet, lpBuffers, dwFlags, dwContext);
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @param [in]	lpBuffer		= ̓obt@
 * @param [in]	dwBufferSize	= ̓obt@TCY
 * @param [in]	lpdwWrittenSize	= ݃TCY
 * @return	
*//***********************************************************************/
BOOL CInternetFile::Write(LPCVOID lpBuffer, DWORD dwBufferSize, LPDWORD lpdwWrittenSize)
{
	return InternetWriteFile(m_hInternet, lpBuffer, dwBufferSize, lpdwWrittenSize);
}

/**********************************************************************//**
 *
 * t@CTCY擾
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
DWORD CInternetFile::GetSize(void) const
{
	DWORD preLow = Tell();
	InternetSetFilePointer(m_hInternet, 0, nullptr, FILE_END, 0);
	DWORD size = Tell();
	InternetSetFilePointer(m_hInternet, preLow, nullptr, FILE_BEGIN, 0);
	return size;
}

/**********************************************************************//**
 *
 * t@C̈ʒu擾
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
DWORD CInternetFile::Tell(void) const
{
	return InternetSetFilePointer(m_hInternet, 0, nullptr, FILE_CURRENT, 0);
}

/**********************************************************************//**
 *
 * t@C̈ʒuړ
 *
 ----------------------------------------------------------------------
 * @param [in]	lDistanceToMove		= ړ
 * @param [in]	dwMoveMethod		= ړ@
 * @param [in]	dwContext			= 0
 * @return	
*//***********************************************************************/
DWORD CInternetFile::Seek(LONG lDistanceToMove, DWORD dwMoveMethod, DWORD_PTR dwContext)
{
	return InternetSetFilePointer(m_hInternet, lDistanceToMove, nullptr, dwMoveMethod, dwContext);
}

/**********************************************************************//**
 *
 * t@C̈ʒu擾
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
DWORD CInternetFile::SetEndOfFile(void)
{
	return Seek(0, FILE_END, 0);
}

/**********************************************************************//**
 *
 * bN
 *
 ----------------------------------------------------------------------
 * @param [in]	lphLockRequestInfo	= 
 * @return	
*//***********************************************************************/
BOOL CInternetFile::LockRequest(HANDLE* lphLockRequestInfo)
{
	return InternetLockRequestFile(m_hInternet, lphLockRequestInfo);
}

/**********************************************************************//**
 *
 * bN̉
 *
 ----------------------------------------------------------------------
 * @param [in]	hLockRequestInfo	= 
 * @return	
*//***********************************************************************/
BOOL CInternetFile::UnlockRequest(HANDLE hLockRequestInfo)
{
	return InternetUnlockRequestFile(hLockRequestInfo);
}


}	// end of namespace wx
}	// end of namespace iris
