//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXHTTP.cpp
 * @brief		HTTPNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXHTTP_CPP_

//======================================================================
// include
#include "WXHTTP.h"

//======================================================================
#pragma comment ( lib, "wininet.lib" )

namespace iris {
namespace wx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CHTTP::CHTTP(void)
{
}

/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	hConnect		= ֘Atnh
*//***********************************************************************/
CHTTP::CHTTP(HINTERNET hConnect)
: CInternet(hConnect)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CHTTP::~CHTTP(void)
{
}

/**********************************************************************//**
 *
 * J
 *
 ----------------------------------------------------------------------
 * @param [in]	lpszVerb			= 
 * @param [in]	lpszObjectName		= 
 * @param [in]	lpszVersion			= 
 * @param [in]	lpszReferrer		= 
 * @param [in]	lplpszAcceptTypes	= 
 * @param [in]	dwFlags				= 
 * @param [in]	dwContext			= 
 * @return	
*//***********************************************************************/
HINTERNET CHTTP::OpenRequest (LPCTSTR lpszVerb, LPCTSTR lpszObjectName, LPCTSTR lpszVersion, LPCTSTR lpszReferrer
								, LPCTSTR* lplpszAcceptTypes, DWORD dwFlags, DWORD_PTR dwContext)
{
	return ::HttpOpenRequest (m_hInternet, lpszVerb, lpszObjectName, lpszVersion, lpszReferrer, lplpszAcceptTypes, dwFlags, dwContext);
}
HINTERNET CHTTP::OpenRequestA(LPCSTR  lpszVerb, LPCSTR  lpszObjectName, LPCSTR  lpszVersion, LPCSTR  lpszReferrer
								, LPCSTR*  lplpszAcceptTypes, DWORD dwFlags, DWORD_PTR dwContext)
{
	return ::HttpOpenRequestA(m_hInternet, lpszVerb, lpszObjectName, lpszVersion, lpszReferrer, lplpszAcceptTypes, dwFlags, dwContext);
}
HINTERNET CHTTP::OpenRequestW(LPCWSTR lpszVerb, LPCWSTR lpszObjectName, LPCWSTR lpszVersion, LPCWSTR lpszReferrer
								, LPCWSTR* lplpszAcceptTypes, DWORD dwFlags, DWORD_PTR dwContext)
{
	return ::HttpOpenRequestW(m_hInternet, lpszVerb, lpszObjectName, lpszVersion, lpszReferrer, lplpszAcceptTypes, dwFlags, dwContext);
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @param [in]	lpszHeaders			= 
 * @param [in]	dwHeadersLength		= 
 * @param [in]	dwModifiers			= 
 * @return	
*//***********************************************************************/
BOOL CHTTP::AddRequestHeaders (LPCTSTR lpszHeaders, DWORD dwHeadersLength, DWORD dwModifiers)
{
	return ::HttpAddRequestHeaders (m_hInternet, lpszHeaders, dwHeadersLength, dwModifiers);
}
/// CHTTP::AddRequestHeaders Q
BOOL CHTTP::AddRequestHeadersA(LPCSTR  lpszHeaders, DWORD dwHeadersLength, DWORD dwModifiers)
{
	return ::HttpAddRequestHeadersA(m_hInternet, lpszHeaders, dwHeadersLength, dwModifiers);
}
/// CHTTP::AddRequestHeaders Q
BOOL CHTTP::AddRequestHeadersW(LPCWSTR lpszHeaders, DWORD dwHeadersLength, DWORD dwModifiers)
{
	return ::HttpAddRequestHeadersW(m_hInternet, lpszHeaders, dwHeadersLength, dwModifiers);
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @param [in]	lpszHeaders			= 
 * @param [in]	dwHeadersLength		= 
 * @param [in]	lpOptional			= 
 * @param [in]	dwOptionalLength	= 
 * @return	
*//***********************************************************************/
BOOL CHTTP::SendRequest (LPCTSTR lpszHeaders, DWORD dwHeadersLength, LPVOID lpOptional, DWORD dwOptionalLength)
{
	return ::HttpSendRequest (m_hInternet, lpszHeaders, dwHeadersLength, lpOptional, dwOptionalLength);
}
/// CHTTP::SendRequest Q
BOOL CHTTP::SendRequestA(LPCSTR  lpszHeaders, DWORD dwHeadersLength, LPVOID lpOptional, DWORD dwOptionalLength)
{
	return ::HttpSendRequestA(m_hInternet, lpszHeaders, dwHeadersLength, lpOptional, dwOptionalLength);
}
/// CHTTP::SendRequest Q
BOOL CHTTP::SendRequestW(LPCWSTR lpszHeaders, DWORD dwHeadersLength, LPVOID lpOptional, DWORD dwOptionalLength)
{
	return ::HttpSendRequestW(m_hInternet, lpszHeaders, dwHeadersLength, lpOptional, dwOptionalLength);
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @param [in]	lpBuffersIn			= 
 * @param [in]	lpBuffersOut		= 
 * @param [in]	dwFlags				= 
 * @param [in]	dwContext			= R[obN֐ɓnl
 * @return	
*//***********************************************************************/
BOOL CHTTP::SendRequestEx (LPINTERNET_BUFFERS  lpBuffersIn, LPINTERNET_BUFFERS  lpBuffersOut, DWORD dwFlags, DWORD_PTR dwContext)
{
	return ::HttpSendRequestEx (m_hInternet, lpBuffersIn, lpBuffersOut, dwFlags, dwContext);
}
/// CHTTP::SendRequestEx Q
BOOL CHTTP::SendRequestExA(LPINTERNET_BUFFERSA lpBuffersIn, LPINTERNET_BUFFERSA lpBuffersOut, DWORD dwFlags, DWORD_PTR dwContext)
{
	return ::HttpSendRequestExA(m_hInternet, lpBuffersIn, lpBuffersOut, dwFlags, dwContext);
}
/// CHTTP::SendRequestEx Q
BOOL CHTTP::SendRequestExW(LPINTERNET_BUFFERSW lpBuffersIn, LPINTERNET_BUFFERSW lpBuffersOut, DWORD dwFlags, DWORD_PTR dwContext)
{
	return ::HttpSendRequestExW(m_hInternet, lpBuffersIn, lpBuffersOut, dwFlags, dwContext);
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @param [in]	lpBuffersOut		= 
 * @param [in]	dwFlags				= 
 * @param [in]	dwContext			= R[obN֐ɓnl
 * @return	
*//***********************************************************************/
BOOL CHTTP::EndRequest (LPINTERNET_BUFFERS  lpBuffersOut, DWORD dwFlags, DWORD_PTR dwContext)
{
	return ::HttpEndRequest (m_hInternet, lpBuffersOut, dwFlags, dwContext);
}
/// CHTTP::EndRequest Q
BOOL CHTTP::EndRequestA(LPINTERNET_BUFFERSA lpBuffersOut, DWORD dwFlags, DWORD_PTR dwContext)
{
	return ::HttpEndRequestA(m_hInternet, lpBuffersOut, dwFlags, dwContext);
}
/// CHTTP::EndRequest Q
BOOL CHTTP::EndRequestW(LPINTERNET_BUFFERSW lpBuffersOut, DWORD dwFlags, DWORD_PTR dwContext)
{
	return ::HttpEndRequestW(m_hInternet, lpBuffersOut, dwFlags, dwContext);
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @param [in]	dwInfoLevel			= 
 * @param [in]	lpBuffer			= 
 * @param [in]	lpdwBufferLength	= 
 * @param [in]	lpdwIndex			= 
 * @return	
*//***********************************************************************/
BOOL CHTTP::QueryInfo (DWORD dwInfoLevel, LPVOID lpBuffer, LPDWORD lpdwBufferLength, LPDWORD lpdwIndex)
{
	return ::HttpQueryInfo (m_hInternet, dwInfoLevel, lpBuffer, lpdwBufferLength, lpdwIndex);
}
/// CHTTP::QueryInfo Q
BOOL CHTTP::QueryInfoA(DWORD dwInfoLevel, LPVOID lpBuffer, LPDWORD lpdwBufferLength, LPDWORD lpdwIndex)
{
	return ::HttpQueryInfoA(m_hInternet, dwInfoLevel, lpBuffer, lpdwBufferLength, lpdwIndex);
}
/// CHTTP::QueryInfo Q
BOOL CHTTP::QueryInfoW(DWORD dwInfoLevel, LPVOID lpBuffer, LPDWORD lpdwBufferLength, LPDWORD lpdwIndex)
{
	return ::HttpQueryInfoW(m_hInternet, dwInfoLevel, lpBuffer, lpdwBufferLength, lpdwIndex);
}

}	// end of namespace wx
}	// end of namespace iris
