//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXKeyboard.cpp
 * @brief		L[{[h t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXKeyboard_CPP_

//======================================================================
// include
#include "WXKeyboard.h"
#include "iris_debug.h"

#if !defined(IRIS_WIN32_WCE)

namespace iris {
namespace wx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 * 
*//***********************************************************************/
CKeyboard::CKeyboard(void)
{
}

/**********************************************************************//**
 *
 * fXgN^
 * 
*//***********************************************************************/
CKeyboard::~CKeyboard(void)
{
}

/**********************************************************************//**
 *
 * XV
 * 
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
bool CKeyboard::Update(void)
{
	u8 tmp[MAX_KEYFRAMES];
	if( !GetKeyboardState(tmp) ) return false;

	const u8* ptmp = tmp;
	u8* state = m_State;
	for( int i=0; i < MAX_KEYFRAMES; ++i, ++state, ++ptmp )
	{
		u8 cnt = *state & 0x3F;
		*state >>= 1;
		if( *ptmp & 0x80 )
		{
			*state |= 0x80;
			++cnt;
			*state &= 0xC0;
			*state |= cnt & 0x3F;
		}
		else
		{
			*state &= 0x40;
		}		
	}
	return true;
}

/**********************************************************************//**
 *
 * L[Ԃ̎擾
 * 
 ----------------------------------------------------------------------
 * @param [in]	nIndex	= CfbNX
 * @return	
*//***********************************************************************/
u8 CKeyboard::GetState(u8 nIndex) const
{
	//IRIS_ASSERT( nIndex < 0 || nIndex >= MAX_KEYFRAMES );
	return m_State[nIndex];
}


}	// end of namespace wx
}	// end of namespace iris

#endif
