//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXDeviceContext.h
 * @brief		foCXReLXgt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXDeviceContext_H_
#define INCG_IRIS_WXDeviceContext_H_

//======================================================================
// include
#include "fnd/image/FndImage.h"

namespace iris {
namespace wx
{

//======================================================================
// define

//======================================================================
// class
//! foCXReLXgNX
class CDeviceContext : public fnd::IImage
{
public:
	typedef HDC		HandleType;
protected:
	HDC		m_hDC;	//!< foCXReLXg
public:
	// RXgN^
	CDeviceContext(void);
	CDeviceContext(HDC hdc);
	// fXgN^
	virtual ~CDeviceContext(void);

public:
    // foCXReLXg֘At
    bool		Attach(HDC hDC);
    // foCXReLXg̊֘At𕪗
    HDC			Detach(void);
    // foCXƃeLXgƌ݊̂郁foCXReLXg̍쐬
    HDC			CreateCompatibleDC(void);
    // foCXReLXgj
    BOOL		DeleteDC(void);
	// 
	BOOL		Release(HWND hWnd);

public:
	// NbsO
	// ̃NbsO[WAw肳ꂽ`O
	int			ExcludeClipRect(int left, int top, int right, int bottom);
	int			ExcludeClipRect(LPRECT lprc)	{ return ExcludeClipRect(lprc->left, lprc->top, lprc->right, lprc->bottom); }
	// ݂̃NbsO[WɁA`
	int			IntersectClipRect(int left, int top, int right, int bottom);
	int			IntersectClipRect(LPRECT lprc)	{ return IntersectClipRect(lprc->left, lprc->top, lprc->right, lprc->bottom); }
#if	!defined(IRIS_WIN32_WCE)
	// ݂̃[Wƍ
	int			ExtSelectClipRgn(HRGN hRgn, int mode);
	// ݂̃pXƃ[W
	BOOL		SelectClipPath(int mode);
#endif
	// [Wݒ
	int			SelectClipRgn(HRGN hRgn);
	// foCX̍ŏ̉`擾
	int			GetClipBox(LPRECT lprc) const;
	// ݂̃[W擾
	BOOL		GetClipRgn(HRGN hRgn) const;
#if	!defined(IRIS_WIN32_WCE)
	// ݂̃^̈̎擾
	BOOL		GetMetaRgn(HRGN hRgn) const;
	// VXeNbsO[WRs[
	BOOL		GetRandomRgn(HRGN hRgn) const;
	// NbsO[Ẅړ
	int			OffsetClipRgn(int x, int y);
#endif
	// wWNbsO[Wɂ邩ǂ
#if	!defined(IRIS_WIN32_WCE)
	BOOL		PtVisible(int x, int y) const;
#endif
	// w`NbsO[Wɂ邩ǂ
	BOOL		RectVisible(const LPRECT lprc) const;

public:
    // foCXReLXgɃIuWFNgI
    HGDIOBJ		SelectObject(HGDIOBJ hGDI);
    // foCXReLXgփrbg}bvRs[
    BOOL		BitBlt(int x, int y, int nWidth, int nHeight, HDC SrcDC, int xSrc, int ySrc, DWORD dwRop);
    // rbg}bvgEkăRs[
    BOOL		StretchBlt(int x, int y, int nWidth, int nHeight, HDC SrcDC, int xSrc, int ySrc, int nSrcWidth, int nSrcHeight, DWORD dwRop);

public:
	// wiJ[
	COLORREF	SetBkColor(COLORREF color);
	COLORREF	GetBkColor(void) const;
	// wi[h
	int			SetBkMode(int mode);
	int			GetBkMode(void) const;

public:
	// eLXgJ[
	COLORREF	SetTextColor(COLORREF color);
	COLORREF	GetTextColor(void) const;
    // eLXgẅʒuɏo͂
	template<typename CHARTYPE_>
    BOOL		TextOut(int x, int y, int nCount, const CHARTYPE_* lpszString);
	template<typename CHARTYPE_>
	BOOL		TextOut(int x, int y, const CHARTYPE_* lpszString, ...);
	// eLXg`
	template<typename CHARTYPE_>
	BOOL		DrawText(LPRECT lprc, UINT format, int nCount, const CHARTYPE_* lpszString);
	template<typename CHARTYPE_>
	BOOL		DrawText(LPRECT lprc, UINT format, const CHARTYPE_* lpszString, ...);

public:
	// At@uh
	BOOL		AlphaBlend(int xorgDest, int yorgDest, int wDest, int hDest
		, HDC hdcSrc, int xorgSrc, int yorgSrc, int wSrc, int hSrc, const BLENDFUNCTION& ftn);
public:
	// _ړ
	BOOL		MoveToEx(int x, int y, LPPOINT lppt=nullptr);

	// 
	BOOL		LineTo(int x, int y);
	// A
	BOOL		Polyline(const POINT* apt, int cpt);		// Jg|WVύXȂ
#if	!defined(IRIS_WIN32_WCE)
	BOOL		PolylineTo(const POINT* apt, DWORD cpt);
	// ̘A
	BOOL		PolyPolyline(const POINT* apt, const DWORD *asz, DWORD csz);
	// xWFȐ̕`
	BOOL		PolyBezierTo(const POINT* apt, DWORD cpt);	// Jg|WV_ɕ`
	BOOL		PolyBezier(const POINT* apt, DWORD cpt);	// Jg|WV̉e󂯂Ȃ
#endif

	// ~̕`
	BOOL		Ellipse(int left, int top, int right, int bottom);
	BOOL		Ellipse(const RECT* lprc)	{ return Ellipse(lprc->left, lprc->top, lprc->right, lprc->bottom); }
	// ʂ̕`
#if	!defined(IRIS_WIN32_WCE)
	BOOL		Arc	 (int left, int top, int right, int bottom, int sx, int sy, int ex, int ey);
	BOOL		Pie	 (int left, int top, int right, int bottom, int sx, int sy, int ex, int ey);
	BOOL		Chord(int left, int top, int right, int bottom, int sx, int sy, int ex, int ey);
	BOOL		Arc	 (const RECT* lprc, int sx, int sy, int ex, int ey)	{ return Arc(lprc->left, lprc->top, lprc->right, lprc->bottom, sx, sy, ex, ey); }
	BOOL		Pie	 (const RECT* lprc, int sx, int sy, int ex, int ey)	{ return Pie(lprc->left, lprc->top, lprc->right, lprc->bottom, sx, sy, ex, ey); }
	BOOL		Chord(const RECT* lprc, int sx, int sy, int ex, int ey)	{ return Chord(lprc->left, lprc->top, lprc->right, lprc->bottom, sx, sy, ex, ey); }
#endif

	// `̕`
	BOOL		Rectangle(int left, int top, int right, int bottom);
	BOOL		Rectangle(const RECT* lprc)	{ return Rectangle(lprc->left, lprc->top, lprc->right, lprc->bottom); }
	// pے`̕`
	BOOL		RoundRect(int left, int top, int right, int bottom, int width, int height);
	BOOL		RoundRect(const RECT* lprc, int width, int height) { return RoundRect(lprc->left, lprc->top, lprc->right, lprc->bottom, width, height); }
	// p`̕`
	BOOL		Polygon(const POINT* apt, int cpt);
#if	!defined(IRIS_WIN32_WCE)
	// p`hԂ[h
	int			SetPolyFillMode(int mode);
	int			GetPolyFillMode(void);
#endif

	// hԂ
	BOOL		FillRect(const RECT* lprc, HBRUSH hbr);
#if	!defined(IRIS_WIN32_WCE)
	BOOL		FrameRect(const RECT* lprc, HBRUSH hbr);	// g
#endif
	// [W`
	BOOL		FillRgn(HRGN hrgn, HBRUSH hbr);
	BOOL		PaintRgn(HRGN hrgn);	// DC̃uVgp
#if	!defined(IRIS_WIN32_WCE)
	BOOL		FrameRgn(HRGN hrgn, HBRUSH hbr, int width, int height);	// g
#endif

	// sNZ`
	COLORREF	SetPixel(int x, int y, COLORREF color);
#if	!defined(IRIS_WIN32_WCE)
	BOOL		SetPixelV(int x, int y, COLORREF color);
#endif
	// sNZJ[̎擾
	COLORREF	GetPixel(int x, int y) const;

public:
	// X^Iy[V
	int			SetROP2(int rop2);
	int			GetROP2(void) const;

public:
	// ݂̃uVŃT[tFCXhԂ
#if	!defined(IRIS_WIN32_WCE)
	BOOL		FloodFill(int x, int y, COLORREF color);
	// ݂̃uVŃT[tFCXhԂ
	BOOL		ExtFloodFill(int x, int y, COLORREF color, UINT uFillType);
#endif

	// `ƎOp`hԂ
	BOOL		GradientFill(LPTRIVERTEX lpVertex, ULONG nVertex, LPVOID pMesh, ULONG nMesh, ULONG ulMode);

public:
	// ݑIĂ DIB ZNṼrbg}bṽJ[e[ũGgF擾
	UINT		GetDIBColorTable(UINT uStartIndex, UINT uEntryies, LPRGBQUAD lpColors) const;
	// rbg}bvLk[h擾
	int			GetStretchBltMode(void) const;
	// rbg}bvLk[hݒ
	int			SetStretchBltMode(int mode);

public:
	// LȃC[Wǂ
	virtual bool	IsValid(void)	const;
	// ̎擾
	virtual s32		GetWidth(void)	const;
	// ̎擾
	virtual s32		GetHeight(void)	const;
	
public:
	// sNZJ[̎擾
	virtual bool		GetPixelRGBA8888(s32 x, s32 y, IrisRGBA8888& rgba) const;
	// sNZJ[̐ݒ
	virtual bool		SetPixelRGBA8888(s32 x, s32 y, const IrisRGBA8888& rgba);

public:
	// set,get
    // foCXReLXg̎擾
	HDC			GetDC(void)			{ return m_hDC; }
    // foCXReLXg̎擾
	operator	HDC (void)			{ return m_hDC; }
};

}	// end of namespace wx
}	// end of namespace iris

#endif

