//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXPlugin.h
 * @brief		vOCNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXPlugin_H_
#define INCG_IRIS_WXPlugin_H_

//======================================================================
// include
#include "fnd/utility/FndUID.h"
#include <map>

namespace iris {
namespace wx
{

//======================================================================
// class
//! vOCx[XNX
class IPluginBase : public INonCopyable<IPluginBase>
{
	friend class CPluginManegr;
private:
	s32	m_ID;	//!< vOCBID
public:
	// RXgN^
	IPluginBase(void) : m_ID(0) {}
	// fXgN^
	virtual ~IPluginBase(void) {}

public:
	// vOCo^̏
	virtual	bool			OnCreate(void)	{ return true; }
	// vOC폜̏
	virtual	void			OnDelete(void)	{}

public:
	// UID̎擾
	int				GetID(void)	{ return m_ID; }
};

//! vOCǗNX
class CPluginManegr : public INonCopyable<>
{
public:
	typedef std::pair<IPluginBase*, HMODULE>	InfoPair;
	typedef std::map<s32, InfoPair>		PluginMap;
	typedef std::pair<s32, InfoPair>	PluginPair;
	typedef PluginMap::iterator			iterator;

private:
	PluginMap	m_Plugins;
	fnd::CUIDGenerator<1024, 10800>	m_UID;
public:
	// RXgN^
	CPluginManegr(void);
	// fXgN^
	~CPluginManegr(void);

public:
	// 
	bool	Initialize(void);
	// 
	void	Release(void);
	// vOCdll̓Ǎ
	s32		LoadPulgin(LPCTSTR fname);
	// vOC̉
	bool	UnloadPulgin(s32 id);

public:
	// vOCNX̎擾
	iterator	begin(void);
	// vOCNX̎擾
	iterator	end(void);
};

}	// end of namespace wx
}	// end of namespace iris

//======================================================================
// function
EXTERN_C_BEGIN

IRIS_DLLEXPORT iris::wx::IPluginBase* WINAPI CreatePluginInstance(void);
IRIS_DLLEXPORT void WINAPI DeletePluginInstance(iris::wx::IPluginBase* lpPlugin);

EXTERN_C_END

#endif
