//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXToolHelp.h
 * @brief		toolhelp֐bp[NXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXToolHelp_H_
#define INCG_IRIS_WXToolHelp_H_

//======================================================================
// include
#include "iris_object.h"
#include <tlhelp32.h>

typedef tagMODULEENTRY32	MODULEENTRY32A;
typedef MODULEENTRY32A		*PMODULEENTRY32A;
typedef MODULEENTRY32A		*LPMODULEENTRY32A;

typedef tagPROCESSENTRY32	PROCESSENTRY32A;
typedef PROCESSENTRY32A		*PPROCESSENTRY32A;
typedef PROCESSENTRY32A		*LPPROCESSENTRY32A;

namespace iris {
namespace wx
{

//======================================================================
// class
//! toolhelp֐bp[NX
class CToolHelp : public IIrisObject
{
	class CImpl;
	CImpl*	m_pImpl;
public:
	// RXgN^
	CToolHelp(void);
	// fXgN^
	~CToolHelp(void);

	// 
	// RXgN^
    CToolHelp( const CToolHelp& rObject );
    // 
    CToolHelp& operator = ( CToolHelp& rObject );
public:
	// 
	static CToolHelp	CreateImplement(void);

public:
	// J
	BOOL	Open(DWORD dwFlags);
	// 
	BOOL	Close(void);
	// ŏ̃q[vubN擾
	BOOL	Heap32First(LPHEAPENTRY32 lphe32, DWORD th32ProcessId, ULONG_PTR th32HeapId);
	// ̃q[vubN擾
	BOOL	Heap32Next(LPHEAPENTRY32 lpel32);
	// ŏ̃q[v擾
	BOOL	Heap32ListFirst(LPHEAPLIST32 lphl32);
	// ̃q[v擾
	BOOL	Heap32ListNext(LPHEAPLIST32 lphl32);
	// ŏ̃vZX擾
	BOOL	Process32First(LPPROCESSENTRY32A lppe32);
#if !defined(IRIS_WIN32_WCE)
	BOOL	Process32First(LPPROCESSENTRY32W lppe32);
#endif
	// ̃vZX擾
	BOOL	Process32Next(LPPROCESSENTRY32A lppe32);
#if !defined(IRIS_WIN32_WCE)
	BOOL	Process32Next(LPPROCESSENTRY32W lppe32);
#endif
	// ŏ̃Xbh擾
	BOOL	Thread32First(LPTHREADENTRY32 lpte32);
	// ̃Xbh擾
	BOOL	Thread32Next(LPTHREADENTRY32 lpte32);
	// ŏ̃W[擾
	BOOL	Module32First(LPMODULEENTRY32A lpme32);
#if !defined(IRIS_WIN32_WCE)
	BOOL	Module32First(LPMODULEENTRY32W lpme32);
#endif
	// ̃W[擾
	BOOL	Module32Next(LPMODULEENTRY32A lpme32);
#if !defined(IRIS_WIN32_WCE)
	BOOL	Module32Next(LPMODULEENTRY32W lpme32);
#endif

	// ̃vZXɊ蓖ĂꂽRs[
	BOOL	ReadProcessMemory(DWORD th32ProcessId, LPCVOID lpBaseAddr, LPVOID lpBuffer, DWORD dwSize, PSIZE_T lpNumberOfBytesRead);

public:
	// I[vtO擾
	DWORD	GetFlags(void)	const;
};

}	// end of namespace wx
}	// end of namespace iris

#endif
