//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXHtmlHelp.h
 * @brief		HtmlHelpg
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXHtmlHelp_H_
#define INCG_IRIS_WXHtmlHelp_H_

//======================================================================
// icnlude
#include "iris_object.h"

#ifdef _IRIS_WX_SUPPORT_HTMLHELP_WORKSHOP
#include "C:\Program Files\\HTML Help Workshop\include\htmlhelp.h"	// wv
// CuN
#pragma comment (lib,"htmlhelp.lib")
#endif

namespace iris {
namespace wx
{

//======================================================================
// declare
template<typename CHARTYPE_>class CTHtmlHelp;

//======================================================================
// typedef
typedef CTHtmlHelp<CHAR>	CHtmlHelpA;
typedef CTHtmlHelp<WCHAR>	CHtmlHelpW;
typedef CTHtmlHelp<TCHAR>	CHtmlHelp;


//======================================================================
// function

// popup\
// hWnd = enh, pi = \ʒu, fore = F, back = wiF, text = 
BOOL ShowPopupHtmlHelp (HWND hWnd, POINT pi, COLORREF fore, COLORREF back, LPTSTR text);
BOOL ShowPopupHtmlHelpA(HWND hWnd, POINT pi, COLORREF fore, COLORREF back, LPSTR  text);
BOOL ShowPopupHtmlHelpW(HWND hWnd, POINT pi, COLORREF fore, COLORREF back, LPWSTR text);
// toc\
// hWnd = enh, path = wvt@C̃pX(.chm)
BOOL ShowTocHtmlHelp (HWND hWnd, LPTSTR path);
BOOL ShowTocHtmlHelpA(HWND hWnd, LPSTR  path);
BOOL ShowTocHtmlHelpW(HWND hWnd, LPWSTR path);
// index\
// hWnd = enh, path = wvt@C̃pX(.chm), index = wvt@CCfbNXpX
BOOL ShowIndexHtmlHelp (HWND hWnd, LPTSTR path, LPTSTR index);
BOOL ShowIndexHtmlHelpA(HWND hWnd, LPSTR  path, LPSTR  index);
BOOL ShowIndexHtmlHelpW(HWND hWnd, LPWSTR path, LPWSTR index);

}	// end of namespace wx
}	// end of namespace iris

#ifndef _IRIS_WX_SUPPORT_HTMLHELP_WORKSHOP

// `Rs[
#define HH_DISPLAY_TOPIC        0x0000
#define HH_HELP_FINDER          0x0000  // WinHelp equivalent
#define HH_DISPLAY_TOC          0x0001  
#define HH_DISPLAY_INDEX        0x0002  
#define HH_DISPLAY_SEARCH       0x0003  
#define HH_SET_WIN_TYPE         0x0004
#define HH_GET_WIN_TYPE         0x0005
#define HH_GET_WIN_HANDLE       0x0006
#define HH_ENUM_INFO_TYPE       0x0007  // Get Info type name, call repeatedly to enumerate, -1 at end
#define HH_SET_INFO_TYPE        0x0008  // Add Info type to filter.
#define HH_SYNC                 0x0009
#define HH_RESERVED1            0x000A
#define HH_RESERVED2            0x000B
#define HH_RESERVED3            0x000C
#define HH_KEYWORD_LOOKUP       0x000D
#define HH_DISPLAY_TEXT_POPUP   0x000E  // display string resource id or text in a popup window
#define HH_HELP_CONTEXT         0x000F  // display mapped numeric value in dwData
#define HH_TP_HELP_CONTEXTMENU  0x0010  // text popup help, same as WinHelp HELP_CONTEXTMENU
#define HH_TP_HELP_WM_HELP      0x0011  // text popup help, same as WinHelp HELP_WM_HELP
#define HH_CLOSE_ALL            0x0012  // close all windows opened directly or indirectly by the caller
#define HH_ALINK_LOOKUP         0x0013  // ALink version of HH_KEYWORD_LOOKUP
#define HH_GET_LAST_ERROR       0x0014  // not currently implemented // See HHERROR.h
#define HH_ENUM_CATEGORY        0x0015	// Get category name, call repeatedly to enumerate, -1 at end
#define HH_ENUM_CATEGORY_IT     0x0016  // Get category info type members, call repeatedly to enumerate, -1 at end
#define HH_RESET_IT_FILTER      0x0017  // Clear the info type filter of all info types.
#define HH_SET_INCLUSIVE_FILTER 0x0018  // set inclusive filtering method for untyped topics to be included in display
#define HH_SET_EXCLUSIVE_FILTER 0x0019  // set exclusive filtering method for untyped topics to be excluded from display
#define HH_INITIALIZE            0x001C  // Initializes the help system.
#define HH_UNINITIALIZE          0x001D  // Uninitializes the help system.
#define HH_PRETRANSLATEMESSAGE  0x00fd  // Pumps messages. (NULL, NULL, MSG*). 
#define HH_SET_GLOBAL_PROPERTY  0x00fc  // Set a global property. (NULL, NULL, HH_GPROP)

#define HHWIN_PROP_TAB_AUTOHIDESHOW (1 << 0)    // Automatically hide/show tri-pane window
#define HHWIN_PROP_ONTOP            (1 << 1)    // Top-most window
#define HHWIN_PROP_NOTITLEBAR       (1 << 2)    // no title bar
#define HHWIN_PROP_NODEF_STYLES     (1 << 3)    // no default window styles (only HH_WINTYPE.dwStyles)
#define HHWIN_PROP_NODEF_EXSTYLES   (1 << 4)    // no default extended window styles (only HH_WINTYPE.dwExStyles)
#define HHWIN_PROP_TRI_PANE         (1 << 5)    // use a tri-pane window
#define HHWIN_PROP_NOTB_TEXT        (1 << 6)    // no text on toolbar buttons
#define HHWIN_PROP_POST_QUIT        (1 << 7)    // post WM_QUIT message when window closes
#define HHWIN_PROP_AUTO_SYNC        (1 << 8)    // automatically ssync contents and index
#define HHWIN_PROP_TRACKING         (1 << 9)    // send tracking notification messages
#define HHWIN_PROP_TAB_SEARCH       (1 << 10)   // include search tab in navigation pane
#define HHWIN_PROP_TAB_HISTORY      (1 << 11)   // include history tab in navigation pane
#define HHWIN_PROP_TAB_FAVORITES    (1 << 12)   // include favorites tab in navigation pane
#define HHWIN_PROP_CHANGE_TITLE     (1 << 13)   // Put current HTML title in title bar
#define HHWIN_PROP_NAV_ONLY_WIN     (1 << 14)   // Only display the navigation window
#define HHWIN_PROP_NO_TOOLBAR       (1 << 15)   // Don't display a toolbar
#define HHWIN_PROP_MENU             (1 << 16)   // Menu
#define HHWIN_PROP_TAB_ADVSEARCH    (1 << 17)   // Advanced FTS UI.
#define HHWIN_PROP_USER_POS         (1 << 18)   // After initial creation, user controls window size/position
#define HHWIN_PROP_TAB_CUSTOM1      (1 << 19)   // Use custom tab #1
#define HHWIN_PROP_TAB_CUSTOM2      (1 << 20)   // Use custom tab #2
#define HHWIN_PROP_TAB_CUSTOM3      (1 << 21)   // Use custom tab #3
#define HHWIN_PROP_TAB_CUSTOM4      (1 << 22)   // Use custom tab #4
#define HHWIN_PROP_TAB_CUSTOM5      (1 << 23)   // Use custom tab #5
#define HHWIN_PROP_TAB_CUSTOM6      (1 << 24)   // Use custom tab #6
#define HHWIN_PROP_TAB_CUSTOM7      (1 << 25)   // Use custom tab #7
#define HHWIN_PROP_TAB_CUSTOM8      (1 << 26)   // Use custom tab #8
#define HHWIN_PROP_TAB_CUSTOM9      (1 << 27)   // Use custom tab #9
#define HHWIN_TB_MARGIN             (1 << 28)   // the window type has a margin

#define HHWIN_PARAM_PROPERTIES      (1 << 1)    // valid fsWinProperties
#define HHWIN_PARAM_STYLES          (1 << 2)    // valid dwStyles
#define HHWIN_PARAM_EXSTYLES        (1 << 3)    // valid dwExStyles
#define HHWIN_PARAM_RECT            (1 << 4)    // valid rcWindowPos
#define HHWIN_PARAM_NAV_WIDTH       (1 << 5)    // valid iNavWidth
#define HHWIN_PARAM_SHOWSTATE       (1 << 6)    // valid nShowState
#define HHWIN_PARAM_INFOTYPES       (1 << 7)    // valid apInfoTypes
#define HHWIN_PARAM_TB_FLAGS        (1 << 8)    // valid fsToolBarFlags
#define HHWIN_PARAM_EXPANSION       (1 << 9)    // valid fNotExpanded
#define HHWIN_PARAM_TABPOS          (1 << 10)   // valid tabpos
#define HHWIN_PARAM_TABORDER        (1 << 11)   // valid taborder
#define HHWIN_PARAM_HISTORY_COUNT   (1 << 12)   // valid cHistory
#define HHWIN_PARAM_CUR_TAB         (1 << 13)   // valid curNavType

#define HHWIN_BUTTON_EXPAND         (1 << 1)    // Expand/contract button
#define HHWIN_BUTTON_BACK           (1 << 2)    // Back button
#define HHWIN_BUTTON_FORWARD        (1 << 3)    // Forward button
#define HHWIN_BUTTON_STOP           (1 << 4)    // Stop button
#define HHWIN_BUTTON_REFRESH        (1 << 5)    // Refresh button
#define HHWIN_BUTTON_HOME           (1 << 6)    // Home button
#define HHWIN_BUTTON_BROWSE_FWD     (1 << 7)    // not implemented
#define HHWIN_BUTTON_BROWSE_BCK     (1 << 8)    // not implemented
#define HHWIN_BUTTON_NOTES          (1 << 9)    // not implemented
#define HHWIN_BUTTON_CONTENTS       (1 << 10)   // not implemented
#define HHWIN_BUTTON_SYNC           (1 << 11)   // Sync button
#define HHWIN_BUTTON_OPTIONS        (1 << 12)   // Options button
#define HHWIN_BUTTON_PRINT          (1 << 13)   // Print button
#define HHWIN_BUTTON_INDEX          (1 << 14)   // not implemented
#define HHWIN_BUTTON_SEARCH         (1 << 15)   // not implemented
#define HHWIN_BUTTON_HISTORY        (1 << 16)   // not implemented
#define HHWIN_BUTTON_FAVORITES      (1 << 17)   // not implemented
#define HHWIN_BUTTON_JUMP1          (1 << 18)
#define HHWIN_BUTTON_JUMP2          (1 << 19)
#define HHWIN_BUTTON_ZOOM           (1 << 20)
#define HHWIN_BUTTON_TOC_NEXT       (1 << 21)
#define HHWIN_BUTTON_TOC_PREV       (1 << 22)

#define HHWIN_DEF_BUTTONS           \
            (HHWIN_BUTTON_EXPAND |  \
             HHWIN_BUTTON_BACK |    \
             HHWIN_BUTTON_OPTIONS | \
             HHWIN_BUTTON_PRINT)

// Button IDs

#define IDTB_EXPAND             200
#define IDTB_CONTRACT           201
#define IDTB_STOP               202
#define IDTB_REFRESH            203
#define IDTB_BACK               204
#define IDTB_HOME               205
#define IDTB_SYNC               206
#define IDTB_PRINT              207
#define IDTB_OPTIONS            208
#define IDTB_FORWARD            209
#define IDTB_NOTES              210 // not implemented
#define IDTB_BROWSE_FWD         211
#define IDTB_BROWSE_BACK        212
#define IDTB_CONTENTS           213 // not implemented
#define IDTB_INDEX              214 // not implemented
#define IDTB_SEARCH             215 // not implemented
#define IDTB_HISTORY            216 // not implemented
#define IDTB_FAVORITES          217 // not implemented
#define IDTB_JUMP1              218
#define IDTB_JUMP2              219
#define IDTB_CUSTOMIZE          221
#define IDTB_ZOOM               222
#define IDTB_TOC_NEXT           223
#define IDTB_TOC_PREV           224

// Notification codes

#define HHN_FIRST       (0U-860U)
#define HHN_LAST        (0U-879U)

#define HHN_NAVCOMPLETE   (HHN_FIRST-0)
#define HHN_TRACK         (HHN_FIRST-1)
#define HHN_WINDOW_CREATE (HHN_FIRST-2)

HWND HtmlHelpA(	HWND hwndCaller,
			    LPCSTR pszFile,
				UINT uCommand,
			    DWORD_PTR dwData
			);
HWND HtmlHelpW(	HWND hwndCaller,
			    LPCWSTR pszFile,
				UINT uCommand,
			    DWORD_PTR dwData
			);
#ifdef UNICODE
#define HtmlHelp  HtmlHelpW
#else
#define HtmlHelp  HtmlHelpA
#endif // !UNICODE

#endif

namespace iris {
namespace wx
{

//======================================================================
// class
//! HtmlHelpbp[NX
template<typename CHARTYPE_>
class CTHtmlHelp : public IIrisObject
{
	typedef CHARTYPE_		_Mychar;
	typedef CHARTYPE_		*_Mylpstr;
	typedef const CHARTYPE_	*_Mylpcstr;

protected:
	_Mychar	m_Path[MAX_PATH];	//!< .chmt@CpX
	DWORD	m_dwCookie;
public:
	// RXgN^
	CTHtmlHelp(_Mylpcstr path);
	CTHtmlHelp(void);
	// fXgN^
	~CTHtmlHelp(void);
public:
	// 
	void	Initialize(void);
	// I
	void	Tarminate(void);

public:
	// popup\
	// hWnd = enh, pi = \ʒu, fore = F, back = wiF, text = 
	BOOL	ShowPopup(HWND hWnd, POINT pi, COLORREF fore, COLORREF back, _Mylpstr text);
	// toc\
	// hWnd = enh, path = wvt@C̃pX(.chm)
	BOOL	ShowToc(HWND hWnd);
	// index\
	// hWnd = enh, path = wvt@C̃pX(.chm), index = wvt@CCfbNXpX
	BOOL	ShowIndex(HWND hWnd, _Mylpstr index);

public:
	// set,get
	void	SetPath(_Mylpcstr path);
	_Mylpstr	GetPath(void)			{ return m_Path; }
	_Mylpcstr	GetPath(void)	const	{ return m_Path; }
};

}	// end of namespace wx
}	// end of namespace iris

#endif	// #ifndef _WXHtmlHelp_H_
