//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXDrive.cpp
 * @brief		 Drive t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXDrive_CPP_

//======================================================================
// include
#include "WXDrive.h"

#if defined(_IRIS_SUPPORT_WDK)

EXTERN_C_BEGIN
#include "devioctl.h"
#include "ntddcdrm.h"
EXTERN_C_END

namespace iris {
namespace wx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CDrive::CDrive(void)
{
}

/**********************************************************************//**
 *
 * WIg̎擾
 *
 -----------------------------------------------------------------------
 * @param [out]	geo	= o
 * @return	
*//***********************************************************************/
bool CDrive::GetGeometry(PDISK_GEOMETRY geo) const
{
	DWORD dwRead=0;
	return IoControl(IOCTL_DISK_GET_DRIVE_GEOMETRY, nullptr, 0, geo, sizeof(DISK_GEOMETRY), &dwRead);
}

/**********************************************************************//**
 *
 * WIg̎擾
 *
 -----------------------------------------------------------------------
 * @param [out]	geo	= o
 * @return	
*//***********************************************************************/
bool CDrive::GetGeometryEx(PDISK_GEOMETRY_EX geo) const
{
	DWORD dwRead=0;
	return IoControl(IOCTL_DISK_GET_DRIVE_GEOMETRY_EX, nullptr, 0, geo, sizeof(DISK_GEOMETRY_EX), &dwRead);
}

/**********************************************************************//**
 *
 * ZN^TCY̎擾
 *
 -----------------------------------------------------------------------
 * @return	ZN^TCY
*//***********************************************************************/
u32 CDrive::GetSectorSize(void) const
{
	DISK_GEOMETRY geo;
	if( !GetGeometry(&geo) ) return 0;
	return geo.BytesPerSector;
}

/**********************************************************************//**
 *
 * fBXNTCY̎擾
 *
 -----------------------------------------------------------------------
 * @return	ZN^TCY
*//***********************************************************************/
u64 CDrive::GetDiskSize(void) const
{
	DISK_GEOMETRY_EX geo;
	if( !GetGeometryEx(&geo) ) return 0;
	return geo.DiskSize.QuadPart;
}

/**********************************************************************//**
 *
 * hCu^CvhCuԍ
 *
 -----------------------------------------------------------------------
 * @param [in]	DriveType	= hCu^Cv
 * @param [in]	firstDrive	= JnhCuԍ
 * @return	hCuԍ
 * @retval	-1 = Ȃꍇ
*//***********************************************************************/
int CDrive::FindDrive(UINT DriveType, int firstDrive)
{
	TCHAR szDrive[]=IRIS_TEXT("a:");
	for( int i=firstDrive; i < DRIVE_NUMBER_MAX; ++i )
	{
		szDrive[0] = IRIS_TEXT('a') + i;
		UINT type = ::GetDriveType(szDrive);
		if( type == DriveType ) return i;
	}
	return -1;
}

/**********************************************************************//**
 *
 * hCuԍhCu^Cv擾
 *
 -----------------------------------------------------------------------
 * @param [in]	driveNumber	= hCuԍ
 * @return	hCu^Cv
*//***********************************************************************/
UINT CDrive::GetDriveType(int driveNumber)
{
	TCHAR szDrive[]=IRIS_TEXT("a:");
	if( driveNumber < 0 || driveNumber > DRIVE_NUMBER_MAX ) return static_cast<UINT>(-1);
	szDrive[0] = IRIS_TEXT('a') + driveNumber;
	return ::GetDriveType(szDrive);
}

}	// end of namespace wx
}	// end of namespace iris

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "unit/UnitCore.h"
#include "iris_iostream.h"
#include "iris_using.h"

//======================================================================
// test
IRIS_UNITTEST(CWXDrive, DriveType)
{
	for( int i=0; i < CDrive::DRIVE_NUMBER_MAX; ++i )
	{
		char name[2] = "a";
		name[0] += i;
		std::cout << name << ": " << CDrive::GetDriveType(i) << std::endl;
	}
}

IRIS_UNITTEST(CWXDrive, DriveGeometry)
{
	int driveNumber = CDrive::FindDrive( DRIVE_CDROM );
	if( driveNumber == -1 ) return;

	CDrive drive;
	TCHAR szDrive[7];
	ASSERT_TRUE( drive.GetDriveAccessPath(driveNumber, szDrive, 7) );
	ASSERT_TRUE( drive.Open(szDrive, GENERIC_READ, FILE_SHARE_READ, nullptr
		, OPEN_EXISTING, FILE_ATTRIBUTE_READONLY|FILE_FLAG_SEQUENTIAL_SCAN, nullptr) );

	DISK_GEOMETRY geo;
	ASSERT_TRUE( drive.GetGeometry(&geo) );

	printf("Cylinders : %d\n", geo.Cylinders);
	printf("MediaType : %d\n", geo.MediaType);
	printf("TracksPerCylinder : %d\n", geo.TracksPerCylinder);
	printf("SectorsPerTrack   : %d\n", geo.SectorsPerTrack);
	printf("BytesPerSector    : %d\n", geo.BytesPerSector);

	printf("Sector Num : %d\n", geo.SectorsPerTrack * geo.SectorsPerTrack * geo.TracksPerCylinder * geo.Cylinders.QuadPart );
	printf("Track Num  : %d\n", geo.TracksPerCylinder * geo.Cylinders.QuadPart );
	printf("Disk Size     : %d\n", geo.BytesPerSector * geo.SectorsPerTrack * geo.TracksPerCylinder * geo.Cylinders.QuadPart );
}

#endif

#endif
