//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXCDDrive.cpp
 * @brief		CD Drive t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXCDDrive_CPP_

//======================================================================
// include
#include "WXCDDrive.h"
#include "../shell/WXShellPath.h"
#include "fnd/format/FndCDDA.h"

#if defined(_IRIS_SUPPORT_WDK)

EXTERN_C_BEGIN
#include "devioctl.h"
#include "ntddcdrm.h"
EXTERN_C_END

namespace iris {
namespace wx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CCDDrive::CCDDrive(void)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CCDDrive::~CCDDrive(void)
{
	if( IsValid() )	Stop();
}

/**********************************************************************//**
 *
 * hCuăI[v
 *
 ----------------------------------------------------------------------
 * @param [in]	dwDesiredAccess			= ANZX[h( GENERIC_*** or 0 )
 * @param [in]	dwShareMode				= L[h(FILE_SHARE_*** or 0)
 * @param [in]	lpSecurityAttributes	= ZLeBLqq
 * @param [in]	dwCreationDisposition	= 쐬@(CREATE_*** or OPEN_*** or TRUNCATE_EXISTING)
 * @param [in]	dwFlagsAndAttributes	= t@C(FILE_ATTRIBUTE_***)
 * @param [in]	hTemplateFile			= ev[gt@C̃nh
 * @return	^Ul
*//***********************************************************************/
BOOL CCDDrive::SearchOpen(DWORD dwDesiredAccess, DWORD dwShareMode, LPSECURITY_ATTRIBUTES lpSecurityAttributes
						, DWORD dwCreationDisposition, DWORD dwFlagsAndAttributes, HANDLE hTemplateFile)
{
	int driveNumber = FindDrive(DRIVE_CDROM);
	if( driveNumber == -1 ) return FALSE;
	TCHAR szDrive[] = IRIS_TEXT("\\\\.\\ :");
	szDrive[4] = IRIS_TEXT('A') + driveNumber;
	return Open(szDrive, dwDesiredAccess, dwShareMode, lpSecurityAttributes
		, dwCreationDisposition, dwFlagsAndAttributes, hTemplateFile);
}

/**********************************************************************//**
 *
 * ANZX\ǂ
 *
 ----------------------------------------------------------------------
 * @return	^Ul
*//***********************************************************************/
BOOL CCDDrive::IsReady(void)
{
	if( !IsValid() ) return FALSE;
	return IoControl(IOCTL_CDROM_CHECK_VERIFY);
}

/**********************************************************************//**
 *
 * WIg̎擾
 *
 -----------------------------------------------------------------------
 * @param [out]	geo	= o
 * @return	
*//***********************************************************************/
bool CCDDrive::GetGeometry(PDISK_GEOMETRY geo) const
{
	DWORD dwRead=0;
	return IoControl(IOCTL_CDROM_GET_DRIVE_GEOMETRY, nullptr, 0, geo, sizeof(DISK_GEOMETRY), &dwRead);
}

/**********************************************************************//**
 *
 * WIg̎擾
 *
 -----------------------------------------------------------------------
 * @param [out]	geo	= o
 * @return	
*//***********************************************************************/
bool CCDDrive::GetGeometryEx(PDISK_GEOMETRY_EX geo) const
{
	DWORD dwRead=0;
	return IoControl(IOCTL_CDROM_GET_DRIVE_GEOMETRY_EX, nullptr, 0, geo, sizeof(DISK_GEOMETRY_EX), &dwRead);
}

/**********************************************************************//**
 *
 * ǂݍ
 *
 ----------------------------------------------------------------------
 * @param [out]	lpBuffer		= o̓obt@
 * @param [in]	dwSize			= o̓obt@TCY
 * @param [in]	lpdwRead		= ǂݍ񂾃TCY
 * @param [in]	TrackMode		= gbN^Cv
 * @param [in]	nSector			= ǂݎZN^TCYi0 ̏ꍇvZj
 * @param [in]	DiskOffset		= ǂݎJnItZbg
 * @return	
*//***********************************************************************/
BOOL CCDDrive::ReadRawData(LPVOID lpBuffer, DWORD dwSize, LPDWORD lpdwRead
						 , TRACK_MODE_TYPE TrackMode, LONGLONG DiskOffset, DWORD nSector, LPOVERLAPPED lpOverlapped)
{
	IRIS_ASSERT( lpdwRead != nullptr );
	if( nSector == 0 )
	{
		// vZ
		nSector = dwSize / CD_RAW_SECTOR_SIZE;
	}
	if( nSector == 0 )
	{
		*lpdwRead = 0;
		return FALSE;
	}
	RAW_READ_INFO rri;
	rri.DiskOffset.QuadPart = DiskOffset;
	rri.SectorCount			= nSector;
	rri.TrackMode			= TrackMode;
	return DeviceIoControl(IOCTL_CDROM_RAW_READ, &rri, sizeof(rri), lpBuffer, dwSize, lpdwRead, lpOverlapped);
}

/**********************************************************************//**
 *
 * ~
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CCDDrive::Stop(void)
{
	return IoControl(IOCTL_CDROM_STOP_AUDIO);
}

/**********************************************************************//**
 *
 * f
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CCDDrive::Suspend(void)
{
	return IoControl(IOCTL_CDROM_PAUSE_AUDIO);
}

/**********************************************************************//**
 *
 * ĊJ
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CCDDrive::Resume(void)
{
	return IoControl(IOCTL_CDROM_RESUME_AUDIO);
}

/**********************************************************************//**
 *
 * fƍĊJ
 *
 ----------------------------------------------------------------------
 * @param [in]	bPause	= ~邩ǂ
 * @return	
*//***********************************************************************/
BOOL CCDDrive::Pause(BOOL bPause)
{
	if( bPause )
	{
		return Suspend();
	}
	else
	{
		return Resume();
	}
}

/**********************************************************************//**
 *
 * fBA
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CCDDrive::EjectMedia(void)
{
	return IoControl(IOCTL_CDROM_EJECT_MEDIA);
}

/**********************************************************************//**
 *
 * fBA}
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CCDDrive::InsertMedia(void)
{
	return IoControl(IOCTL_CDROM_LOAD_MEDIA);
}

/**********************************************************************//**
 *
 * fBAւ/֎~
 *
 ----------------------------------------------------------------------
 * @param [in] bPrevent	= ֎~邩ǂ
 * @return	
*//***********************************************************************/
BOOL CCDDrive::PreventMediaRemoval(BOOLEAN bPrevent)
{
	PREVENT_MEDIA_REMOVAL pmr;
	pmr.PreventMediaRemoval = bPrevent;
	return IoControl(IOCTL_CDROM_MEDIA_REMOVAL, &pmr, sizeof(pmr));
}


}	// end of namespace wx
}	// end of namespace iris

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "fnd/format/FndCDDAToc.h"
#include "fnd/format/FndCDDAText.h"
#include "unit/UnitCore.h"
#include "iris_iostream.h"
#include "iris_using.h"

//======================================================================
// test
IRIS_UNITTEST(CWXCDDrive, CDDATOC)
{
	CCDDrive drive;
	if( drive.SearchOpen(GENERIC_READ, FILE_SHARE_READ, nullptr
		, OPEN_EXISTING, FILE_ATTRIBUTE_READONLY|FILE_FLAG_SEQUENTIAL_SCAN, nullptr) )
	{
		if( drive.IsReady() )
		{
			fnd::CCDDAToc<> toc;
			ASSERT_TRUE( toc.Open( &drive ) );

			printf("Track %d - %d\n", toc.GetFirstTrackNo(), toc.GetLastTrackNo() );
		}
	}
	else
	{
		printf("drive open failed.\n");
	}
}

IRIS_UNITTEST(CWXCDDrive, CDDAText)
{
	CCDDrive drive;
	if( drive.SearchOpen(GENERIC_READ, FILE_SHARE_READ, nullptr
		, OPEN_EXISTING, FILE_ATTRIBUTE_READONLY|FILE_FLAG_SEQUENTIAL_SCAN, nullptr) )
	{
		if( drive.IsReady() )
		{
			fnd::CCDDAToc<> toc;
			ASSERT_TRUE( toc.Open( &drive ) );
			printf("Track %d - %d\n", toc.GetFirstTrackNo(), toc.GetLastTrackNo() );

			fnd::CCDDAText<> text;
			ASSERT_TRUE( text.Open( &drive ) );

			for( int i=toc.GetFirstTrackNo(); i < toc.GetLastTrackNo(); ++i )
			{
				for( int j=0; j < fnd::PACKTYPE_NUM; ++j )
				{
					TCHAR buf[256];
					if( text.ToString(j, i, buf, 256) )
					{
						printf("track %d : type %d : %s\n", i, j, buf);
					}
				}
			}
		}
	}
	else
	{
		printf("drive open failed.\n");
	}
}

IRIS_UNITTEST(CWXCDDrive, DriveGeometry)
{
	CCDDrive drive;
	ASSERT_TRUE( drive.SearchOpen(GENERIC_READ, FILE_SHARE_READ, nullptr
		, OPEN_EXISTING, FILE_ATTRIBUTE_READONLY|FILE_FLAG_SEQUENTIAL_SCAN, nullptr) );

	DISK_GEOMETRY geo;
	ASSERT_TRUE( drive.GetGeometry(&geo) );

	printf("Cylinders : %d\n", geo.Cylinders);
	printf("MediaType : %d\n", geo.MediaType);
	printf("TracksPerCylinder : %d\n", geo.TracksPerCylinder);
	printf("SectorsPerTrack   : %d\n", geo.SectorsPerTrack);
	printf("BytesPerSector    : %d\n", geo.BytesPerSector);

	printf("Sector Num : %d\n", geo.SectorsPerTrack * geo.SectorsPerTrack * geo.TracksPerCylinder * geo.Cylinders.QuadPart );
	printf("Track Num  : %d\n", geo.TracksPerCylinder * geo.Cylinders.QuadPart );
	printf("Disk Sie   : %d\n", geo.BytesPerSector * geo.SectorsPerTrack * geo.TracksPerCylinder * geo.Cylinders.QuadPart );
}

IRIS_UNITTEST(CWXCDDrive, DiskSize)
{
	CCDDrive drive;
	ASSERT_TRUE( drive.SearchOpen(GENERIC_READ, FILE_SHARE_READ, nullptr
		, OPEN_EXISTING, FILE_ATTRIBUTE_READONLY|FILE_FLAG_SEQUENTIAL_SCAN, nullptr) );

	u64 size = drive.GetDiskSize();
	u64 mb = size/(1024*1024);
	printf("Disk Size : %lld BYTE (%lld MB) \n", size, mb);
}

#endif

#endif
