//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXSymbol.cpp
 * @brief		WXSymbol t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXSymbol_CPP_

//======================================================================
// include
#include "WXSymbol.h"
#include "WXDebugHelp.h"

namespace iris {
namespace wx 
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 * 
*//***********************************************************************/
CSymbol::CSymbol(void)
{
}

/**********************************************************************//**
 *
 * RXgN^
 * 
 ----------------------------------------------------------------------
 * @param [in]	hProcess	= ֘AtvZX
*//***********************************************************************/
CSymbol::CSymbol(HANDLE hProcess)
: CProcess(hProcess)
{
}

/**********************************************************************//**
 *
 * fXgN^
 * 
*//***********************************************************************/
CSymbol::~CSymbol(void)
{
	if( m_hObject != nullptr )
		Cleanup();
}

/**********************************************************************//**
 *
 * 
 * 
 ----------------------------------------------------------------------
 * @param [in]	UserSearchPath	= pX
 * @param [in]	bInvadeProcess	= vZXp̃[hς݃W[邩ǂ
 * @return	
*//***********************************************************************/
BOOL CSymbol::Initialize(PSTR UserSearchPath, BOOL bInvadeProcess)
{
	return ::SymInitialize(m_hObject, UserSearchPath, bInvadeProcess);
}

/**********************************************************************//**
 *
 * N[Abv
 * 
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CSymbol::Cleanup(void)
{
	return ::SymCleanup(m_hObject);
}

/**********************************************************************//**
 *
 * V{e[u[h
 * 
 ----------------------------------------------------------------------
 * @param [in]	hFile		= s\ȃC[Wێt@C̃nh(NULL )
 * @param [in]	ImageName	= s\C[W̖O
 * @param [in]	ModuleName	= W[̃V[gJbg(NULL )
 * @param [in]	BaseOfDll	= W[̃[hAhX
 * @param [in]	SizeOfDll	= W[̃TCY
 * @return	
*//***********************************************************************/
XDWORD CSymbol::LoadModule(HANDLE hFile, PSTR ImageName, PSTR ModuleName, XDWORD BaseOfDll, DWORD SizeOfDll)
{
	return ::SymLoadModule(m_hObject, hFile, ImageName, ModuleName, BaseOfDll, SizeOfDll);
}

/**********************************************************************//**
 *
 * V{e[uA[h
 * 
 ----------------------------------------------------------------------
 * @param [in]	BaseOfDll	= W[̃[hAhX
 * @return	
*//***********************************************************************/
BOOL CSymbol::UnloadModule(DWORD BaseOfDll)
{
	return ::SymUnloadModule(m_hObject, BaseOfDll);
}

/**********************************************************************//**
 *
 * W[̗
 * 
 ----------------------------------------------------------------------
 * @param [in]	pfnCallback	= W[󂯎R[obN֐
 * @param [in]	pUserData	= [U[`̒l
 * @return	
*//***********************************************************************/
BOOL CSymbol::EnumModules(PSYM_ENUMMODULES_CALLBACK pfnCallback, PVOID pUserData)
{
	return ::SymEnumerateModules(m_hObject, pfnCallback, pUserData);
}

/**********************************************************************//**
 *
 * V{̗
 * 
 ----------------------------------------------------------------------
 * @param [in]	BaseOfDll	= V{񋓂W[̃x[XAhX
 * @param [in]	pfnCallback	= V{󂯎R[obN֐
 * @param [in]	pUserData	= [U[`̒l
 * @return	
*//***********************************************************************/
BOOL CSymbol::EnumSymbols(XULONG BaseOfDll, PSYM_ENUMSYMBOLS_CALLBACK pfnCallback, PVOID pUserData)
{
IRIS_PRAGMA_WARNING_DISABLE(IRIS_MSC, 4996)
	return ::SymEnumerateSymbols(m_hObject, BaseOfDll, pfnCallback, pUserData);
IRIS_PRAGMA_WARNING_DEFAULT(IRIS_MSC, 4996)
};

/**********************************************************************//**
 *
 * ֐e[ũGgAhX擾
 * 
 ----------------------------------------------------------------------
 * @param [in]	AddrBase	= 
 * @return	֐e[ũGgAhX
*//***********************************************************************/
LPVOID CSymbol::FunctionTableAccess(DWORD AddrBase)
{
	return ::SymFunctionTableAccess(m_hObject, AddrBase);
}

/**********************************************************************//**
 *
 * w肳ꂽAhXɑΉ\[Xsi\[XR[h̍sj
 *
 -----------------------------------------------------------------------
 * @param [in]	dwAddr			= AhX
 * @param [in]	pdwDisplacement	= V{̐擪̕ψʁA܂0
 * @param [out]	pLine			= o͏
 * @return	
*//***********************************************************************/
BOOL CSymbol::GetLineFromAddr(XDWORD dwAddr, PDWORD pdwDisplacement, PIMAGEHLP_LINE  pLine) const
{
	return ::SymGetLineFromAddr(m_hObject, dwAddr, pdwDisplacement, pLine);
}

/**********************************************************************//**
 *
 * w肳ꂽW[ƃt@CΉ\[Xsi\[XR[h̍sj
 *
 -----------------------------------------------------------------------
 * @param [in]	dwAddr			= AhX
 * @param [in]	ModuleName		= W[
 * @param [in]	FileName		= t@C
 * @param [in]	dwLineNumber	= sԍ
 * @param [in]	lpDisplacement	= V{̐擪̕ψʁA܂0
 * @param [out]	pLine			= o͏
 * @return	
*//***********************************************************************/
BOOL CSymbol::GetLineFromName(LPSTR ModuleName, LPSTR FileName, DWORD dwLineNumber, PLONG lpDisplacement, PIMAGEHLP_LINE pLine) const
{
	return ::SymGetLineFromName(m_hObject, ModuleName, FileName, dwLineNumber, lpDisplacement, pLine);
}

/**********************************************************************//**
 *
 * ̃\[Xs擾
 *
 -----------------------------------------------------------------------
 * @param [out]	pLine	= o͏
 * @return	
*//***********************************************************************/
BOOL CSymbol::GetLineNext(PIMAGEHLP_LINE pLine) const
{
	return ::SymGetLineNext(m_hObject, pLine);
}

/**********************************************************************//**
 *
 * Õ\[Xs擾
 *
 -----------------------------------------------------------------------
 * @param [out]	pLine	= o͏
 * @return	
*//***********************************************************************/
BOOL CSymbol::GetLinePrev(PIMAGEHLP_LINE pLine) const
{
	return ::SymGetLinePrev(m_hObject, pLine);
}

/**********************************************************************//**
 *
 * w肳ꂽAhXɒuĂV{
 *
 -----------------------------------------------------------------------
 * @param [in]	dwAddr			= AhX
 * @param [in]	pdwDisplacement	= V{̐擪̕ψʁA܂0
 * @param [out]	pSymbol			= o͏
 * @return	
*//***********************************************************************/
BOOL CSymbol::GetSymFromAddr(XDWORD dwAddr, PDWORD pdwDisplacement, PIMAGEHLP_SYMBOL pSymbol) const
{
#if defined(_IMAGEHLP64)
	return ::SymGetSymFromAddr(m_hObject, dwAddr, (PDWORD64)pdwDisplacement, pSymbol);
#else
	return ::SymGetSymFromAddr(m_hObject, dwAddr, pdwDisplacement, pSymbol);
#endif
}

/**********************************************************************//**
 *
 * w肳ꂽOɑΉV{
 *
 -----------------------------------------------------------------------
 * @param [in]	dwAddr			= AhX
 * @param [in]	pdwDisplacement	= V{̐擪̕ψʁA܂0
 * @param [out]	pSymbol			= o͏
 * @return	
*//***********************************************************************/
BOOL CSymbol::GetSymFromName(LPSTR Name, PIMAGEHLP_SYMBOL pSymbol) const
{
	return ::SymGetSymFromName(m_hObject, Name, pSymbol);
}

/**********************************************************************//**
 *
 * ̃V{擾
 *
 -----------------------------------------------------------------------
 * @param [out]	pSymbol	= o͏
 * @return	
*//***********************************************************************/
BOOL CSymbol::GetSymNext(PIMAGEHLP_SYMBOL pSymbol) const
{
	return ::SymGetSymNext(m_hObject, pSymbol);
}

/**********************************************************************//**
 *
 * ÕV{擾
 *
 -----------------------------------------------------------------------
 * @param [out]	pSymbol	= o͏
 * @return	
*//***********************************************************************/
BOOL CSymbol::GetSymPrev(PIMAGEHLP_SYMBOL pSymbol) const
{
	return ::SymGetSymPrev(m_hObject, pSymbol);
}

/**********************************************************************//**
 *
 * 肳ꂽAhXێ郂W[̃x[XAhX
 *
 -----------------------------------------------------------------------
 * @param [in]	dwAddr		= AhX
 * @return	W[̃x[XAhX
*//***********************************************************************/
XDWORD CSymbol::GetModuleBase(XDWORD dwAddr) const
{
	return ::SymGetModuleBase(m_hObject, dwAddr);
}

/**********************************************************************//**
 *
 * w肳ꂽW[̃W[擾
 *
 -----------------------------------------------------------------------
 * @param [in]	dwAddr		= AhX
 * @param [out]	ModuleInfo	= o͏
 * @return	
*//***********************************************************************/
BOOL CSymbol::GetModuleInfo(XDWORD dwAddr, PIMAGEHLP_MODULE ModuleInfo) const
{
	return ::SymGetModuleInfo(m_hObject, dwAddr, ModuleInfo);
}

/**********************************************************************//**
 *
 * w肳ꂽvZXp̌pX擾
 *
 -----------------------------------------------------------------------
 * @param [out]	SearchPath			= o̓obt@
 * @param [in]	SearchPathLength	= o̓obt@TCY
 * @return	
*//***********************************************************************/
BOOL CSymbol::GetSearchPath(PSTR SearchPath, DWORD SearchPathLength) const
{
	return ::SymGetSearchPath(m_hObject, SearchPath, SearchPathLength);
}

/**********************************************************************//**
 *
 * w肳ꂽvZXp̌pXݒ
 *
 -----------------------------------------------------------------------
 * @param [out]	SearchPath	= ݒpX
 * @return	
*//***********************************************************************/
BOOL CSymbol::SetSearchPath(PSTR SearchPath)
{
	return ::SymSetSearchPath(m_hObject, SearchPath);
}

/**********************************************************************//**
 *
 * V{nhgR[obN֐o^
 *
 -----------------------------------------------------------------------
 * @param [out]	pfnCallback		= R[obN֐
 * @param [in]	pUserData		= [U[f[^
 * @return	
*//***********************************************************************/
BOOL CSymbol::RegisterCallback(PSYMBOL_REGISTERED_CALLBACK pfnCallback, PVOID pUserData)
{
#if defined(_IMAGEHLP64)
	return ::SymRegisterCallback(m_hObject, pfnCallback, (ULONG64)pUserData);
#else
	return ::SymRegisterCallback(m_hObject, pfnCallback, pUserData);
#endif
}

/**********************************************************************//**
 *
 * Alpha Rs[^ŃX^bNEH[LOiA̍ƁjvV[Wp邽߂̃R[obN֐o^
 *
 -----------------------------------------------------------------------
 * @param [out]	pfnCallback		= R[obN֐
 * @param [in]	pUserData		= [U[f[^
 * @return	
*//***********************************************************************/
BOOL CSymbol::RegisterFunctionEntryCallback(PSYMBOL_FUNCENTRY_CALLBACK pfnCallback, PVOID pUserData)
{
#if defined(_IMAGEHLP64)
	return ::SymRegisterFunctionEntryCallback(m_hObject, pfnCallback, (ULONG64)pUserData);
#else
	return ::SymRegisterFunctionEntryCallback(m_hObject, pfnCallback, pUserData);
#endif
}

}	// end of namespace wx
}	// end of namespace iris

