//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXTreeView.cpp
 * @brief		TreeView NX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXTreeView_CPP_

//======================================================================
// include
#include "WXTreeView.h"

namespace iris {
namespace wx
{

//======================================================================
// class

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CTreeView::CTreeView(void)
{
	CComCtrl::Initialize(ICC_TREEVIEW_CLASSES);
}

/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= EBhEnh
*//***********************************************************************/
CTreeView::CTreeView(HWND hWnd)
: CSubClass(hWnd)
{
	CComCtrl::Initialize(ICC_TREEVIEW_CLASSES);
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CTreeView::~CTreeView(void)
{
}

/**********************************************************************//**
 *
 * EBhE̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	dwStyle			= EBhEX^C
 * @param [in]	rRect			= RECT\̂̎Q
 * @param [in]	hWndParent		= ẽEBhEnh
 * @param [in]	nID				= j[ID
 * @param [in]	hInstance		= CX^Xnh
 * @param [in]	pParam			= p[^
 * @return	EBhEnh
*//***********************************************************************/
HWND CTreeView::Create( DWORD dwStyle
					 , const RECT &rRect
					 , HWND hWndParent, int nID
					 , HINSTANCE hInstance
					 , void *pParam)
{
	// EBhE̍쐬
	return CWindow::Create(WC_TREEVIEW
		, nullptr
		, dwStyle
		, rRect
		, hWndParent
		, nID
		, hInstance
		, pParam );
}
/**********************************************************************//**
 *
 * EBhE̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	dwStyle			= EBhEX^C
 * @param [in]	x,y,w,h			= EBhË
 * @param [in]	hWndParent		= ẽEBhEnh
 * @param [in]	nID				= j[ID
 * @param [in]	hInstance		= CX^Xnh
 * @param [in]	pParam			= p[^
 * @return	EBhEnh
*//***********************************************************************/
HWND CTreeView::Create( DWORD dwStyle
					 , int x, int y, int w, int h
					 , HWND hWndParent, int nID
					 , HINSTANCE hInstance
					 , void *pParam)
{
	// EBhE̍쐬
	return CreateWindow(WC_TREEVIEW
		, nullptr
		, dwStyle
		, x, y, w, h
		, hWndParent
		, (HMENU)(UINT_PTR)nID
		, hInstance
		, pParam );
}

/**********************************************************************//**
 *
 * EBhE̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	dwExStyle		= gEBhEX^C
 * @param [in]	dwStyle			= EBhEX^C
 * @param [in]	rRect			= RECT\̂̎Q
 * @param [in]	hWndParent		= ẽEBhEnh
 * @param [in]	nID				= j[ID
 * @param [in]	hInstance		= CX^Xnh
 * @param [in]	pParam			= p[^
 * @return	EBhEnh
*//***********************************************************************/
HWND CTreeView::CreateEx( DWORD dwExStyle
					 , DWORD dwStyle
					 , const RECT &rRect
					 , HWND hWndParent, int nID
					 , HINSTANCE hInstance
					 , void *pParam)
{
	// EBhE̍쐬
	return CWindow::CreateEx(dwExStyle
		, WC_TREEVIEW
		, nullptr
		, dwStyle
		, rRect
		, hWndParent
		, nID
		, hInstance
		, pParam );
}

/**********************************************************************//**
 *
 * EBhE̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	dwExStyle		= gEBhEX^C
 * @param [in]	dwStyle			= EBhEX^C
 * @param [in]	x,y,w,h			= EBhË
 * @param [in]	hWndParent		= ẽEBhEnh
 * @param [in]	nID				= j[ID
 * @param [in]	hInstance		= CX^Xnh
 * @param [in]	pParam			= p[^
 * @return	EBhEnh
*//***********************************************************************/
HWND CTreeView::CreateEx( DWORD dwExStyle
					 , DWORD dwStyle
					 , int x, int y, int w, int h
					 , HWND hWndParent, int nID
					 , HINSTANCE hInstance
					 , void *pParam)
{
	// EBhE̍쐬
	return CreateWindowEx(dwExStyle
		, WC_TREEVIEW
		, nullptr
		, dwStyle
		, x, y, w, h
		, hWndParent
		, (HMENU)(UINT_PTR)nID
		, hInstance
		, pParam );
}

/**********************************************************************//*
 * @name	bp[֐
 * @{
*//***********************************************************************/
HTREEITEM		CTreeView::InsertItem(LPTV_INSERTSTRUCT lpis)				{ return TreeView_InsertItem(m_hWnd, lpis); }
/**********************************************************************//*
 * @}
*//***********************************************************************/

}	// end of namespace wx
}	// end of namespace iris

