//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXRichText.cpp
 * @brief		b`eLXgRg[t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXRichText_CPP_

//======================================================================
// include
#include "WXRichText.h"
#include <tchar.h>
#include <windowsx.h>
#include <commctrl.h>
#include "fnd/utility/FndRefCounter.h"

namespace iris {
namespace wx
{

//======================================================================
// variable
namespace 
{

//! b`GfBbgRg[̃CuǗNX
class CRichTextLib : public fnd::CRefCounter
{
	HINSTANCE m_hLib;
public:
	// RXgN^
	CRichTextLib(void) : m_hLib(nullptr) {}
public:
	// ǂݍ
	BOOL	Load(void)
	{
		AddRef();
		if( m_hLib != nullptr ) return TRUE;
#if (_RICHEDIT_VER >= 0x0200 )
		m_hLib = LoadLibrary(TEXT("RICHED20.DLL"));
#else
		m_hLib = LoadLibrary(TEXT("RICHED.DLL"));
#endif
		if( m_hLib == nullptr ) return FALSE;
		return TRUE;
	}
	// 
	BOOL	Free(void)
	{
		SubRef();
		if( GetRef() <= 0 )
		{
			if( m_hLib != nullptr )
			{
				if( !FreeLibrary(m_hLib) ) return FALSE;
				m_hLib = nullptr;
			}
		}
		return TRUE;
	}
};

}
static CRichTextLib	s_RTLib;

//======================================================================
// function
/**********************************************************************//**
 *
 * Cu̓ǂݍ
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL		RichText_LoadLibrary(void)
{
	return s_RTLib.Load();
}
/**********************************************************************//**
 *
 * Củ
 *
 ----------------------------------------------------------------------
 * @retval	TRUE	= ꂽ
 * @retval	FALSE	= ĂȂ
*//***********************************************************************/
BOOL		RichText_FreeLibrary(void)
{
	return s_RTLib.Free();
}

// RichEdit 1.0
/**********************************************************************//**
 *
 * w肳ꂽNbv{[h`\t邱Ƃł邩ǂ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @param [in]	uFormat	= Nbv{[h`
 * @return	^Ul
*//***********************************************************************/
BOOL		RichText_CanPaste(HWND hWnd, UINT uFormat)
{
	return (BOOL)SendMessage(hWnd, EM_CANPASTE, (WPARAM)uFormat, 0);
}
/**********************************************************************//**
 *
 * FormatRange ňȑOɏꂽb` GfBbg Rg[
 * (eLXg OLE ACe) ̓ëꕔ\
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd			= Ώۃnh
 * @param [in]	pDisplayRect	= \̈
 * @return	
*//***********************************************************************/
BOOL		RichText_DisplayBand(HWND hWnd, LPRECT pDisplayRect)
{
	return (BOOL)SendMessage(hWnd, EM_CANPASTE, 0, (LPARAM)pDisplayRect);
}
/**********************************************************************//**
 *
 * ݂̑I̋E擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @param [out]	lpcr	= o
*//***********************************************************************/
void		RichText_ExGetSel(HWND hWnd, CHARRANGE* lpcr)
{
	SendMessage(hWnd, EM_EXGETSEL, 0, (LPARAM)lpcr);
}
/**********************************************************************//**
 *
 * ͂łeLXg̒𐧌
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @param [in]	lChars	= oCg(OLEIuWFNg܂ށB0w肷ƃftHgl(64KB))
*//***********************************************************************/
void		RichText_ExLimitText(HWND hWnd, LONG lChars)
{
	SendMessage(hWnd, EM_EXLIMITTEXT, 0, (LPARAM)lChars);
}
/**********************************************************************//**
 *
 * w肳ꂽCfbNXs̍sԍ擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @param [in]	lIndex	= CfbNX(-1̏ꍇA݂܂͑I̐擪̍sԍԂ)
 * @return	sԍ
*//***********************************************************************/
LONG		RichText_ExLineFromChar(HWND hWnd, LONG lIndex)
{
	return (LONG)SendMessage(hWnd, EM_EXLINEFROMCHAR, 0, (LPARAM)lIndex);
}
/**********************************************************************//**
 *
 * I̋Eݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @param [in]	lpcr	= Ep[^
*//***********************************************************************/
void		RichText_ExSetSel(HWND hWnd, CHARRANGE* lpcr)
{
	SendMessage(hWnd, EM_EXSETSEL, 0, (LPARAM)lpcr);
}
/**********************************************************************//**
 *
 * eLXg
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۃnh
 * @param [in]	dwFlag		= (FR_***)
 * @param [io]	lpFindText	= ̃p[^
 * @return	Ɉv镶ʒu(vȂꍇ́A-1)
*//***********************************************************************/
LONG		RichText_FindText(HWND hWnd, DWORD dwFlag, FINDTEXT* lpFindText)
{
	return (LONG)SendMessage(hWnd, EM_FINDTEXT, (WPARAM)dwFlag, (LPARAM)lpFindText);
}
/**********************************************************************//**
 *
 * eLXg
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۃnh
 * @param [in]	dwFlag		= (FR_***)
 * @param [io]	lpFindText	= ̃p[^
 * @return	Ɉv镶ʒu(vȂꍇ́A-1)
*//***********************************************************************/
LONG		RichText_FindTextEx(HWND hWnd, DWORD dwFlag, FINDTEXTEX* lpFindText)
{
	return (LONG)SendMessage(hWnd, EM_FINDTEXTEX, (WPARAM)dwFlag, (LPARAM)lpFindText);
}
/**********************************************************************//**
 *
 * w肳ꂽʒu̒O܂͒̃[h؂
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @param [in]	nCode	= (WB_***)
 * @param [in]	nStart	= ̊Jnʒu
 * @return	nCode̎wɂĕς
*//***********************************************************************/
DWORD		RichText_FindWordBreak(HWND hWnd, UINT nCode, DWORD nStart)
{
	return (DWORD)SendMessage(hWnd, EM_FINDWORDBREAK, (WPARAM)nCode, (LPARAM)nStart);
}
/**********************************************************************//**
 *
 * w肳ꂽfoCXpɃeLXg͈̔͂
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۃnh
 * @param [in]	lpfr		= o̓foCX̏܂ FORMATRANGE \̂ւ̃|C^
 * @param [in]	bDisplay	= eLXg`悷邩ǂ
 * @return	̈ɓŌ̃̕CfbNX 1 l
*//***********************************************************************/
LONG		RichText_FormatRange(HWND hWnd, FORMATRANGE* lpfr, BOOL bDisplay)
{
	return (LONG)SendMessage(hWnd, EM_FORMATRANGE, (WPARAM)bDisplay, (LPARAM)lpfr);
}
/**********************************************************************//**
 *
 * 擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @param [in]	uFlags	= SCF_DEFAULT or SCF_SELECTION
 * @param [out]	lpcf	= CHARFORMAT or CHARFORMAT2
 * @return	lpcfdwMaskoԂ
*//***********************************************************************/
DWORD		RichText_GetCharFormat (HWND hWnd, UINT uFlags, CHARFORMAT*  lpcf)
{
	return (DWORD)SendMessage(hWnd, EM_GETCHARFORMAT, (WPARAM)uFlags, (LPARAM)lpcf);
}
/// iris::wx::RichText_GetCharFormat Q
DWORD		RichText_GetCharFormatA(HWND hWnd, UINT uFlags, CHARFORMATA* lpcf)
{
	return (DWORD)SendMessage(hWnd, EM_GETCHARFORMAT, (WPARAM)uFlags, (LPARAM)lpcf);
}
/// iris::wx::RichText_GetCharFormat Q
DWORD		RichText_GetCharFormatW(HWND hWnd, UINT uFlags, CHARFORMATW* lpcf)
{
	return (DWORD)SendMessage(hWnd, EM_GETCHARFORMAT, (WPARAM)uFlags, (LPARAM)lpcf);
}
/**********************************************************************//**
 *
 * Cxg}XN擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @return	Cxg}XN
*//***********************************************************************/
LONG		RichText_GetEventMask(HWND hWnd)
{
	return (LONG)SendMessage(hWnd, EM_GETEVENTMASK, 0, 0);
}
/**********************************************************************//**
 *
 * OLEC^[tFCX̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @param [in]	wParam	= 
 * @param [in]	lParam	= 
 * @return	
*//***********************************************************************/
LRESULT		RichText_GetOLEInterface(HWND hWnd, WPARAM wParam, LPARAM lParam)
{
	return SendMessage(hWnd, EM_GETOLEINTERFACE, wParam, lParam);
}
/**********************************************************************//**
 *
 * IvV擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @return	IvV(ECO_***)
*//***********************************************************************/
UINT		RichText_GetOptions(HWND hWnd)
{
	return (UINT)SendMessage(hWnd, EM_GETOPTIONS, 0, 0);
}
/**********************************************************************//**
 *
 * i擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @param [out]	lppf	= CHARFORMAT or CHARFORMAT2
 * @return	lppfdwMaskoԂ
*//***********************************************************************/
DWORD		RichText_GetParaFormat(HWND hWnd, UINT uFlags, PARAFORMAT* lppf)
{
	return (DWORD)SendMessage(hWnd, EM_GETPARAFORMAT, (WPARAM)uFlags, (LPARAM)lppf);
}
/**********************************************************************//**
 *
 * ݂̑IeLXg擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۃnh
 * @param [out]	lpString	= o
 * @return	Rs[ꂽԂ܂BI[ nullptr ܂݂܂
*//***********************************************************************/
LONG		RichText_GetSelText(HWND hWnd, LPSTR lpString)
{
	return (LONG)SendMessage(hWnd, EM_GETSELTEXT, 0, (LPARAM)lpString);
}
/**********************************************************************//**
 *
 * w肳ꂽ͈͂̃eLXg擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @param [out]	lptr	= p[^
 * @return	Rs[ꂽԂ܂BI[ nullptr ܂݂܂
*//***********************************************************************/
LONG		RichText_GetTextRange(HWND hWnd, TEXTRANGE* lptr)
{
	return (LONG)SendMessage(hWnd, EM_GETTEXTRANGE, 0, (LPARAM)lptr);
}
/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @param [in]	wParam	= 
 * @param [in]	lParam	= 
 * @return	
*//***********************************************************************/
LRESULT		RichText_GetWordBreakProcEx(HWND hWnd, WPARAM wParam, LPARAM lParam)
{
	return SendMessage(hWnd, EM_GETWORDBREAKPROCEX, wParam, lParam);
}
/**********************************************************************//**
 *
 * I̕\Ɣ\̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @param [in]	bHide	= \ݒ
*//***********************************************************************/
void		RichText_HideSelection(HWND hWnd, BOOL bHide)
{
	SendMessage(hWnd, EM_HIDESELECTION, (WPARAM)bHide, 0);
}
/**********************************************************************//**
 *
 * I̕\Ɣ\̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۃnh
 * @param [in]	nClipFormat	= Nbv{[ȟ`
 * @param [in]	lprps		= p[^
*//***********************************************************************/
void		RichText_PasteSpecial(HWND hWnd, UINT nClipFormat, REPASTESPECIAL* lprps)
{
	SendMessage(hWnd, EM_PASTESPECIAL, (WPARAM)nClipFormat, (LPARAM)lprps);
}
/**********************************************************************//**
 *
 * eEBhEւ EN_REQUESTRESIZE ʒmbZ[WIɑM
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
*//***********************************************************************/
void		RichText_RequestResize(HWND hWnd)
{
	SendMessage(hWnd, EM_REQUESTRESIZE, 0, 0);
}
/**********************************************************************//**
 *
 * I̎ނ擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @return	I̎(SEL_***)
*//***********************************************************************/
WORD		RichText_SelectionType(HWND hWnd)
{
	return (WORD)SendMessage(hWnd, EM_SELECTIONTYPE, 0, 0);
}
/**********************************************************************//**
 *
 * wiFݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۃnh
 * @param [in]	bSysColor	= VXeJ[gpꍇ́Atrue(color͖܂)
 * @param [in]	color		= F
 * @return	ȑO̐F
*//***********************************************************************/
COLORREF	RichText_SetBkGndColor(HWND hWnd, BOOL bSysColor, COLORREF color)
{
	return (COLORREF)SendMessage(hWnd, EM_SETBKGNDCOLOR, (WPARAM)bSysColor, (LPARAM)color);
}
/**********************************************************************//**
 *
 * ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @param [in]	uFlags	= SCF_***
 * @param [in]	lpcf	= CHARFORMAT or CHARFORMAT2
 * @return	
*//***********************************************************************/
BOOL		RichText_SetCharFormat (HWND hWnd, UINT uFlags, CHARFORMAT*  lpcf)
{
	return (BOOL)SendMessage(hWnd, EM_SETCHARFORMAT, (WPARAM)uFlags, (LPARAM)lpcf);
}
/// iris::wx::RichText_SetCharFormat Q
BOOL		RichText_SetCharFormatA(HWND hWnd, UINT uFlags, CHARFORMATA* lpcf)
{
	return (BOOL)SendMessage(hWnd, EM_SETCHARFORMAT, (WPARAM)uFlags, (LPARAM)lpcf);
}
/// iris::wx::RichText_SetCharFormat Q
BOOL		RichText_SetCharFormatW(HWND hWnd, UINT uFlags, CHARFORMATW* lpcf)
{
	return (BOOL)SendMessage(hWnd, EM_SETCHARFORMAT, (WPARAM)uFlags, (LPARAM)lpcf);
}
/**********************************************************************//**
 *
 * Cxg}XNݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۃnh
 * @param [in]	dwEventMask	= Cxg}XN
 * @return	ȑÕCxg}XN
*//***********************************************************************/
DWORD		RichText_SetEventMask(HWND hWnd, DWORD dwEventMask)
{
	return (DWORD)SendMessage(hWnd, EM_SETEVENTMASK, 0, (LPARAM)dwEventMask);
}
/**********************************************************************//**
 *
 * OLE ֘Ã\[XɃANZX邽߂ɎgR[obNw
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @param [in]	wParam	= 
 * @param [in]	lParam	= 
 * @return	
*//***********************************************************************/
LRESULT		RichText_SetOLECallback(HWND hWnd, WPARAM wParam, LPARAM lParam)
{
	return SendMessage(hWnd, EM_SETOLECALLBACK, wParam, lParam);
}
/**********************************************************************//**
 *
 * IvVݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @param [in]	wOp		= ̎ނ̎w(ECOOP_***)
 * @param [in]	dwFlags	= b` GfBbg̃IvV(ECO_***)
*//***********************************************************************/
void		RichText_SetOptions(HWND hWnd, WORD wOp, DWORD dwFlags)
{
	SendMessage(hWnd, EM_SETOPTIONS, (WPARAM)wOp, (LPARAM)dwFlags);
}
/**********************************************************************//**
 *
 * iݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @param [in]	uFlags	= SCF_***
 * @param [in]	lppf	= CHARFORMAT or CHARFORMAT2
 * @return	
*//***********************************************************************/
BOOL		RichText_SetParaFormat(HWND hWnd, UINT uFlags, PARAFORMAT* lppf)
{
	return (BOOL)SendMessage(hWnd, EM_SETPARAFORMAT, (WPARAM)uFlags, (LPARAM)lppf);
}
/**********************************************************************//**
 *
 * Ɏg^[Qbg foCXƍsݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @param [in]	lppf	= CHARFORMAT or CHARFORMAT2
 * @return	
*//***********************************************************************/
BOOL		RichText_SetTargetDevice(HWND hWnd, HDC hDC, LONG lLineWidth)
{
	return (BOOL)SendMessage(hWnd, EM_SETTARGETDEVICE, (WPARAM)hDC, (LPARAM)lLineWidth);
}
/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @param [in]	wParam	= 
 * @param [in]	lParam	= 
 * @return	
*//***********************************************************************/
LRESULT		RichText_SetWordBreakProcEx(HWND hWnd, WPARAM wParam, LPARAM lParam)
{
	return SendMessage(hWnd, EM_SETWORDBREAKPROCEX, wParam, lParam);
}
/**********************************************************************//**
 *
 * eLXgw肳ꂽ̓Xg[̃eLXgɒu
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @param [in]	nFormat	= tH[}bg(SF_*** + SFE_***)
 * @param [in]	lpes	= p[^
 * @return	̓Xg[ǂݍ񂾕
*//***********************************************************************/
LONG		RichText_StreamIn(HWND hWnd, int nFormat, EDITSTREAM* lpes)
{
	return (BOOL)SendMessage(hWnd, EM_STREAMIN, (WPARAM)nFormat, (LPARAM)lpes);
}
/**********************************************************************//**
 *
 * eLXgw肳ꂽo̓Xg[ɏo
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @param [in]	nFormat	= tH[}bg(SF_*** + SFE_***)
 * @param [in]	lpes	= p[^
 * @return	o̓Xg[ɏ܂ꂽ
*//***********************************************************************/
LONG		RichText_StreamOut(HWND hWnd, int nFormat, EDITSTREAM* lpes)
{
	return (BOOL)SendMessage(hWnd, EM_STREAMOUT, (WPARAM)nFormat, (LPARAM)lpes);
}

// RichEdit 2.0
/**********************************************************************//**
 *
 * URL̎o̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @param [in]	bEnable	= LEݒ
 * @return	
*//***********************************************************************/
BOOL		RichText_AutoUrlDetect(HWND hWnd, BOOL bEnable)
{
	return (BOOL)SendMessage(hWnd, EM_AUTOURLDETECT, (WPARAM)bEnable, 0);
}
/**********************************************************************//**
 *
 * 蒼L[ɃANV܂܂Ă邩ǂ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @return	^Ul
*//***********************************************************************/
BOOL		RichText_CanRedo(HWND hWnd)
{
	return (BOOL)SendMessage(hWnd, EM_CANREDO, 0, 0);
}
/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @param [in]	wParam	= 
 * @param [in]	lParam	= 
 * @return	
*//***********************************************************************/
LRESULT		RichText_ConvPosition(HWND hWnd, WPARAM wParam, LPARAM lParam)
{
	return SendMessage(hWnd, EM_CONVPOSITION, wParam, lParam);
}
/**********************************************************************//**
 *
 * eLXg
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۃnh
 * @param [in]	dwFlag		= (FR_***)
 * @param [io]	lpFindText	= ̃p[^
 * @return	Ɉv镶ʒu(vȂꍇ́A-1)
*//***********************************************************************/
LONG		RichText_FindTextA(HWND hWnd, DWORD dwFlag, FINDTEXTA* lpFindText)
{
	return (LONG)SendMessage(hWnd, EM_FINDTEXT , (WPARAM)dwFlag, (LPARAM)lpFindText);
}
/// iris::wx::RichText_FindTextA Q
LONG		RichText_FindTextW(HWND hWnd, DWORD dwFlag, FINDTEXTW* lpFindText)
{
	return (LONG)SendMessage(hWnd, EM_FINDTEXTW, (WPARAM)dwFlag, (LPARAM)lpFindText);
}
/**********************************************************************//**
 *
 * eLXg
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۃnh
 * @param [in]	dwFlag		= (FR_***)
 * @param [io]	lpFindText	= ̃p[^
 * @return	Ɉv镶ʒu(vȂꍇ́A-1)
*//***********************************************************************/
LONG		RichText_FindTextExA(HWND hWnd, DWORD dwFlag, FINDTEXTEXA* lpFindText)
{
	return (LONG)SendMessage(hWnd, EM_FINDTEXTEX , (WPARAM)dwFlag, (LPARAM)lpFindText);
}
/// iris::wx::RichText_FindTextExA Q
LONG		RichText_FindTextExW(HWND hWnd, DWORD dwFlag, FINDTEXTEXW* lpFindText)
{
	return (LONG)SendMessage(hWnd, EM_FINDTEXTEXW, (WPARAM)dwFlag, (LPARAM)lpFindText);
}
/**********************************************************************//**
 *
 * URL̎oݒ̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @return	^Ul
*//***********************************************************************/
BOOL		RichText_GetAutoUrlDetect(HWND hWnd)
{
	return (BOOL)SendMessage(hWnd, EM_GETAUTOURLDETECT, 0, 0);
}
/**********************************************************************//**
 *
 * IMEϊ̐Fݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @param [out]	lpcc	= Fݒ
 * @return	
*//***********************************************************************/
BOOL		RichText_GetIMEColor(HWND hWnd, COMPCOLOR* lpcc)
{
	return (BOOL)SendMessage(hWnd, EM_GETIMECOLOR, 0, (LPARAM)lpcc);
}
/**********************************************************************//**
 *
 * IMẼ[h擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @return	[h(ICM_***)
*//***********************************************************************/
UINT		RichText_GetIMECompMode(HWND hWnd)
{
	return (UINT)SendMessage(hWnd, EM_GETIMECOMPMODE, 0, 0);
}
/**********************************************************************//**
 *
 * IMẼIvV擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @return	IvV(IMF_***)
*//***********************************************************************/
UINT		RichText_GetIMEOptions(HWND hWnd)
{
	return (UINT)SendMessage(hWnd, EM_GETIMEOPTIONS, 0, 0);
}
/**********************************************************************//**
 *
 * IMĚIvV擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۃnh
 * @return	IvV(IMF_***)
*//***********************************************************************/
UINT		RichText_GetLangOptions(HWND hWnd)
{
	return (UINT)SendMessage(hWnd, EM_GETLANGOPTIONS, 0, 0);
}
/**********************************************************************//**
 *
 * ݂̋؂蕶擾
 * (OS̃AWAo[Ŵ)
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @param [in]	uType	= ؂^tO(PC_***)
 * @param [out]	lpPunc	= p[^
 * @return	
*//***********************************************************************/
BOOL		RichText_GetPunctuation(HWND hWnd, UINT uType, PUNCTUATION* lpPunc)
{
	return (BOOL)SendMessage(hWnd, EM_GETPUNCTUATION, (WPARAM)uType, (LPARAM)lpPunc);
}
/**********************************************************************//**
 *
 * ̂蒼L[̎ނ擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @return	
*//***********************************************************************/
UNDONAMEID	RichText_GetRedoName(HWND hWnd)
{
	return (UNDONAMEID)SendMessage(hWnd, EM_GETREDONAME, 0, 0);
}
/**********************************************************************//**
 *
 * eLXg̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۃnh
 * @param [in]	lpgtex		= o͐ݒp[^
 * @param [out]	lpString	= o̓obt@
 * @return	Rs[TCY
*//***********************************************************************/
LONG		RichText_GetTextEx(HWND hWnd, GETTEXTEX* lpgtex, LPTSTR lpString)
{
	return (LONG)SendMessage(hWnd, EM_GETTEXTEX, (WPARAM)lpgtex, (LPARAM)lpString);
}
/**********************************************************************//**
 *
 * eLXgvZ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۃnh
 * @param [in]	dwFlags		= eLXgŎgp郁\bhl(GTL_***)
 * @param [in]	uCodePage	= |̃R[hy[W (CP_ACP  ANSI R[hy[WA1200  Unicode ܂)
 * @return	eLXg
*//***********************************************************************/
LONG		RichText_GetTextLengthEx(HWND hWnd, DWORD dwFlags, UINT uCodePage)
{
	GETTEXTLENGTHEX gtex = { dwFlags, uCodePage };
	return (LONG)SendMessage(hWnd, EM_GETTEXTLENGTHEX, (WPARAM)&gtex, 0);
}
/**********************************************************************//**
 *
 * eLXg[hƃAhDx擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @return	TEXTMODEl
*//***********************************************************************/
UINT		RichText_GetTextMode(HWND hWnd)
{
	return (UINT)SendMessage(hWnd, EM_GETTEXTMODE, 0, 0);
}
/**********************************************************************//**
 *
 * w肳ꂽ͈͂̃eLXg擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @param [out]	lptr	= p[^
 * @return	Rs[ꂽԂ܂BI[ nullptr ܂݂܂
*//***********************************************************************/
LONG		RichText_GetTextRangeA(HWND hWnd, TEXTRANGEA* lptr)
{
	return (LONG)SendMessage(hWnd, EM_GETTEXTRANGE, 0, (LPARAM)lptr);
}
/// iris::wx::RichText_GetTextRangeA Q
LONG		RichText_GetTextRangeW(HWND hWnd, TEXTRANGEW* lptr)
{
	return (LONG)SendMessage(hWnd, EM_GETTEXTRANGE, 0, (LPARAM)lptr);
}
/**********************************************************************//**
 *
 * ̃AhDL[̎ނ擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @return	
*//***********************************************************************/
UNDONAMEID	RichText_GetUndoName(HWND hWnd)
{
	return (UNDONAMEID)SendMessage(hWnd, EM_GETUNDONAME, 0, 0);
}
/**********************************************************************//**
 *
 * [hbv IvVƃ[h؂IvV擾
 * (OS̃AWAo[Ŵ)
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @return	IvV(WBF_***)
*//***********************************************************************/
UINT		RichText_GetWordWrapMode(HWND hWnd)
{
	return (UINT)SendMessage(hWnd, EM_GETWORDWRAPMODE, 0, 0);
}
/**********************************************************************//**
 *
 * 蒼
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @return	
*//***********************************************************************/
BOOL		RichText_Redo(HWND hWnd)
{
	return (BOOL)SendMessage(hWnd, EM_REDO, 0, 0);
}
/**********************************************************************//**
 *
 * IMEϊ̐Fݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @param [in]	lpcc	= Fݒ
 * @return	
*//***********************************************************************/
BOOL		RichText_SetIMEColor(HWND hWnd, COMPCOLOR* lpcc)
{
	return (BOOL)SendMessage(hWnd, EM_SETIMECOLOR, 0, (LPARAM)lpcc);
}
/**********************************************************************//**
 *
 * IMẼIvVݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۃnh
 * @param [in]	wOp			= w(ECOOP_***)
 * @param [in]	uOptions	= IvV(IMF_***)
 * @return	
*//***********************************************************************/
BOOL		RichText_SetIMEOptions(HWND hWnd, WORD wOp, UINT uOptions)
{
	return (BOOL)SendMessage(hWnd, EM_SETIMEOPTIONS, (WPARAM)wOp, (LPARAM)uOptions);
}
/**********************************************************************//**
 *
 * IMĚIvVݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۃnh
 * @param [in]	uOptions	= IvV(IMF_***)
 * @return	
*//***********************************************************************/
void		RichText_SetLangOptions(HWND hWnd, UINT uOptions)
{
	SendMessage(hWnd, EM_SETLANGOPTIONS, 0, (LPARAM)uOptions);
}
/**********************************************************************//**
 *
 * pbg̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۃnh
 * @param [in]	hPalette	= Vpbg
*//***********************************************************************/
void		RichText_SetPalette(HWND hWnd, HPALETTE hPalette)
{
	SendMessage(hWnd, EM_SETPALETTE, (WPARAM)hPalette, 0);
}
/**********************************************************************//**
 *
 * ؂蕶ݒ
 * (OS̃AWAo[Ŵ)
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @param [in]	uType	= ؂LtO(PC_***)
 * @param [in]	lpPunc	= p[^
 * @return	
*//***********************************************************************/
BOOL		RichText_SetPunctuation(HWND hWnd, UINT uType, PUNCTUATION* lpPunc)
{
	return (BOOL)SendMessage(hWnd, EM_SETPUNCTUATION, (WPARAM)uType, (LPARAM)lpPunc);
}
/**********************************************************************//**
 *
 * eLXg̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۃnh
 * @param [in]	lpgtex		= ͐ݒp[^
 * @param [in]	lpString	= ̓obt@
 * @return	
*//***********************************************************************/
BOOL		RichText_SetTextEx(HWND hWnd, SETTEXTEX* lpgtex, LPTSTR lpString)
{
	return (BOOL)SendMessage(hWnd, EM_SETTEXTEX, (WPARAM)lpgtex, (LPARAM)lpString);
}
/**********************************************************************//**
 *
 * eLXg[h܂̓AhDxݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @param [in]	uMode	= (TM_***)
 * @return	
*//***********************************************************************/
BOOL		RichText_SetTextMode(HWND hWnd, UINT uMode)
{
	return (BOOL)SendMessage(hWnd, EM_SETTEXTMODE, (WPARAM)uMode, 0);
}
/**********************************************************************//**
 *
 * AhDL[Ɋi[łőANVݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @param [in]	uLimit	= őANV
 * @return	AhDANV񐔂̐Vől
*//***********************************************************************/
UINT		RichText_SetUndoLimit(HWND hWnd, UINT uLimit)
{
	return (UINT)SendMessage(hWnd, EM_SETTEXTMODE, (WPARAM)uLimit, 0);
}
/**********************************************************************//**
 *
 * [hbv IvVƃ[h؂IvVݒ
 * (OS̃AWAo[Ŵ)
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @param [in]	uFlags	= IvV(WBF_***)
 * @return	݂̃IvV(WBF_***)
*//***********************************************************************/
UINT		RichText_SetWordWrapMode(HWND hWnd, UINT uFlags)
{
	return (UINT)SendMessage(hWnd, EM_SETWORDWRAPMODE, (WPARAM)uFlags, 0);
}
/**********************************************************************//**
 *
 * XN[o[̕\ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @param [in]	uType	= (SB_VERT or SB_HORZ)
 * @param [in]	bShow	= \E\ݒ
*//***********************************************************************/
void		RichText_ShowScrollBar(HWND hWnd, UINT uType, BOOL bShow)
{
	SendMessage(hWnd, EM_SHOWSCROLLBAR, (WPARAM)uType, (LPARAM)bShow);
}
/**********************************************************************//**
 *
 * ݂̃AhDANVɂɓ̓ANVǉ邱Ƃ𒆎~
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
*//***********************************************************************/
void		RichText_StopGroupTyping(HWND hWnd)
{
	SendMessage(hWnd, EM_STOPGROUPTYPING, 0, 0);
}


/**********************************************************************//**
 *
 * LOGFONT̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @param [in]	uFlags	= SCF_DEFAULT or SCF_SELECTION
 * @param [out]	lplf	= o
 * @return 
*//***********************************************************************/
BOOL		RichText_GetLogFont (HWND hWnd, UINT uFlags, LOGFONT*  lplf)
{
#ifdef UNICODE
	return RichText_GetLogFontW(hWnd, uFlags, lplf);
#else
	return RichText_GetLogFontA(hWnd, uFlags, lplf);
#endif
}
/// iris::wx::RichText_GetLogFont Q
BOOL		RichText_GetLogFontA(HWND hWnd, UINT uFlags, LOGFONTA* lplf)
{
	if( lplf == nullptr ) return FALSE;
	CHARFORMAT2A cfm;
	cfm.cbSize = sizeof(cfm);
	DWORD dwMask = RichText_GetCharFormatA(hWnd, uFlags, &cfm);
	HDC hDC = GetDC(hWnd);
	lplf->lfHeight = MulDiv(cfm.yHeight, GetDeviceCaps(hDC, LOGPIXELSY), 1440);
	ReleaseDC(hWnd, hDC);
	lplf->lfWeight = FW_NORMAL;
	lplf->lfItalic = lplf->lfUnderline = lplf->lfStrikeOut = FALSE;
	if( (dwMask & CFM_BOLD) && (cfm.dwEffects & CFE_BOLD) )				lplf->lfWeight = FW_BOLD;
	if( (dwMask & CFM_ITALIC) && (cfm.dwEffects & CFE_ITALIC) )			lplf->lfItalic = TRUE;
	if( (dwMask & CFM_UNDERLINE) && (cfm.dwEffects & CFE_UNDERLINE) )	lplf->lfUnderline = TRUE;
	if( (dwMask & CFM_STRIKEOUT) && (cfm.dwEffects & CFE_STRIKEOUT) )	lplf->lfStrikeOut = TRUE;
	lplf->lfCharSet = cfm.bCharSet;
	lplf->lfQuality = DEFAULT_QUALITY;
	lplf->lfPitchAndFamily = cfm.bPitchAndFamily;
	strcpy_s( lplf->lfFaceName, LF_FACESIZE, cfm.szFaceName);
	return TRUE;
}
/// iris::wx::RichText_GetLogFont Q
BOOL		RichText_GetLogFontW(HWND hWnd, UINT uFlags, LOGFONTW* lplf)
{
	if( lplf == nullptr ) return FALSE;
	CHARFORMAT2W cfm;
	cfm.cbSize = sizeof(cfm);
	DWORD dwMask = RichText_GetCharFormatW(hWnd, uFlags, &cfm);
	HDC hDC = GetDC(hWnd);
	lplf->lfHeight = MulDiv(cfm.yHeight, GetDeviceCaps(hDC, LOGPIXELSY), 1440);
	ReleaseDC(hWnd, hDC);
	lplf->lfWeight = FW_NORMAL;
	lplf->lfItalic = lplf->lfUnderline = lplf->lfStrikeOut = FALSE;
	if( (dwMask & CFM_BOLD) && (cfm.dwEffects & CFE_BOLD) )				lplf->lfWeight = FW_BOLD;
	if( (dwMask & CFM_ITALIC) && (cfm.dwEffects & CFE_ITALIC) )			lplf->lfItalic = TRUE;
	if( (dwMask & CFM_UNDERLINE) && (cfm.dwEffects & CFE_UNDERLINE) )	lplf->lfUnderline = TRUE;
	if( (dwMask & CFM_STRIKEOUT) && (cfm.dwEffects & CFE_STRIKEOUT) )	lplf->lfStrikeOut = TRUE;
	lplf->lfCharSet = cfm.bCharSet;
	lplf->lfQuality = DEFAULT_QUALITY;
	lplf->lfPitchAndFamily = cfm.bPitchAndFamily;
	wcscpy_s( lplf->lfFaceName, LF_FACESIZE, cfm.szFaceName);
	return TRUE;
}

/**********************************************************************//**
 *
 * LOGFONT̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @param [in]	uFlags	= SCF_DEFAULT or SCF_SELECTION
 * @param [in]	lplf	= 
 * @return 
*//***********************************************************************/
BOOL		RichText_SetLogFont (HWND hWnd, UINT uFlags, LOGFONT*  lplf)
{
#ifdef UNICODE
	return RichText_SetLogFontW(hWnd, uFlags, lplf);
#else
	return RichText_SetLogFontA(hWnd, uFlags, lplf);
#endif
}
/// iris::wx::RichText_SetLogFont Q
BOOL		RichText_SetLogFontA(HWND hWnd, UINT uFlags, LOGFONTA* lplf)
{
	if( lplf == nullptr ) return FALSE;
	CHARFORMAT2A cfm;
	cfm.cbSize = sizeof(cfm);
	RichText_GetCharFormatA(hWnd, uFlags, &cfm);
	HDC hDC = GetDC(hWnd);
	cfm.yHeight = IRIS_Pixel2Twip(-lplf->lfHeight, GetDeviceCaps(hDC, LOGPIXELSY));
	ReleaseDC(hWnd, hDC);
	cfm.dwMask |= CFM_BOLD | CFM_ITALIC | CFM_UNDERLINE | CFM_STRIKEOUT | CFM_SIZE | CFM_FACE;
	if( lplf->lfWeight >= FW_BOLD ) cfm.dwEffects |= CFE_BOLD;
	else							cfm.dwEffects &= ~CFE_BOLD;
	if( lplf->lfItalic )	cfm.dwEffects |= CFE_ITALIC;
	else					cfm.dwEffects &= ~CFE_ITALIC;
	if( lplf->lfUnderline )	cfm.dwEffects |= CFE_UNDERLINE;
	else					cfm.dwEffects &= ~CFE_UNDERLINE;
	if( lplf->lfStrikeOut )	cfm.dwEffects |= CFE_STRIKEOUT;
	else					cfm.dwEffects &= ~CFE_STRIKEOUT;

	cfm.bCharSet = lplf->lfCharSet;
	cfm.bPitchAndFamily = lplf->lfPitchAndFamily;
	strcpy_s( cfm.szFaceName, LF_FACESIZE, lplf->lfFaceName);
	RichText_SetCharFormatA(hWnd, uFlags, &cfm);
	return TRUE;
}
/// iris::wx::RichText_SetLogFont Q
BOOL		RichText_SetLogFontW(HWND hWnd, UINT uFlags, LOGFONTW* lplf)
{
	if( lplf == nullptr ) return FALSE;
	CHARFORMAT2W cfm;
	cfm.cbSize = sizeof(cfm);
	RichText_GetCharFormatW(hWnd, uFlags, &cfm);
	HDC hDC = GetDC(hWnd);
	cfm.yHeight = IRIS_Pixel2Twip(-lplf->lfHeight, GetDeviceCaps(hDC, LOGPIXELSY));
	ReleaseDC(hWnd, hDC);
	cfm.dwMask |= CFM_BOLD | CFM_ITALIC | CFM_UNDERLINE | CFM_STRIKEOUT | CFM_SIZE | CFM_FACE;
	if( lplf->lfWeight >= FW_BOLD ) cfm.dwEffects |= CFE_BOLD;
	else							cfm.dwEffects &= ~CFE_BOLD;
	if( lplf->lfItalic )	cfm.dwEffects |= CFE_ITALIC;
	else					cfm.dwEffects &= ~CFE_ITALIC;
	if( lplf->lfUnderline )	cfm.dwEffects |= CFE_UNDERLINE;
	else					cfm.dwEffects &= ~CFE_UNDERLINE;
	if( lplf->lfStrikeOut )	cfm.dwEffects |= CFE_STRIKEOUT;
	else					cfm.dwEffects &= ~CFE_STRIKEOUT;

	cfm.bCharSet = lplf->lfCharSet;
	cfm.bPitchAndFamily = lplf->lfPitchAndFamily;
	wcscpy_s( cfm.szFaceName, LF_FACESIZE, lplf->lfFaceName);
	RichText_SetCharFormatW(hWnd, uFlags, &cfm);
	return TRUE;
}

//======================================================================
// class
// CRichText10
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CRichText10::CRichText10(void)
{
	RichText_LoadLibrary();
}
/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= EBhEnh
*//***********************************************************************/
CRichText10::CRichText10(HWND hWnd)
: CEditBox(hWnd)
{
	RichText_LoadLibrary();
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CRichText10::~CRichText10(void)
{
	RichText_FreeLibrary();
}

/**********************************************************************//**
 *
 * EBhE̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	dwStyle			= EBhEX^C
 * @param [in]	lpszWindowName	= EBhE̖O
 * @param [in]	rRect			= RECT\̂̎Q
 * @param [in]	hWndParent		= ẽEBhEnh
 * @param [in]	nID				= j[ID
 * @param [in]	hInstance		= CX^Xnh
 * @param [in]	pParam			= p[^
 * @return	EBhEnh
*//***********************************************************************/
HWND CRichText10::Create( DWORD dwStyle
					, LPCTSTR lpszWindowName
					, const RECT &rRect
					, HWND hWndParent, int nID
					, HINSTANCE hInstance
					, void* pParam )
{
	return CWindow::Create(RICHEDIT_CLASS
		, lpszWindowName
		, dwStyle
		, rRect
		, hWndParent
		, nID
		, hInstance
		, pParam );
}
/**********************************************************************//**
 *
 * EBhE̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	dwStyle			= EBhEX^C
 * @param [in]	lpszWindowName	= EBhE̖O
 * @param [in]	x,y,w,h			= EBhË
 * @param [in]	hWndParent		= ẽEBhEnh
 * @param [in]	nID				= j[ID
 * @param [in]	hInstance		= CX^Xnh
 * @param [in]	pParam			= p[^
 * @return	EBhEnh
*//***********************************************************************/
HWND CRichText10::Create( DWORD dwStyle
					 , LPCTSTR lpszWindowName
					 , int x, int y, int w, int h
					 , HWND hWndParent, int nID
					 , HINSTANCE hInstance
					 , void* pParam )
{
	return CreateWindow(RICHEDIT_CLASS
		, lpszWindowName
		, dwStyle
		, x, y, w, h
		, hWndParent
		, (HMENU)(UINT_PTR)nID
		, hInstance
		, pParam );
}

/**********************************************************************//**
 *
 * EBhE̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	dwExStyle		= gEBhEX^C
 * @param [in]	dwStyle			= EBhEX^C
 * @param [in]	lpszWindowName	= EBhE̖O
 * @param [in]	rRect			= RECT\̂̎Q
 * @param [in]	hWndParent		= ẽEBhEnh
 * @param [in]	nID				= j[ID
 * @param [in]	hInstance		= CX^Xnh
 * @param [in]	pParam			= p[^
 * @return	EBhEnh
*//***********************************************************************/
HWND CRichText10::CreateEx( DWORD dwExStyle
					, DWORD dwStyle
					, LPCTSTR lpszWindowName
					, const RECT &rRect
					, HWND hWndParent, int nID
					, HINSTANCE hInstance
					, void* pParam )
{
	return CWindow::CreateEx(dwExStyle
		, RICHEDIT_CLASS
		, lpszWindowName
		, dwStyle
		, rRect
		, hWndParent
		, nID
		, hInstance
		, pParam );
}
/**********************************************************************//**
 *
 * EBhE̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	dwExStyle		= gEBhEX^C
 * @param [in]	dwStyle			= EBhEX^C
 * @param [in]	lpszWindowName	= EBhE̖O
 * @param [in]	x,y,w,h			= EBhË
 * @param [in]	hWndParent		= ẽEBhEnh
 * @param [in]	nID				= j[ID
 * @param [in]	hInstance		= CX^Xnh
 * @param [in]	pParam			= p[^
 * @return	EBhEnh
*//***********************************************************************/
HWND CRichText10::CreateEx( DWORD dwExStyle
					, DWORD dwStyle
					, LPCTSTR lpszWindowName
					, int x, int y, int w, int h
					, HWND hWndParent, int nID
					, HINSTANCE hInstance
					, void* pParam )
{
	return CreateWindowEx(dwExStyle
		, RICHEDIT_CLASS
		, lpszWindowName
		, dwStyle
		, x, y, w, h
		, hWndParent
		, (HMENU)(UINT_PTR)nID
		, hInstance
		, pParam );
}

/**********************************************************************//**
 *
 * Iڂ̊JnƏÏʒu̎擾
 *
 ----------------------------------------------------------------------
 * @param [out]	rFirst	= Jnʒu
 * @param [out]	rLast	= Iʒu
*//***********************************************************************/
void CRichText10::GetSel(LONG& rFirst, LONG& rLast)
{
	CHARRANGE cr;
	ExGetSel(&cr);
	rFirst	= cr.cpMin;
	rLast	= cr.cpMax;
}

/**********************************************************************//**
 *
 * Iڂ̊JnƏÏʒu̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	rFirst	= Jnʒu
 * @param [in]	rLast	= Iʒu
*//***********************************************************************/
void CRichText10::SetSel(LONG lFirst, LONG lLast)
{
	CHARRANGE cr;
	cr.cpMin = lFirst;
	cr.cpMax = lLast;
	ExSetSel(&cr);
}

/**********************************************************************//*
 * @name	bp[֐
 * @{
*//***********************************************************************/
BOOL		CRichText10::CanPaste(UINT uFormat)									{ return RichText_CanPaste(m_hWnd, uFormat); }
BOOL		CRichText10::DisplayBand(LPRECT pDisplayRect)						{ return RichText_DisplayBand(m_hWnd, pDisplayRect); }
void		CRichText10::ExGetSel(CHARRANGE* lpcr)								{ return RichText_ExGetSel(m_hWnd, lpcr); }
void		CRichText10::ExLimitText(LONG lChars)								{ return RichText_ExLimitText(m_hWnd, lChars); }
LONG		CRichText10::ExLineFromChar(LONG lIndex)							const { return RichText_ExLineFromChar(m_hWnd, lIndex); }
void		CRichText10::ExSetSel(CHARRANGE* lpcr)								{ return RichText_ExSetSel(m_hWnd, lpcr); }
LONG		CRichText10::FindText(DWORD dwFlag, FINDTEXT* lpFindText)			{ return RichText_FindText(m_hWnd, dwFlag, lpFindText); }
LONG		CRichText10::FindTextEx(DWORD dwFlag, FINDTEXTEX* lpFindText)		{ return RichText_FindTextEx(m_hWnd, dwFlag, lpFindText); }
DWORD		CRichText10::FindWordBreak(UINT nCode, DWORD nStart)				{ return RichText_FindWordBreak(m_hWnd, nCode, nStart); }
LONG		CRichText10::FormatRange(FORMATRANGE* lpfr, BOOL bDisplay)			{ return RichText_FormatRange(m_hWnd, lpfr, bDisplay); }
DWORD		CRichText10::GetCharFormat(UINT uFlags, CHARFORMAT* lpcf)			const	{ return RichText_GetCharFormat(m_hWnd, uFlags, lpcf); }
LONG		CRichText10::GetEventMask(void)										const	{ return RichText_GetEventMask(m_hWnd); }
LRESULT		CRichText10::GetOLEInterface(WPARAM wParam, LPARAM lParam)			const	{ return RichText_GetOLEInterface(m_hWnd, wParam, lParam); }
DWORD		CRichText10::GetParaFormat(UINT uFlags, PARAFORMAT* lppf)			const	{ return RichText_GetParaFormat(m_hWnd, uFlags, lppf); }
UINT		CRichText10::GetOptions(void)										const	{ return RichText_GetOptions(m_hWnd); }
LONG		CRichText10::GetSelText(LPSTR lpString)								const	{ return RichText_GetSelText(m_hWnd, lpString); }
LONG		CRichText10::GetTextRange(TEXTRANGE* lptr)							const	{ return RichText_GetTextRange(m_hWnd, lptr); }
LRESULT		CRichText10::GetWordBreakProcEx(WPARAM wParam, LPARAM lParam)		const	{ return RichText_GetWordBreakProcEx(m_hWnd, wParam, lParam); }
void		CRichText10::HideSelection(BOOL bHide)								{ return RichText_HideSelection(m_hWnd, bHide); }
void		CRichText10::PasteSpecial(UINT nClipFormat, REPASTESPECIAL* lprps)	{ return RichText_PasteSpecial(m_hWnd, nClipFormat, lprps); }
void		CRichText10::RequestResize(void)									{ return RichText_RequestResize(m_hWnd); }
WORD		CRichText10::SelectionType(void)									{ return RichText_SelectionType(m_hWnd); }
COLORREF	CRichText10::SetBkGndColor(BOOL bSysColor, COLORREF color)			{ return RichText_SetBkGndColor(m_hWnd, bSysColor, color); }
BOOL		CRichText10::SetCharFormat(UINT uFlags, CHARFORMAT* lpcf)			{ return RichText_SetCharFormat(m_hWnd, uFlags, lpcf); }
DWORD		CRichText10::SetEventMask(DWORD dwEventMask)						{ return RichText_SetEventMask(m_hWnd, dwEventMask); }
LRESULT		CRichText10::SetOLECallback(WPARAM wParam, LPARAM lParam)			{ return RichText_SetOLECallback(m_hWnd, wParam, lParam); }
void		CRichText10::SetOptions(WORD wOp, DWORD dwFlags)					{ return RichText_SetOptions(m_hWnd, wOp, dwFlags); }
BOOL		CRichText10::SetParaFormat(UINT uFlags, PARAFORMAT* lppf)			{ return RichText_SetParaFormat(m_hWnd, uFlags, lppf); }
BOOL		CRichText10::SetTargetDevice(HDC hDC, LONG lLineWidth)				{ return RichText_SetTargetDevice(m_hWnd, hDC, lLineWidth); }
LRESULT		CRichText10::SetWordBreakProcEx(WPARAM wParam, LPARAM lParam)		{ return RichText_SetWordBreakProcEx(m_hWnd, wParam, lParam); }
LONG		CRichText10::StreamIn(int nFormat, EDITSTREAM* lpes)				{ return RichText_StreamIn(m_hWnd, nFormat, lpes); }
LONG		CRichText10::StreamOut(int nFormat, EDITSTREAM* lpes)				{ return RichText_StreamOut(m_hWnd, nFormat, lpes); }

void		CRichText10::LimitText(int cchMax)									{ ExLimitText(cchMax); }
int			CRichText10::LineFromChar(int ich) const							{ return ExLineFromChar(ich); }
/**********************************************************************//*
 * @}
*//***********************************************************************/

//======================================================================
// class
// CRichText20
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CRichText20::CRichText20(void)
: CRichText10()
{
}
/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= EBhEnh
*//***********************************************************************/
CRichText20::CRichText20(HWND hWnd)
: CRichText10(hWnd)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CRichText20::~CRichText20(void)
{
}

/**********************************************************************//*
 * @name	bp[֐
 * @{
*//***********************************************************************/
BOOL		CRichText20::CanRedo(void)										{ return RichText_CanRedo(m_hWnd); }
LRESULT		CRichText20::ConvPosition(WPARAM wParam, LPARAM lParam)         { return RichText_ConvPosition(m_hWnd, wParam, lParam); }
LONG		CRichText20::FindTextA(DWORD dwFlag, FINDTEXTA* lpFindText)     { return RichText_FindTextA(m_hWnd, dwFlag, lpFindText); }
LONG		CRichText20::FindTextW(DWORD dwFlag, FINDTEXTW* lpFindText)     { return RichText_FindTextW(m_hWnd, dwFlag, lpFindText); }
LONG		CRichText20::FindTextExA(DWORD dwFlag, FINDTEXTEXA* lpFindText) { return RichText_FindTextExA(m_hWnd, dwFlag, lpFindText); }
LONG		CRichText20::FindTextExW(DWORD dwFlag, FINDTEXTEXW* lpFindText) { return RichText_FindTextExW(m_hWnd, dwFlag, lpFindText); }
BOOL		CRichText20::GetAutoUrlDetect(void)                             const	{ return RichText_GetAutoUrlDetect(m_hWnd); }
BOOL		CRichText20::GetIMEColor(COMPCOLOR* lpcc)                       const	{ return RichText_GetIMEColor(m_hWnd, lpcc); }
UINT		CRichText20::GetIMECompMode(void)                               const	{ return RichText_GetIMECompMode(m_hWnd); }
UINT		CRichText20::GetIMEOptions(void)                                const	{ return RichText_GetIMEOptions(m_hWnd); }
UINT		CRichText20::GetLangOptions(void)                               const	{ return RichText_GetLangOptions(m_hWnd); }
BOOL		CRichText20::GetPunctuation(UINT uType, PUNCTUATION* lpPunc)    const	{ return RichText_GetPunctuation(m_hWnd, uType, lpPunc); }
UNDONAMEID	CRichText20::GetRedoName(void)                                  const	{ return RichText_GetRedoName(m_hWnd); }
LONG		CRichText20::GetTextEx(GETTEXTEX* lpgtex, LPTSTR lpString)      const	{ return RichText_GetTextEx(m_hWnd, lpgtex, lpString); }
LONG		CRichText20::GetTextLengthEx(DWORD dwFlags, UINT uCodePage)     const	{ return RichText_GetTextLengthEx(m_hWnd, dwFlags, uCodePage); }
UINT		CRichText20::GetTextMode(void)                                  const	{ return RichText_GetTextMode(m_hWnd); }
LONG		CRichText20::GetTextRangeA(TEXTRANGEA* lptr)                    const	{ return RichText_GetTextRangeA(m_hWnd, lptr); }
LONG		CRichText20::GetTextRangeW(TEXTRANGEW* lptr)                    const	{ return RichText_GetTextRangeW(m_hWnd, lptr); }
UNDONAMEID	CRichText20::GetUndoName(void)                                  const	{ return RichText_GetUndoName(m_hWnd); }
UINT		CRichText20::GetWordWrapMode(void)                              const	{ return RichText_GetWordWrapMode(m_hWnd); }
BOOL		CRichText20::Redo(void)                                         { return RichText_Redo(m_hWnd); }
BOOL		CRichText20::SetAutoUrlDetect(BOOL bEnable)                     { return RichText_AutoUrlDetect(m_hWnd, bEnable); }
BOOL		CRichText20::SetIMEColor(COMPCOLOR* lpcc)                       { return RichText_SetIMEColor(m_hWnd, lpcc); }
BOOL		CRichText20::SetIMEOptions(WORD wOp, UINT uOptions)             { return RichText_SetIMEOptions(m_hWnd, wOp, uOptions); }
void		CRichText20::SetLangOptions(UINT uOptions)                      { return RichText_SetLangOptions(m_hWnd, uOptions); }
void		CRichText20::SetPalette(HPALETTE hPalette)                      { return RichText_SetPalette(m_hWnd, hPalette); }
BOOL		CRichText20::SetPunctuation(UINT uType, PUNCTUATION* lpPunc)    { return RichText_SetPunctuation(m_hWnd, uType, lpPunc); }
BOOL		CRichText20::SetTextEx(SETTEXTEX* lpgtex, LPTSTR lpString)      { return RichText_SetTextEx(m_hWnd, lpgtex, lpString); }
BOOL		CRichText20::SetTextMode(UINT uMode)                            { return RichText_SetTextMode(m_hWnd, uMode); }
UINT		CRichText20::SetUndoLimit(UINT uLimit)                          { return RichText_SetUndoLimit(m_hWnd, uLimit); }
UINT		CRichText20::SetWordWrapMode(UINT uFlags)                       { return RichText_SetWordWrapMode(m_hWnd, uFlags); }
void		CRichText20::ShowScrollBar(UINT uType, BOOL bShow)              { return RichText_ShowScrollBar(m_hWnd, uType, bShow); }
void		CRichText20::StopGroupTyping(void)                              { return RichText_StopGroupTyping(m_hWnd); }
/**********************************************************************//*
 * @}
*//***********************************************************************/

}	// end of namespace wx
}	// end of namespace iris
