//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXHotKey.cpp
 * @brief		zbgL[֘At@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXHotKey_CPP_

//======================================================================
// include
#include "WXHotKey.h"
#include "../WXComControl.h"
#include <commctrl.h>

namespace iris {
namespace wx
{

//======================================================================
// function

/**********************************************************************//**
 *
 * zbgL[ϊ
 *
 ----------------------------------------------------------------------
 * @param [in]	hotkeyf	= zbgL[l
 * @return	L[l
*//***********************************************************************/
BYTE HKM_TransMod(BYTE hotkeyf)
{
	BYTE mod=0;
	if(hotkeyf & HOTKEYF_ALT)		mod	 = FALT;
	if(hotkeyf & HOTKEYF_CONTROL)	mod |= FCONTROL;
	if(hotkeyf & HOTKEYF_SHIFT)		mod |= FSHIFT;
	return mod;
}

/**********************************************************************//**
 *
 * zbgL[ϊ
 *
 ----------------------------------------------------------------------
 * @param [in]	mod		= L[l
 * @return	zbgL[l
*//***********************************************************************/
BYTE HKM_TransHotKeyF(BYTE mod)
{
	BYTE keyf=0;
	if(mod & FALT)		keyf = HOTKEYF_ALT;
	if(mod & FCONTROL)	keyf |= HOTKEYF_CONTROL;
	if(mod & FSHIFT)	keyf |= HOTKEYF_SHIFT;
	return keyf;
}

/**********************************************************************//**
 *
 * zbgL[擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= ΏۃEBhEnh
 * @param [out]	mod		= o
 * @param [out]	key		= o
 * @return	擾l
*//***********************************************************************/
WORD HKM_GetHotKey(HWND hWnd, void* mod, void* key)
{
	WORD wHotKey = (WORD)SendMessage(hWnd, HKM_GETHOTKEY, 0, 0);
	if( mod != nullptr ) *(BYTE*)mod = HIBYTE(wHotKey);
	if( key != nullptr ) *(BYTE*)key = LOBYTE(wHotKey);
	return wHotKey;
}
/**********************************************************************//**
 *
 * zbgL[擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= ΏۃEBhEnh
 * @return	擾l
*//***********************************************************************/
WORD HKM_GetHotKey(HWND hWnd)
{
	return (WORD)SendMessage(hWnd, HKM_GETHOTKEY, 0, 0);
}
/**********************************************************************//**
 *
 * zbgL[ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= ΏۃEBhEnh
 * @param [in]	key		= L[
 * @param [in]	mod		= C
*//***********************************************************************/
void HKM_SetHotKey(HWND hWnd, BYTE key, BYTE mod)
{
	SendMessage(hWnd, HKM_SETHOTKEY, (WPARAM)MAKEWORD(key,mod), 0);
}
/**********************************************************************//**
 *
 * zbgL[ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= ΏۃEBhEnh
 * @param [in]	wParam	= MAKEWORD(key,mod)
*//***********************************************************************/
void HKM_SetHotKey(HWND hWnd, WPARAM wParam)
{
	SendMessage(hWnd, HKM_SETHOTKEY, wParam, 0);
}
/**********************************************************************//**
 *
 * zbgL[[ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= ΏۃEBhEnh
 * @param [in]	HkComb	= [
 * @param [in]	HkMod	= ֏CL[
*//***********************************************************************/
void HKM_SetRules(HWND hWnd, WORD HkComb, WORD HkMod)
{
	SendMessage(hWnd, HKM_SETRULES, (WPARAM)HkComb, MAKELPARAM(HkMod,0) );
}

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CHotKey::CHotKey(void)
{
	CComCtrl::Initialize(ICC_HOTKEY_CLASS);
}
/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= EBhEnh
*//***********************************************************************/
CHotKey::CHotKey(HWND hWnd)
: CSubClass(hWnd)
{
	CComCtrl::Initialize(ICC_HOTKEY_CLASS);
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CHotKey::~CHotKey(void)
{
}

/**********************************************************************//**
 *
 * EBhE̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	dwStyle			= EBhEX^C
 * @param [in]	lpszWindowName	= EBhE̖O
 * @param [in]	rRect			= RECT\̂̎Q
 * @param [in]	hWndParent		= ẽEBhEnh
 * @param [in]	nID				= j[ID
 * @param [in]	hInstance		= CX^Xnh
 * @param [in]	pParam			= p[^
 * @return	EBhEnh
*//***********************************************************************/
HWND CHotKey::Create( DWORD dwStyle
					, LPCTSTR lpszWindowName
					, const RECT &rRect
					, HWND hWndParent, int nID
					, HINSTANCE hInstance
					, void *pParam)
{
	// EBhE̍쐬
	return CWindow::Create(HOTKEY_CLASS
		, lpszWindowName
		, dwStyle
		, rRect
		, hWndParent
		, nID
		, hInstance
		, pParam );
}
/**********************************************************************//**
 *
 * EBhE̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	dwStyle			= EBhEX^C
 * @param [in]	lpszWindowName	= EBhE̖O
 * @param [in]	x,y,w,h			= EBhË
 * @param [in]	hWndParent		= ẽEBhEnh
 * @param [in]	nID				= j[ID
 * @param [in]	hInstance		= CX^Xnh
 * @param [in]	pParam			= p[^
 * @return	EBhEnh
*//***********************************************************************/
HWND CHotKey::Create( DWORD dwStyle
					, LPCTSTR lpszWindowName
					, int x, int y, int w, int h
					, HWND hWndParent, int nID
					, HINSTANCE hInstance
					, void *pParam)
{
	// EBhE̍쐬
	return CreateWindow(HOTKEY_CLASS
		, lpszWindowName
		, dwStyle
		, x, y, w, h
		, hWndParent
		, (HMENU)(UINT_PTR)nID
		, hInstance
		, pParam );
}

/**********************************************************************//**
 *
 * EBhE̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	dwExStyle		= gEBhEX^C
 * @param [in]	dwStyle			= EBhEX^C
 * @param [in]	lpszWindowName	= EBhE̖O
 * @param [in]	rRect			= RECT\̂̎Q
 * @param [in]	hWndParent		= ẽEBhEnh
 * @param [in]	nID				= j[ID
 * @param [in]	hInstance		= CX^Xnh
 * @param [in]	pParam			= p[^
 * @return	EBhEnh
*//***********************************************************************/
HWND CHotKey::CreateEx( DWORD dwExStyle
					, DWORD dwStyle
					, LPCTSTR lpszWindowName
					, const RECT &rRect
					, HWND hWndParent, int nID
					, HINSTANCE hInstance
					, void* pParam )
{
	return CWindow::CreateEx(dwExStyle
		, HOTKEY_CLASS
		, lpszWindowName
		, dwStyle
		, rRect
		, hWndParent
		, nID
		, hInstance
		, pParam );
}
/**********************************************************************//**
 *
 * EBhE̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	dwExStyle		= gEBhEX^C
 * @param [in]	dwStyle			= EBhEX^C
 * @param [in]	lpszWindowName	= EBhE̖O
 * @param [in]	x,y,w,h			= EBhË
 * @param [in]	hWndParent		= ẽEBhEnh
 * @param [in]	nID				= j[ID
 * @param [in]	hInstance		= CX^Xnh
 * @param [in]	pParam			= p[^
 * @return	EBhEnh
*//***********************************************************************/
HWND CHotKey::CreateEx( DWORD dwExStyle
					, DWORD dwStyle
					, LPCTSTR lpszWindowName
					, int x, int y, int w, int h
					, HWND hWndParent, int nID
					, HINSTANCE hInstance
					, void* pParam )
{
	return CreateWindowEx(dwExStyle
		, HOTKEY_CLASS
		, lpszWindowName
		, dwStyle
		, x, y, w, h
		, hWndParent
		, (HMENU)(UINT_PTR)nID
		, hInstance
		, pParam );
}

//**********************************************************************
//
// EBhEvV[W
//
//**********************************************************************
LRESULT CHotKey::WndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	return PreWndProc(hWnd, uMsg, wParam, lParam);
}

/**********************************************************************//*
 * @name	bp[֐
 * @{
*//***********************************************************************/
WORD	CHotKey::GetHotKey(void* mod, void* key)	const	{ return HKM_GetHotKey(m_hWnd,mod,key); }
WORD	CHotKey::GetHotKey(void)					const	{ return HKM_GetHotKey(m_hWnd); }
void	CHotKey::SetHotKey(BYTE key, BYTE mod)		{ HKM_SetHotKey(m_hWnd,key,mod); }
void	CHotKey::SetHotKey(WPARAM wParam )			{ HKM_SetHotKey(m_hWnd,wParam); }
void	CHotKey::SetRules(WORD HkComb, WORD HkMod)	{ HKM_SetRules(m_hWnd,HkComb,HkMod); }
/**********************************************************************//*
 * @}
*//***********************************************************************/


}	// end of namespace wx
}	// end of namespace iris
