//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXFloatSpin.cpp
 * @brief		XsRg[t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXFloatSpin_CPP_

//======================================================================
// include
#include "WXFloatSpin.h"
#include "iris_tchar.h"

#include "../../debug/WXDebugLeakCheckMacro.h"

namespace iris {
namespace wx
{

//======================================================================
// class

// CFSpin
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CFSpin::CFSpin(void)
: m_fPos(0.0f)
, m_fDelta(1.0f)
, m_fMin(0.0f)
, m_fMax(100.0f)
, m_Digit(-1)
{
}

/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= EBhEnh
*//***********************************************************************/
CFSpin::CFSpin(HWND hWnd)
: CSpin(hWnd)
, m_fPos(0.0f)
, m_fDelta(1.0f)
, m_fMin(0.0f)
, m_fMax(100.0f)
, m_Digit(-1)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CFSpin::~CFSpin(void)
{
}

/**********************************************************************//**
 *
 * EBhEvV[W
 *
*//***********************************************************************/
LRESULT CFSpin::WndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uMsg)
	{
	case UDM_SETACCEL:
	case UDM_GETACCEL:
		break;

#ifdef UDM_SETRANGE32
	case UDM_GETRANGE32:
		if( wParam ) *(int*)wParam = (IrisFInt)m_fMin;
		if( lParam ) *(int*)lParam = (IrisFInt)m_fMax;
		break;
#endif
	case UDM_GETRANGE:
		{
			short min = (short)m_fMin;
			short max = (short)m_fMax;
			return MAKELRESULT(max,min);
		}
		break;

#ifdef UDM_SETRANGE32
	case UDM_SETRANGE32:
		m_fMin = ((IrisFInt)(s32)wParam).fv;
		m_fMax = ((IrisFInt)(s32)lParam).fv;
		return 0;
#endif
	case UDM_SETRANGE:
		m_fMin = (float)HIWORD(lParam);
		m_fMax = (float)LOWORD(lParam);
		return 0;

#ifdef UDM_SETPOS32
	case UDM_SETPOS32:
#endif
	case UDM_SETPOS:
		m_fPos = ((IrisFInt)(s32)lParam).fv;
		SetText();
		return 0;

#ifdef UDM_GETPOS32
	case UDM_GETPOS32:
#endif
	case UDM_GETPOS:
		GetText();
		if( wParam != 0 ) 
		{
			float* pPos = (float*)wParam;
			*pPos = m_fPos;
		}
		return (LRESULT)(u32)(IrisFInt)m_fPos;

	case WM_VSCROLL:
		SetText();
		return 0;
	case WM_DESTROY:
		CWindow::Detach();
		break;
	}
	return PreWndProc(hWnd, uMsg, wParam, lParam);
}

//**********************************************************************
//
// EBhEvV[W
//
//**********************************************************************
LRESULT CFSpin::RecvParentMessage(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch( uMsg )
	{
	case WM_NOTIFY:
		{
			LPNMHDR lp = (LPNMHDR)lParam;
			switch(lp->code)
			{
			case UDN_DELTAPOS:
				{
					LPNMUPDOWN lpnmud = (LPNMUPDOWN)lp;
					GetText();
					m_fPos -= lpnmud->iDelta*m_fDelta;
					if( m_fPos < m_fMin ) m_fPos = m_fMin;
					if( m_fPos > m_fMax ) m_fPos = m_fMax;
				}
				return 0;
			}
		}
		break;
	}
	return CSubClass::RecvParentMessage(hWnd,uMsg,wParam,lParam);
}

/**********************************************************************//**
 *
 * BODYɃeLXgݒ
 *
*//***********************************************************************/
void CFSpin::SetText(void)
{
#if defined(UNICODE)
	CHAR str[256];
	_gcvt_s( str, 256, m_fPos, m_Digit );
	WCHAR wstr[256];
	size_t ret=0;
	mbstowcs_s(&ret, wstr, 256, str, 256);
	::SetWindowTextW((HWND)SendMessage(UDM_GETBUDDY, 0, 0), wstr);
#else
	CHAR str[256];
	_gcvt_s( str, 256, m_fPos, m_Digit );
	::SetWindowTextA((HWND)SendMessage(UDM_GETBUDDY, 0, 0), str);
#endif
}

/**********************************************************************//**
 *
 * BODY琔l擾
 *
*//***********************************************************************/
void CFSpin::GetText(void)
{
	HWND hBuddy = (HWND)SendMessage(UDM_GETBUDDY,0,0);
	if( hBuddy )
	{
		int len = (int)::GetWindowTextLength(hBuddy) + 1;
		LPTSTR temp = new TCHAR [len];
		::GetWindowText(hBuddy,temp,len);
		LPTSTR end = nullptr;
		m_fPos = (float)_tcstod(temp, &end);
		delete [] temp;
	}
}

/**********************************************************************//*
 * @name	bp[֐
 * @{
*//***********************************************************************/
float	CFSpin::SetFPos(float pos)					{ return (IrisFInt)(SetPos((IrisFInt)pos)); }
float	CFSpin::GetFPos(void)						const	{ return (IrisFInt)(GetPos()); }
void	CFSpin::SetFRange(float fmin, float fmax)	{ if( SetRange32((IrisFInt)fmin,(IrisFInt)fmax) == 0 ) { m_fMin = fmin; m_fMax = fmax; } }
void	CFSpin::GetFRange(float &fmin, float &fmax)	const	{ int min,max; if( GetRange32(min,max) ) { fmin = (IrisFInt)min; fmax = (IrisFInt)max; } else { fmin = m_fMin; fmax = m_fMax; } }
/**********************************************************************//*
 * @}
*//***********************************************************************/

}	// end of namespace wx
}	// end of namespace iris
