//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXComboBox.h
 * @brief		R{{bNXRg[t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXComboBox_H_
#define INCG_IRIS_WXComboBox_H_

//======================================================================
// include
#include "../../app/WXSubClass.h"
#include <windowsx.h>

namespace iris {
namespace wx
{

//======================================================================
// declare 
class CComboBox;

//======================================================================
// function
// windowsx.hɒ`Ă̂̓Rg
// ڂ̒ǉ
//int		ComboBox_AddString(HWND hWnd, LPCTSTR pString);
// ڂ̍폜
//int		ComboBox_DeleteString(HWND hWnd, int nIndex);
// ڂ̑S폜
void		ComboBox_DeleteStringAll(HWND hWnd);
// t@Cڂ̎擾
//int		ComboBox_Dir(HWND hWnd, int DDL, LPCTSTR path);
// ̌iOvj
//int		ComboBox_FindString(HWND hWnd, int nIndex, LPCTSTR pString);
// ̌iSvj
//int		ComboBox_FindStringExact(HWND hWnd, int nIndex, LPCTSTR pString);
// ڐ̎擾
//int		ComboBox_GetCount(HWND hWnd);
// I𒆂̃CfbNX̎擾
//int		ComboBox_GetCurSel(HWND hWnd);
// hbv_EXg{bNX̃XN[W̎擾
//BOOL	ComboBox_GetDroppedControlRect(HWND hWnd, LPRECT lprc);
// Xg̕\Ԃ̎擾
//BOOL	ComboBox_GetDroppedState(HWND hWnd);
// Xg̍ŏ̎擾
int		ComboBox_GetDroppedWidth(HWND hWnd);
// GfBbg̑I͈͂̎擾
DWORD	ComboBox_GetEditSelEx(HWND hWnd, int* pStartPos, int* pEndPos);
// ftHgъg[U[C^tFCX̎擾
//BOOL	ComboBox_GetExtendedUI(HWND hWnd);
// XN[\̎擾
int		ComboBox_GetHorizontalExtent(HWND hWnd);
// ACeɊ֘Atꂽl̎擾
//LRESULT	ComboBox_GetItemData(HWND hWnd, int nIndex);
// ڂ̍̎擾
//int		ComboBox_GetItemHeight(HWND hWnd, int nIndex);
// [P̎擾
LCID	ComboBox_GetLocale(HWND hWnd);
// Xg̍ڂ̕擾
//int		ComboBox_GetLBText(HWND hWnd, int nIndex, LPCTSTR lpBuf);
// Xg̍ڂ̕񒷂̎擾
//int		ComboBox_GetLBTextLen(HWND hWnd, int nIndex);
// 擪̃CfbNX擾
int		ComboBox_GetTopIndex(HWND hWnd);
// ̊蓖
LRESULT	ComboBox_InitStorage(HWND hWnd, int nItems, UINT nBytes);
// Xg̎wʒuɍڂǉ
//int		ComboBox_InsertString(HWND hWnd, int nIndex, LPCTSTR pString);
// GfBbg͍̓ő啶w
//int		ComboBox_LimitText(HWND hWnd, int nLenMax);
// Xg̍ڂ̑S폜
////int		ComboBox_ResetContent(HWND hWnd);
// w蕶ɑOv鍀ڂI
//int		ComboBox_SelectString(HWND hWnd, int nIndex, LPCTSTR pString);
// ڂI
//int		ComboBox_SetCurSel(HWND hWnd, int nIndex);
// Xg̍ő啝w
int		ComboBox_SetDroppedWidth(HWND hWnd, int pixelWidth);
// GfBbg̎wʒuI
//BOOL	ComboBox_SetEditSel(HWND hWnd, WORD Start, WORD End);
// ftHgъg[U[C^tFCX̑I
//BOOL	ComboBox_SetExtendedUI(HWND hWnd, BOOL bExtend);
// XN[\̎w
BOOL	ComboBox_SetHorizonTalextent(HWND hWnd, int pixelWidth);
// lACeɊ֘At
//BOOL	ComboBox_SetItemData(HWND hWnd, int nIndex, LPARAM Data);
// ڂ̍̎w
//BOOL	ComboBox_SetItemHeight(HWND hWnd, int nIndex, int pixelHeight);
// [P̐ݒ
LCID	ComboBox_SetLocale(HWND hWnd, WORD Country, WORD Lang);
LCID	ComboBox_SetLocale(HWND hWnd, LCID Locale);
// 擪̃CfbNXw
BOOL	ComboBox_SetTopIndex(HWND hWnd, int nIndex);
// Xg\E\
void	ComboBox_ShowDropDown(HWND hWnd, BOOL bShow);

//======================================================================
// class
//! R{{bNXRg[
class CComboBox : public CSubClass
{
public:
	// RXgN^
	CComboBox(void);
	CComboBox(HWND hWnd);
	// fXgN^
	~CComboBox(void);
public:
    // EBhE̍쐬
    virtual HWND Create(DWORD dwStyle
					, LPCTSTR lpszWindowName
					, const RECT &rRect
					, HWND hWndParent, int nID
					, HINSTANCE hInstance
					, void* pParam=nullptr );
    virtual HWND Create(DWORD dwStyle
					, LPCTSTR lpszWindowName
					, int x, int y, int w, int h
					, HWND hWndParent, int nID
					, HINSTANCE hInstance
					, void *pParam = nullptr );

    // EBhE̍쐬
    virtual HWND CreateEx(DWORD dwExStyle
					, DWORD dwStyle
					, LPCTSTR lpszWindowName
					, const RECT &rRect
					, HWND hWndParent, int nID
					, HINSTANCE hInstance
					, void* pParam=nullptr );
    virtual HWND CreateEx(DWORD dwExStyle
					, DWORD dwStyle
					, LPCTSTR lpszWindowName
					, int x, int y, int w, int h
					, HWND hWndParent, int nID
					, HINSTANCE hInstance
					, void *pParam = nullptr );
protected:
    // EBhEvV[W
	virtual LRESULT WndProc( HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam );
public:
	// wrap
	// ڂ̒ǉ
	int		AddString(LPCTSTR pString);
	// ڂ̍폜
	int		DeleteString(int nIndex);
	// ڂ̑S폜
	void	DeleteStringAll(void);
	// t@Cڂ̎擾
	LRESULT	Dir(int DDL, LPCTSTR path);
	// ̌iOvj
	int		FindString(int nIndex, LPCTSTR pString);
	// ̌iSvj
	int		FindStringExact(int nIndex, LPCTSTR pString);
	// ڐ̎擾
	int		GetCount(void);
	// I𒆂̃CfbNX̎擾
	int		GetCurSel(void);
	// hbv_EXg{bNX̃XN[W̎擾
	void	GetDroppedControlRect(LPRECT lprc);
	// Xg̕\Ԃ̎擾
	BOOL	GetDroppedState(void);
	// Xg̍ŏ̎擾
	int		GetDroppedWidth(void);
	// GfBbg̑I͈͂̎擾
	DWORD	GetEditSel(void);
	DWORD	GetEditSel(int* pStartPos, int* pEndPos);
	// ftHgъg[U[C^tFCX̎擾
	UINT	GetExtendedUI(void);
	// XN[\̎擾
	int		GetHorizontalExtent(void);
	// ACeɊ֘Atꂽl̎擾
	LRESULT	GetItemData(int nIndex);
	// ڂ̍̎擾
	int		GetItemHeight(void);
	// Xg̍ڂ̕擾
	int		GetLBText(int nIndex, LPCTSTR lpBuf);
	// Xg̍ڂ̕񒷂̎擾
	int		GetLBTextLen(int nIndex);
	// [P̎擾
	LCID	GetLocale(void);
	// 擪̃CfbNX擾
	int		GetTopIndex(void);
	// ̊蓖
	LRESULT	InitStorage(int nItems, UINT nBytes);
	// Xg̎wʒuɍڂǉ
	int		InsertString(int nIndex, LPCTSTR pString);
	// GfBbg͍̓ő啶w
	void	LimitText(int nLenMax);
	// Xg̍ڂ̑S폜
	void	ResetContent(void);
	// w蕶ɑOv鍀ڂI
	int		SelectString(int nIndex, LPCTSTR pString);
	// ڂI
	int		SetCurSel(int nIndex);
	// Xg̍ő啝w
	int		SetDroppedWidth(int pixelWidth);
	// GfBbg̎wʒuI
	BOOL	SetEditSel(WORD Start, WORD End);
	// ftHgъg[U[C^tFCX̑I
	BOOL	SetExtendedUI(BOOL bExtend);
	// XN[\̎w
	BOOL	SetHorizonTalextent(int pixelWidth);
	// lACeɊ֘At
	BOOL	SetItemData(int nIndex, LPARAM Data);
	// ڂ̍̎w
	BOOL	SetItemHeight(int nIndex, int pixelHeight);
	// [P̐ݒ
	LCID	SetLocale(WORD Country, WORD Lang);
	LCID	SetLocale(LCID Locale);
	// 擪̃CfbNXw
	BOOL	SetTopIndex(int nIndex);
	// Xg\E\
	void	ShowDropDown(BOOL bShow);
};

}	// end of namespace wx
}	// end of namespace iris

#endif	// _WXComboBox_H_
