//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXConsole.h
 * @brief		R\[NX
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXConsole_H_
#define INCG_IRIS_WXConsole_H_

//======================================================================
// include
#include "fnd/utility/FndRefCounter.h"
#include "../base/WXHandle.h"
#include "iris_xchar.hpp"
#include <map>

#if	defined(IRIS_WIN32_WCE)
#error not support.
#endif

namespace iris {
namespace wx 
{

//======================================================================
// typedef
#if	IRIS_MSC_AT_LESS(_MSC_VER_VC8)
typedef LPVOID	PCONSOLE_READCONSOLE_CONTROL;
#endif

//======================================================================
// function
// R\[EBhẼEBhEnh擾
HWND	GetConsoleWindow(void);

//======================================================================
// class
//! R\[nhNX
class CConsoleHandle : public CHandle
{
public:
	// RXgN^
	CConsoleHandle(void);
	// RXgN^
	CConsoleHandle(HANDLE hObject);
	
public:
	// XN[obt@̎擾
	BOOL	GetScreenBufferInfo(PCONSOLE_SCREEN_BUFFER_INFO pcsbi);
	BOOL	GetScreenBufferInfoEx(PCONSOLE_SCREEN_BUFFER_INFOEX pcsbi);
	// XN[obt@̐ݒ
	BOOL	SetScreenBufferInfoEx(PCONSOLE_SCREEN_BUFFER_INFOEX pcsbi);
	// XN[obt@TCY̎擾
	COORD	GetScreenBufferSize(void);
	// XN[obt@TCY̎w
	BOOL	SetScreenBufferSize(COORD dwSize);

	BOOL	SetTextAttribute(WORD wAttributes);
	WORD	GetTextAttribute(void);

public:
	BOOL	ReadConsoleA(LPVOID lpBuf, DWORD dwRead, LPDWORD lpRead, PCONSOLE_READCONSOLE_CONTROL lpInputControl=nullptr);
	BOOL	ReadConsoleW(LPVOID lpBuf, DWORD dwRead, LPDWORD lpRead, PCONSOLE_READCONSOLE_CONTROL lpInputControl=nullptr);

	BOOL	ReadConsoleInputA(PINPUT_RECORD lpBuf, DWORD dwLength, LPDWORD lpRead);
	BOOL	ReadConsoleInputW(PINPUT_RECORD lpBuf, DWORD dwLength, LPDWORD lpRead);

	BOOL	ReadConsoleOutputA(PCHAR_INFO lpBuf, COORD dwSize, COORD dwCoord, PSMALL_RECT lpRegion);
	BOOL	ReadConsoleOutputW(PCHAR_INFO lpBuf, COORD dwSize, COORD dwCoord, PSMALL_RECT lpRegion);

	template<typename TN>
	BOOL	Write(const TN* lpBuf, DWORD dwWrite, LPDWORD lpWritten, LPVOID lpReserved=nullptr);
	template<typename TN>
	BOOL	Write(const TN* lpBuf)
	{
		DWORD written;
		return Write(lpBuf, xcslen(lpBuf), &written);
	}
	template<typename TN>
	BOOL	WriteLine(const TN* lpBuf, DWORD dwWrite, LPDWORD lpWritten, LPVOID lpReserved=nullptr)
	{
		BOOL ret = Write(lpBuf, dwWrite, lpWritten, lpReserved);
		return ret & Write(IRIS_XTEXT(TN, "\n"));
	}
	template<typename TN>
	BOOL	WriteLine(const TN* lpBuf)
	{
		DWORD written;
		return WriteLine(lpBuf, xcslen(lpBuf), &written);
	}

	BOOL	WriteConsoleInputA(const INPUT_RECORD* lpBuf, DWORD dwWrite, LPDWORD lpWritten);
	BOOL	WriteConsoleInputW(const INPUT_RECORD* lpBuf, DWORD dwWrite, LPDWORD lpWritten);

	BOOL	WriteConsoleOutputA(const CHAR_INFO* lpBuf, COORD dwSize, COORD dwCoord, PSMALL_RECT lpRegion);
	BOOL	WriteConsoleOutputW(const CHAR_INFO* lpBuf, COORD dwSize, COORD dwCoord, PSMALL_RECT lpRegion);
};

//! R\[NX
class CConsole : protected fnd::CRefCounter
{
public:
	typedef std::map<int, HANDLE>	PAGE;
	typedef std::pair<int, HANDLE>	PAGEPAIR;
	enum { PAGE_DEFAULT = -1, };	//!< // ftHgy[WID
private:
	CConsoleHandle	m_hConsole;
	CConsoleHandle	m_hCurrent;
	int		m_PageNo;
	FILE*	m_stdout;
	FILE*	m_stdin;
	FILE*	m_stderr;
	// y[W
	PAGE	m_Page;
	bool	m_bExist;
public:
	// RXgN^
	CConsole(void);
	// fXgN^
	virtual ~CConsole(void);
public:
	// J
	virtual bool	Open(bool std=true);
	// 
	virtual void	Close(void);
public:
	template<typename CHARTYPE_>
	void	Print(const CHARTYPE_* format, va_list va );
	// o
	template<typename CHARTYPE_>
	void	Print(const CHARTYPE_* format, ... )
	{
		va_list	va;
		va_start(va, format);
		Print(format, va);
		va_end(va);
	}

public:
	// y[Wǉ
	bool	AddPage(int page, DWORD dwAccess, DWORD dwShareMode, LPSECURITY_ATTRIBUTES lpAttributes);
	// y[W폜
	bool	DelPage(int page);
	// y[WύX
	bool	SetPage(int page=PAGE_DEFAULT);
	/// ݂̃y[Wԍ擾
	int		GetPageNo(void)	const	{ return m_PageNo; }

protected:
	// R\[̃nh擾
			CConsoleHandle&	GetConsoleHandle(void)			{ return m_hConsole; }
	const	CConsoleHandle&	GetConsoleHandle(void)	const	{ return m_hConsole; }

	// nh擾
	HANDLE	GetHandle(int page=PAGE_DEFAULT);

public:

	// set, get
	// 
			CConsoleHandle&	GetCurrentHandle(void)			{ return m_hCurrent; }
	const	CConsoleHandle&	GetCurrentHandle(void)	const	{ return m_hCurrent; }
    // nh̎擾
	HANDLE	operator()(void)		{ return GetCurrentHandle(); }

public:

	// EBhEnh̎擾
	HWND	GetHWND(void);
	// eEBhEnh̐ݒ
	HWND	SetParent(HWND hWndNewParent);

public:
	// wrap
	DWORD	GetConsoleTitleA(LPSTR  lpTitle, DWORD dwSize)	const;
	DWORD	GetConsoleTitleW(LPWSTR lpTitle, DWORD dwSize)	const;

	BOOL	SetConsoleTitleA(LPCSTR  lpTitle);
	BOOL	SetConsoleTitleW(LPCWSTR lpTitle);

	BOOL	FlushInputBuffer(void);
	BOOL	GetNumberOfInputEvents(LPDWORD lpNumberOfEvents);
	BOOL	SetCtrlHandler(PHANDLER_ROUTINE Handler, BOOL Add);
	BOOL	AddCtrlHandler(PHANDLER_ROUTINE Handler);
	BOOL	DelCtrlHandler(PHANDLER_ROUTINE Handler);

	UINT	GetCP(void)	const;
	BOOL	SetCP(UINT CodePageID);

	BOOL	ReadConsoleA(LPVOID lpBuf, DWORD dwRead, LPDWORD lpRead, PCONSOLE_READCONSOLE_CONTROL lpInputControl=nullptr);
	BOOL	ReadConsoleW(LPVOID lpBuf, DWORD dwRead, LPDWORD lpRead, PCONSOLE_READCONSOLE_CONTROL lpInputControl=nullptr);

	BOOL	ReadConsoleInputA(PINPUT_RECORD lpBuf, DWORD dwLength, LPDWORD lpRead);
	BOOL	ReadConsoleInputW(PINPUT_RECORD lpBuf, DWORD dwLength, LPDWORD lpRead);

	BOOL	ReadConsoleOutputA(PCHAR_INFO lpBuf, COORD dwSize, COORD dwCoord, PSMALL_RECT lpRegion);
	BOOL	ReadConsoleOutputW(PCHAR_INFO lpBuf, COORD dwSize, COORD dwCoord, PSMALL_RECT lpRegion);

	template<typename TN>
	BOOL	Write(const TN* lpBuf, DWORD dwWrite, LPDWORD lpWritten, LPVOID lpReserved=nullptr)
	{
		return m_hCurrent.Write(lpBuf, dwWrite, lpWritten, lpReserved);
	}
	template<typename TN>
	BOOL	Write(const TN* lpBuf)
	{
		return m_hCurrent.Write(lpBuf);
	}
	template<typename TN>
	BOOL	WriteLine(const TN* lpBuf, DWORD dwWrite, LPDWORD lpWritten, LPVOID lpReserved=nullptr)
	{
		return m_hCurrent.WriteLine(lpBuf, dwWrite, lpWritten, lpReserved);
	}
	template<typename TN>
	BOOL	WriteLine(const TN* lpBuf)
	{
		return m_hCurrent.WriteLine(lpBuf);
	}

	BOOL	WriteConsoleInputA(const INPUT_RECORD* lpBuf, DWORD dwWrite, LPDWORD lpWritten);
	BOOL	WriteConsoleInputW(const INPUT_RECORD* lpBuf, DWORD dwWrite, LPDWORD lpWritten);

	BOOL	WriteConsoleOutputA(const CHAR_INFO* lpBuf, COORD dwSize, COORD dwCoord, PSMALL_RECT lpRegion);
	BOOL	WriteConsoleOutputW(const CHAR_INFO* lpBuf, COORD dwSize, COORD dwCoord, PSMALL_RECT lpRegion);
};

}	// end of namespace wx
}	// end of namespace iris

#endif
