//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXScreneSaver.cpp
 * @brief		XN[Z[o[vO~Ox[X
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXScreneSaver_CPP_

#ifdef _IRIS_WX_SCRENESAVER

//======================================================================
// include
#include "WXScreneSaver.h"
#include <scrnsave.h>
#include "../wx_inchead.h"

//======================================================================
// link
#pragma comment ( lib, "scrnsave.lib" )

namespace iris {
namespace wx
{

//======================================================================
// static
// 
static IScreneSaver* s_pScrenSaver = nullptr;

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
IScreneSaver::IScreneSaver(void)
{
	WX_SAFE_DELETE( s_pScrenSaver );
	s_pScrenSaver = this;
	Attach(hMainWindow);
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
IScreneSaver::~IScreneSaver(void)
{
	s_pScrenSaver = nullptr;
}

/**********************************************************************//**
 *
 * XN[Z[o[EBhEvV[W
 *		DefScreenSaverProccall
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= EBhEnh
 * @param [in]	uMsg	= bZ[W
 * @param [in]	wParam	= WPARAM
 * @param [in]	lParam	= LPARAM
 * @return	LRESULTl
*//***********************************************************************/
LRESULT IScreneSaver::WndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	return DefScreenSaverProc(hWnd, uMsg, wParam, lParam);
}

}	// end of namespace wx
}	// end of namespace iris

//======================================================
// function
using namespace iris::wx;

/**********************************************************************//**
 *
 * XN[Z[o[EBhEvV[W
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= EBhEnh
 * @param [in]	uMsg	= bZ[W
 * @param [in]	wParam	= WPARAM
 * @param [in]	lParam	= LPARAM
 * @return	LRESULTl
*//***********************************************************************/
LRESULT WINAPI ScreenSaverProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch( uMsg )
	{
	case WM_NCCREATE:
		// entry
		WXScreneSaverMain();
		// attach
		if( s_pScrenSaver )
			s_pScrenSaver->Attach(hWnd);
		break;
	case WM_NCDESTROY:
		// destroy
		WX_SAFE_DELETE( s_pScrenSaver );
		break;
	}
	if( s_pScrenSaver == nullptr ) return DefScreenSaverProc(hWnd, uMsg, wParam, lParam);
	return s_pScrenSaver->WndProc(hWnd, uMsg, wParam, lParam);
}

/**********************************************************************//**
 *
 * \_CAOvV[W
 *
 ----------------------------------------------------------------------
 * @param [in]	hDlg	= _CAOnh
 * @param [in]	uMsg	= bZ[W
 * @param [in]	wParam	= WPARAM
 * @param [in]	lParam	= LPARAM
 * @return	
*//***********************************************************************/
BOOL WINAPI ScreenSaverConfigureDialog(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	if( s_pScrenSaver == nullptr ) return 0;
	return s_pScrenSaver->ConfigureDialog(hDlg, uMsg, wParam, lParam);
}

/**********************************************************************//**
 *
 * 	
 *
 ----------------------------------------------------------------------
 * @param [in]	hInst	= CX^Xnh
 * @return	
*//***********************************************************************/
BOOL WINAPI RegisterDialogClasses(HANDLE hInst)
{
	if( s_pScrenSaver == nullptr ) return 0;
	return s_pScrenSaver->RegisterDialogClasses(hInst);
}

#endif
