//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXSHBrowseFolder.h
 * @brief		WXSHBrowseFolder t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXSHBrowseFolder_H_
#define INCG_IRIS_WXSHBrowseFolder_H_

//======================================================================
// include
#include "iris_object.h"
#include "c++0x/cpp0x_type_traits.hpp"
#include "../shlobj_inchead.h"

namespace iris {
namespace wx
{

//======================================================================
// declare
template<typename CHARTYPE_>class CTSHBrowseFolder;

//======================================================================
// typedef
typedef CTSHBrowseFolder<CHAR>	CSHBrowseFolderA;
typedef CTSHBrowseFolder<WCHAR>	CSHBrowseFolderW;
typedef CTSHBrowseFolder<TCHAR>	CSHBrowseFolder;

//======================================================================
// class
/**
 * @brief	tH_I_CAONX
*/
template<typename CHARTYPE_>
class CTSHBrowseFolder : public IIrisObject
{
private:
	typedef CHARTYPE_			_Mychar;
	typedef CHARTYPE_			*_Mylpstr;
	typedef const CHARTYPE_		*_Mylpcstr;
	typedef CTSHBrowseFolder<CHARTYPE_>	_Myt;
public:
#if	!defined(IRIS_WIN32_WCE)
	typedef typename iml::type_select< (cpp0x::is_same<_Mychar, WCHAR>::value), BROWSEINFOW, BROWSEINFOA >::type XBROWSEINFO;
#else
	typedef BROWSEINFO		XBROWSEINFO;
#endif
	typedef XBROWSEINFO		*LPXBROWSEINFO;

public:
	// J
	static	BOOL	Show(HWND hWnd, const CHARTYPE_* lpszTitle, const CHARTYPE_* lpszDefault, CHARTYPE_* lpszFolderName, DWORD Flags);

	// 
	static LPITEMIDLIST		Browse(LPXBROWSEINFO bi);
};

}	// end of namespace wx
}	// end of namespace iris

#endif
