//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXNotifyIcon.cpp
 * @brief		NotifyIconNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXNotifyIcon_CPP_

//======================================================================
// include
#include "WXNotifyIcon.h"
#include "iris_xchar.hpp"
#include <tchar.h>

//======================================================================
// link
#if defined(IRIS_MSC)
#  if	defined(IRIS_WIN32_WCE)
#    pragma comment( lib, "ceshell.lib" )
#  else
#    pragma comment( lib, "shlwapi.lib" )
#  endif
#endif


namespace iris {
namespace wx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
template<typename CHARTYPE_>
CTNotifyIcon<CHARTYPE_>::CTNotifyIcon(void)
{
	m_Data.cbSize = sizeof(m_Data);
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
template<typename CHARTYPE_>
CTNotifyIcon<CHARTYPE_>::~CTNotifyIcon(void)
{
}

/**********************************************************************//**
 *
 * ǉ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd			= 
 * @param [in]	uID				= 
 * @param [in]	uFlags			= tO(NIF_***)
 * @param [in]	hIcon			= 
 * @param [in]	uCallbackMsg	= 
 * @param [in]	lpszTip			= 
 * @return	
*//***********************************************************************/
template<typename CHARTYPE_>
BOOL CTNotifyIcon<CHARTYPE_>::Add(HWND hWnd, UINT uID, UINT uFlags, UINT uCallbackMsg, HICON hIcon, _Mylpcstr lpszTip)
{
	m_Data.hWnd		= hWnd;
	m_Data.uID		= uID;
	m_Data.uFlags	= uFlags;
	m_Data.uCallbackMessage	= uCallbackMsg;
	m_Data.hIcon	= hIcon;
	if( lpszTip != nullptr )
		xcstoxcs_s( m_Data.szTip, elementof(m_Data.szTip), lpszTip );
	else
		memset( m_Data.szTip, 0, sizeof(m_Data.szTip) );

	return NotifyIcon(NIM_ADD, &m_Data);
}

/**********************************************************************//**
 *
 * ǉ
 *
 ----------------------------------------------------------------------
 * @param [in]	lpnid			= ݒ
 * @return	
*//***********************************************************************/
template<typename CHARTYPE_>
BOOL CTNotifyIcon<CHARTYPE_>::Add(LPXNOTIFYICONDATA lpnid)
{
	if( lpnid == nullptr ) return FALSE;
	memcpy( &m_Data, lpnid, sizeof(m_Data) );
	m_Data.cbSize = sizeof(m_Data);
	return NotifyIcon(NIM_ADD, &m_Data);
}

/**********************************************************************//**
 *
 * ǉ
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
template<typename CHARTYPE_>
BOOL CTNotifyIcon<CHARTYPE_>::Add(void)
{
	m_Data.cbSize = sizeof(m_Data);
	return NotifyIcon(NIM_ADD, &m_Data);
}

/**********************************************************************//**
 *
 * 폜
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
template<typename CHARTYPE_>
BOOL CTNotifyIcon<CHARTYPE_>::Delete(void)
{
	m_Data.cbSize = sizeof(m_Data);
	return NotifyIcon(NIM_DELETE, &m_Data);
}

/**********************************************************************//**
 *
 * ύX
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
template<typename CHARTYPE_>
BOOL CTNotifyIcon<CHARTYPE_>::Modify(void)
{
	m_Data.cbSize = sizeof(m_Data);
	return NotifyIcon(NIM_MODIFY, &m_Data);
}

/**********************************************************************//**
 *
 * tH[JX
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
template<typename CHARTYPE_>
BOOL CTNotifyIcon<CHARTYPE_>::SetFocus(void)
{
#if (_WIN32_IE >= 0x0500)
	//m_Data.cbSize = sizeof(m_Data);
	//return NotifyIcon(NIM_SETFOCUS, &m_Data);
	return FALSE;
#else
	return FALSE;
#endif
}

/**********************************************************************//**
 *
 * o[Wݒ
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
template<typename CHARTYPE_>
BOOL CTNotifyIcon<CHARTYPE_>::SetVersion(void)
{
#if (_WIN32_IE >= 0x0500)
	//m_Data.cbSize = sizeof(m_Data);
	//return NotifyIcon(NIM_SETVERSION, &m_Data);
	return FALSE;
#else
	return FALSE;
#endif
}

/**********************************************************************//**
 *
 * XgA
 *
 ----------------------------------------------------------------------
 * @param [in]	uMsg	= bZ[W
 * @return	
*//***********************************************************************/
template<typename CHARTYPE_>
BOOL CTNotifyIcon<CHARTYPE_>::Restore(UINT uMsg)
{
	if( uMsg == GetTaskbarCreatedMessage() )
	{
		return Restore();
	}
	return FALSE;
}

/**********************************************************************//**
 *
 * XgA
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
template<typename CHARTYPE_>
BOOL CTNotifyIcon<CHARTYPE_>::Restore(void)
{
	BOOL ret = Delete();
	ret |= Add();
	return ret;
}

/**********************************************************************//**
 *
 * Explorer̍ċNbZ[W̎擾
 *
 ----------------------------------------------------------------------
 * @return	bZ[W
*//***********************************************************************/
template<>
UINT CTNotifyIcon<CHAR>::GetTaskbarCreatedMessage(void) const
{
#if !defined(IRIS_WIN32_WCE)
	return RegisterWindowMessageA( "TaskbarCreated" );
#else
	return RegisterWindowMessageW( L"TaskbarCreated" );
#endif
}
template<>
UINT CTNotifyIcon<WCHAR>::GetTaskbarCreatedMessage(void) const
{
	return RegisterWindowMessageW( L"TaskbarCreated" );
}

/**********************************************************************//**
 *
 * Shell_NotifyIcon
 *
 ----------------------------------------------------------------------
 * @param [in]	dwMessage	= bZ[W
 * @param [in]	lpnid		= 
 * @return	
*//***********************************************************************/
template<>
BOOL CTNotifyIcon<CHAR>::NotifyIcon(DWORD dwMessage, LPXNOTIFYICONDATA lpnid)
{
#if	!defined(IRIS_WIN32_WCE)
	return Shell_NotifyIconA(dwMessage, lpnid);
#else
	return Shell_NotifyIcon(dwMessage, lpnid);
#endif
}
template<>
BOOL CTNotifyIcon<WCHAR>::NotifyIcon(DWORD dwMessage, LPXNOTIFYICONDATA lpnid)
{
#if	!defined(IRIS_WIN32_WCE)
	return Shell_NotifyIconW(dwMessage, lpnid);
#else
	return Shell_NotifyIcon(dwMessage, lpnid);
#endif
}

template class CTNotifyIcon<CHAR>;
template class CTNotifyIcon<WCHAR>;

}	// end of namespace wx
}	// end of namespace iris
