//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXVersionInfo.h
 * @brief		o[Wt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXVersionInfo_H_
#define INCG_IRIS_WXVersionInfo_H_

//======================================================================
// include
#include "iris_object.h"

namespace iris {
namespace wx
{

//======================================================================
// declare
template<typename CHARTYPE_>class CTVersionInfo;

//======================================================================
// typedef
typedef CTVersionInfo<CHAR>		CVersionInfoA;
typedef CTVersionInfo<WCHAR>	CVersionInfoW;
typedef CTVersionInfo<TCHAR>	CVersionInfo;

//======================================================================
// class
//! o[W擾NX
template<typename CHARTYPE_>
class CTVersionInfo : public INonCopyable<>
{
private:
	typedef CHARTYPE_			_Mychar;
	typedef CHARTYPE_			*_Mylpstr;
	typedef const CHARTYPE_		*_Mylpcstr;
	typedef CTVersionInfo<CHARTYPE_>	_Myt;
public:
	typedef enum BLOCKID
	{
		COMPANYNAME = 0,	//!< Ж
		FILEDESCRIPTION,	//!< 
		FILEVERSION,		//!< t@Co[W
		INTERNALNAME,		//!< 
		LEGALCOPYRIGHT,		//!< 쌠
		ORIGINALFILENAME,	//!< t@C
		PRODUCTNAME,		//!< i
		PRODUCTVERSION,		//!< io[W
		COMMENTS,			//!< Rg
		LEGALTRADEMARKS,	//!< W
		PRIVATEBUILD,		//!< vCx[grh
		SPECIALBUILD,		//!< XyVrh
		TERM
	} BLOCKID;
protected:
	char*	m_pVI;			//!< 擾pobt@
	PLCID	m_pLCIDs;		//!< ǂݍ񂾌Zbg
	UINT	m_LCIDListNum;	//!< LCID Xg
	LCID	m_LCID;			//!< Zbg
public:
	// RXgN^
	CTVersionInfo();
	// fXgN^
	virtual ~CTVersionInfo();
public:
	// J
	bool	Open(void);
	bool	Open(_Mylpstr filename);

	// 
	void	Close(void);

public:
	// LCIDݒ
	LCID	GetLCID(void)			const		{ return m_LCID; }
	void	SetLCID(DWORD w)					{ m_LCID = w; }
	void	LoadLCID(UINT idx=0)				{ m_LCID = GetLCID(idx); }
	LCID	GetLCID(UINT idx)		const		{ if( idx >= m_LCIDListNum ) return static_cast<LCID>(-1); return MAKELCID(HIWORD(m_pLCIDs[idx]), LOWORD(m_pLCIDs[idx])); }
	UINT	GetLCIDListNum(void)	const		{ return m_LCIDListNum; }
	// ̐ݒ
	LANGID	GetLanguage(void)	const		{ return HIWORD(m_LCID); }
	void	SetLanguage(LANGID lang)		{ m_LCID = MAKELCID(LOWORD(m_LCID), lang); }
	WORD	GetCharSet(void)	const		{ return LOWORD(m_LCID); }
	void	SetCharSet(WORD chrset)			{ m_LCID = MAKELCID(chrset, HIWORD(m_LCID)); }

public:
	// Ж
	UINT	GetCompanyName(_Mychar** dst) const;
	// 
	UINT	GetFileDescription(_Mychar** dst) const;
	// t@Co[W
	UINT	GetFileVersion(_Mychar** dst) const;
	// 
	UINT	GetInternalName(_Mychar** dst) const;
	// 쌠
	UINT	GetLegalCopyright(_Mychar** dst) const;
	// t@C
	UINT	GetOriginalFileName(_Mychar** dst) const;
	// i
	UINT	GetProductName(_Mychar** dst) const;
	// io[W
	UINT	GetProductVersion(_Mychar** dst) const;
	// Rg
	UINT	GetComments(_Mychar** dst) const;
	// W
	UINT	GetLegalTrademarks(_Mychar** dst) const;
	// vCx[grh
	UINT	GetPrivateBuild(_Mychar** dst) const;
	// XyVrh
	UINT	GetSpecialBuild(_Mychar** dst) const;

	// ID擾
	UINT	GetStringFileInfoFromID(int nID, _Mychar** dst) const;

	// o[W𐔒lɕϊ
	int		GetVersionInt(void) const;
	int		GetVersionHex(void) const;

public:
	UINT	GetQueryValue(_Mylpstr block_name, LPVOID* dst) const;
	UINT	GetStringFileInfo(_Mylpcstr block_name, LPVOID* dst) const;
};

}	// end of namespace wx
}	// end of namespace iris

#endif
