//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXEnvironmentStrings.h
 * @brief		EnvironmentStrings t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXEnvironmentStrings_H_
#define INCG_IRIS_WXEnvironmentStrings_H_

//======================================================================
// include
#include "iris_object.h"

#if !defined(IRIS_WIN32_WCE)

namespace iris {
namespace wx
{

//======================================================================
// declare
template<typename CHARTYPE_>class CTEnvironmentStrings;

//======================================================================
// typedef
typedef CTEnvironmentStrings<CHAR>		CEnvironmentStringsA;
typedef CTEnvironmentStrings<WCHAR>		CEnvironmentStringsW;
typedef CTEnvironmentStrings<TCHAR>		CEnvironmentStrings;

//======================================================================
// class
/**
 * @brief	ϐ}bvNX
*/
template<typename CHARTYPE_>
class CTEnvironmentStrings : public IIrisObject
{
	typedef CTEnvironmentStrings<CHARTYPE_>	_Myt;
protected:
	typedef	CHARTYPE_			_Mychar;
	typedef CHARTYPE_			*_Mylpstr;
	typedef const CHARTYPE_		*_Mylpcstr;

protected:
	_Mylpstr	m_lpEnvStr;	//!< ϐ̈

public:
	// RXgN^
	CTEnvironmentStrings(void);
	// fXgN^
	virtual ~CTEnvironmentStrings(void);

public:
	// ǂݍ
	BOOL		Load(void);
	// 
	BOOL		Unload(void);
public:
	operator	_Mylpstr	(void)	const	{ return m_lpEnvStr; }
};

}	// end of namespace wx
}	// end of namespace iris

#endif

#endif
