//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXEvent.cpp
 * @brief		CxgnhNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXEvent_CPP_

//======================================================================
// include
#include "WXEvent.h"

namespace iris {
namespace wx
{

//======================================================================
// class

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CEvent::CEvent(void)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CEvent::~CEvent(void)
{
}

/**********************************************************************//**
 *
 * 쐬
 *
 -----------------------------------------------------------------------
 * @param [in] lpSecurityAttribute	= ZLeBLqq
 * @param [in] bManualReset			= Zbg̃^Cv
 * @param [in] bInitialState		= ԁiTRUE : VOiԁj
 * @param [in] lpName				= O
 * @return	
*//***********************************************************************/
BOOL CEvent::Create (LPSECURITY_ATTRIBUTES lpSecurityAttribute, BOOL bManualReset, BOOL bInitialState, LPCTSTR lpName)
{
#ifdef UNICODE
	return CreateW(lpSecurityAttribute, bManualReset, bInitialState, lpName);
#else
	return CreateA(lpSecurityAttribute, bManualReset, bInitialState, lpName);
#endif
}
/// CEvent::Create Q
BOOL CEvent::CreateA(LPSECURITY_ATTRIBUTES lpSecurityAttribute, BOOL bManualReset, BOOL bInitialState, LPCSTR  lpName)
{
#if !defined(IRIS_WIN32_WCE)
	HANDLE hEvent = ::CreateEventA(lpSecurityAttribute, bManualReset, bInitialState, lpName);
	if( hEvent == nullptr ) return FALSE;
	if( !Attach(hEvent) )
	{
		CloseHandle(hEvent);
		return FALSE;
	}
	return TRUE;
#else
	return FALSE;
#endif
}
/// CEvent::Create Q
BOOL CEvent::CreateW(LPSECURITY_ATTRIBUTES lpSecurityAttribute, BOOL bManualReset, BOOL bInitialState, LPCWSTR lpName)
{
	HANDLE hEvent = ::CreateEventW(lpSecurityAttribute, bManualReset, bInitialState, lpName);
	if( hEvent == nullptr ) return FALSE;
	if( !Attach(hEvent) )
	{
		CloseHandle(hEvent);
		return FALSE;
	}
	return TRUE;
}

/**********************************************************************//**
 *
 * 쐬
 *
 -----------------------------------------------------------------------
 * @param [in] lpSecurityAttribute	= ZLeBLqq
 * @param [in] lpName				= O
 * @param [in] dwFlags				= CREATE_EVENT_***
 * @param [in] dwDesiredAccess		= ANZX
 * @return	
*//***********************************************************************/
BOOL CEvent::CreateEx (LPSECURITY_ATTRIBUTES lpSecurityAttribute, LPCTSTR lpName, DWORD dwFlags, DWORD dwDesiredAccess)
{
#ifdef UNICODE
	return CreateExW(lpSecurityAttribute, lpName, dwFlags, dwDesiredAccess);
#else
	return CreateExA(lpSecurityAttribute, lpName, dwFlags, dwDesiredAccess);
#endif
}
/// CEvent::CreateEx Q
BOOL CEvent::CreateExA(LPSECURITY_ATTRIBUTES lpSecurityAttribute, LPCSTR  lpName, DWORD dwFlags, DWORD dwDesiredAccess)
{
	// TODO : C\
#if (0) && (_WIN32_WINNT >= 0x0600)
	HANDLE hEvent = ::CreateEventExA(lpSecurityAttribute, lpName, dwFlags, dwDesiredAccess);
	if( hEvent == nullptr ) return FALSE;
	if( !Attach(hEvent) )
	{
		CloseHandle(hEvent);
		return FALSE;
	}
	return TRUE;
#else
	IRIS_UNUSED_VARIABLE(dwDesiredAccess);
	return CreateA(lpSecurityAttribute, IRIS_TO_BOOL(dwFlags & CREATE_EVENT_MANUAL_RESET), IRIS_TO_BOOL(dwFlags & CREATE_EVENT_INITIAL_SET), lpName);
#endif
}
/// CEvent::CreateEx Q
BOOL CEvent::CreateExW(LPSECURITY_ATTRIBUTES lpSecurityAttribute, LPCWSTR lpName, DWORD dwFlags, DWORD dwDesiredAccess)
{
	// TODO : C\
#if (0) && (_WIN32_WINNT >= 0x0600)
	HANDLE hEvent = ::CreateEventExW(lpSecurityAttribute, lpName, dwFlags, dwDesiredAccess);
	if( hEvent == nullptr ) return FALSE;
	if( !Attach(hEvent) )
	{
		CloseHandle(hEvent);
		return FALSE;
	}
	return TRUE;
#else
	IRIS_UNUSED_VARIABLE(dwDesiredAccess);
	return CreateW(lpSecurityAttribute, IRIS_TO_BOOL(dwFlags & CREATE_EVENT_MANUAL_RESET), IRIS_TO_BOOL(dwFlags & CREATE_EVENT_INITIAL_SET), lpName);
#endif
}

/**********************************************************************//**
 *
 * ̖OtmutexJ
 *
 -----------------------------------------------------------------------
 * @param [in] dwDesiredAccess	= ANZX
 * @param [in] bInheritHandle	= pIvV
 * @param [in] lpName			= mutex
 * @return	
*//***********************************************************************/
BOOL CEvent::Open (DWORD dwDesiredAccess, BOOL bInheritHandle, LPCTSTR lpName)
{
#ifdef UNICODE
	return OpenW(dwDesiredAccess, bInheritHandle, lpName);
#else
	return OpenA(dwDesiredAccess, bInheritHandle, lpName);
#endif
}
/// CMutex::Open Q
BOOL CEvent::OpenA(DWORD dwDesiredAccess, BOOL bInheritHandle, LPCSTR  lpName)
{
#if !defined(IRIS_WIN32_WCE)
	HANDLE hEvent = ::OpenEventA(dwDesiredAccess, bInheritHandle, lpName);
	if( hEvent == nullptr ) return FALSE;
	if( !Attach(hEvent) )
	{
		CloseHandle(hEvent);
		return FALSE;
	}
	return TRUE;
#else
	return FALSE;
#endif
}
/// CMutex::Open Q
BOOL CEvent::OpenW(DWORD dwDesiredAccess, BOOL bInheritHandle, LPCWSTR lpName)
{
	HANDLE hEvent = ::OpenEventW(dwDesiredAccess, bInheritHandle, lpName);
	if( hEvent == nullptr ) return FALSE;
	if( !Attach(hEvent) )
	{
		CloseHandle(hEvent);
		return FALSE;
	}
	return TRUE;
}

/**********************************************************************//**
 *
 * CxgVOiԂɂ
 *
 -----------------------------------------------------------------------
 * @param [in] bSignal	= VOi
 * @return	
*//***********************************************************************/
BOOL CEvent::Signal(BOOL bSignal)
{
	if( bSignal ) return SetSignal();
	return ResetSignal();
}

/**********************************************************************//**
 *
 * CxgVOiԂɂ
 *
 -----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CEvent::SetSignal(void)
{
	return ::SetEvent(m_hObject);
}

/**********************************************************************//**
 *
 * CxgVOiԂɂ
 *
 -----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CEvent::ResetSignal(void)
{
	return ::ResetEvent(m_hObject);
}

/**********************************************************************//**
 *
 * VOiԂɐݒ肵Aҋ@Xbh݂ꍇ͓K؂Ȑ̃XbhǍŔVOiԂɖ߂
 *
 -----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CEvent::Pulse(void)
{
	return ::PulseEvent(m_hObject);
}

/**********************************************************************//**
 *
 * bN
 *
 -----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CEvent::Unlock(LONG lCount, LONG *pPrevCount)
{
	IRIS_UNUSED_VARIABLE(lCount);
	IRIS_UNUSED_VARIABLE(pPrevCount);
    return SetSignal();
}

}	// end of namespace wx
}	// end of namespace iris
