//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXSocket.cpp
 * @brief		winsocketNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXSocket_CPP_

//======================================================================
// include
#include "WXSocket.h"

//======================================================================
// link
#if defined(IRIS_MSC)
#  if	defined(IRIS_WIN32_WCE)
#    pragma comment( lib, "winsock.lib" )
#    pragma comment( lib, "ws2.lib" )
#  else
#    pragma comment( lib, "wsock32.lib" )
#  endif
#endif

namespace iris {
namespace wx
{

//======================================================================
// class
//======================================================================
// CSocket

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CSocket::CSocket(void)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CSocket::~CSocket(void)
{
	Close();
}

/**********************************************************************//**
 *
 * J
 *
 ----------------------------------------------------------------------
 * @param [in]	af			= AF_***
 * @param [in]	type		= SOCK_***
 * @param [in]	protocol	=
 * @return	
*//***********************************************************************/
BOOL CSocket::Open(int af, int type, int protocol)
{
	m_Socket = socket(af, type, protocol);
	return (m_Socket == INVALID_SOCKET) ? FALSE : TRUE;
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
int CSocket::Close(void)
{
	return closesocket(m_Socket);
}

/**********************************************************************//**
 *
 * |[gƂ̌
 *
 ----------------------------------------------------------------------
 * @param [in]	pAddr	= 
 * @param [in]	namelen	= pAddr ̃TCY 
 * @return	
*//***********************************************************************/
int CSocket::Bind(sockaddr* pAddr, int namelen)
{
	return bind(m_Socket, pAddr, namelen);
}

}	// end of namespace wx
}	// end of namespace iris
