//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXPop3.h
 * @brief		Pop3vgRNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXPop3_H_
#define INCG_IRIS_WXPop3_H_

//======================================================================
// include
#include "WXTCP.h"
#include <string>

namespace iris {
namespace wx
{

//======================================================================
// class
//! POP3NCAgNX
class CPop3Client : public CTCPSocket
{
public:

	// RXgN^
	CPop3Client();
	// fXgN^
	~CPop3Client();

public:
	// OC
	BOOL	Login(LPCSTR lpszHost, LPCSTR lpszName, LPCSTR lpszPassword);

	// OAEg
	BOOL	Logout(void);

public:
	// STAT
	BOOL	Stat(LPINT lpMailCnt, LPDWORD lpdwSize);
	// LIST
	BOOL	List(std::string& rRecv, int nIndex);
	// RETR
	BOOL	Retr(std::string& rRecv, int nIndex);
	// DELE
	BOOL	Dele(int nIndex);
	// RSET
	BOOL	Rset(void);
	// NOOP
	BOOL	Noop(void);

public:
	// Option
	// APOP
	//BOOL	Apop(void);
	// TOP
	BOOL	Top(std::string& rRecv, int nIndex, int nLine);
	// UIDL
	//BOOL	Uidl(void);

protected:
	// Xe[^X̊mF
	BOOL	IsStatusOK(void) const;
	// I[܂ŎM
	BOOL	RecvEnd(std::string& rRecv) const;
};

}	// end of namespace wx
}	// end of namespace iris

#endif 
