//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXLocalMemory.h
 * @brief		[JnhNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXLocalMemory_H_
#define INCG_IRIS_WXLocalMemory_H_

//======================================================================
// include
#include "iris_object.h"

namespace iris {
namespace wx 
{

//======================================================================
// decalre
class CLocalMemory;

//======================================================================
// typedef
typedef CLocalMemory	CLMem;	//!< [JnhNX

//======================================================================
// class
//! [JnhNX
class CLocalMemory : public INonCopyable<CLocalMemory>
{
	HLOCAL m_hMem;	//!< nh

public:
	/**
	 * @brief	XR[vNX
	*/
	class CScope : public INonCopyable<CScope>
	{
		CLocalMemory&	m_Mem;
		LPVOID			m_ptr;
	private:
		CScope& operator = (const CScope&);
	public:
		CScope(CScope& rhs) : m_Mem(rhs.m_Mem), m_ptr(rhs.m_ptr)
		{
			rhs.m_ptr = nullptr;
		}
		CScope(CLocalMemory& rMem) : m_Mem(rMem), m_ptr(nullptr)
		{
			m_ptr = rMem.Lock();
		}
		~CScope(void)
		{
			if( m_ptr != nullptr )
				m_Mem.Unlock();
		}
	public:
		template<typename T>
		operator T*	(void)	{ return static_cast<T*>(m_ptr); }

	public:
		bool	operator == (LPVOID ptr)	const	{ return m_ptr == ptr; }
		bool	operator != (LPVOID ptr)	const	{ return m_ptr != ptr; }
	};

public:
	// RXgN^
	CLocalMemory(void);
	// fXgN^
	virtual ~CLocalMemory(void);

	//
	HGLOBAL			GetHandle(void)				{ return m_hMem; }
	operator		HGLOBAL	(void)				{ return GetHandle(); }
	CLocalMemory&	operator = (HGLOBAL hMem)	{ Attach(hMem); return *this; }
public:
	// Attach
	HGLOBAL	Attach(HGLOBAL hMem);
	// Detach
	HGLOBAL	Detach(void);

public:
	// Alloc
	bool	Alloc(UINT uFlags, SIZE_T dwBytes);
	// ReAlloc
	bool	ReAlloc(UINT uFlags, SIZE_T dwBytes);
	// 폜
	void	Discard(void);
	// 
	void	Free(void);
	// Lock
	LPVOID	Lock(void);
	// Unlock
	BOOL	Unlock(void);

public:
	// TCY擾
	SIZE_T	GetSize(void)	const;
	// tO擾
	UINT	GetFlags(void)	const;
};

}	// end of namespace wx
}	// end of namespace iris

#endif
