//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXMailSlot.cpp
 * @brief		[XbgNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXMailSlot_CPP_

//======================================================================
// include
#include "WXMailSlot.h"

namespace iris {
namespace wx
{

//======================================================================
// class
//======================================================================
// CMailSlot

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CMailSlot::CMailSlot(void)
{
}

/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	hSlot	= ֘Atnh
*//***********************************************************************/
CMailSlot::CMailSlot(HANDLE hSlot)
: CHFile(hSlot)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
//CMailSlot::~CMailSlot(void)
//{
//}

/**********************************************************************//**
 *
 * 쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	lpName			= 
 * @param [in]	dwMaxMsgSize	= ő僁bZ[WTCY
 * @param [in]	dwReadTimeout	= ^CAEg
 * @param [in]	lpsa			= 
 * @return	
*//***********************************************************************/
template<>
BOOL CMailSlot::Create<CHAR>(LPCSTR  lpName, DWORD dwMaxMsgSize, DWORD dwReadTimeout, PSECURITY_ATTRIBUTES lpsa)
{
	HANDLE hObject = CreateMailslotA(lpName, dwMaxMsgSize, dwReadTimeout, lpsa);
	if( hObject == INVALID_HANDLE_VALUE ) return FALSE;
	return TryAttach(hObject);
}
/// CMailSlot::Create Q
template<>
BOOL CMailSlot::Create<WCHAR>(LPCWSTR lpName, DWORD dwMaxMsgSize, DWORD dwReadTimeout, PSECURITY_ATTRIBUTES lpsa)
{
	HANDLE hObject = CreateMailslotW(lpName, dwMaxMsgSize, dwReadTimeout, lpsa);
	if( hObject == INVALID_HANDLE_VALUE ) return FALSE;
	return TryAttach(hObject);
}

/**********************************************************************//**
 *
 * 擾
 *
 ----------------------------------------------------------------------
 * @param [out]	lpMaxMsgSize	= ő僁bZ[WTCY
 * @param [out]	lpNextSize		= ̃bZ[W̃TCY
 * @param [out]	lpMessageCount	= bZ[W̑
 * @param [out]	lpReadTimeout	= ^CAEg
 * @return	
*//***********************************************************************/
BOOL CMailSlot::GetInfo(LPDWORD lpMaxMsgSize, LPDWORD lpNextSize, LPDWORD lpMessageCount, LPDWORD lpReadTimeout)	const
{
	return GetMailslotInfo(m_hObject, lpMaxMsgSize, lpNextSize, lpMessageCount, lpReadTimeout);
}

/**********************************************************************//**
 *
 * ^CAEgԂ̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	dwReadTimeout	= ^CAEg
 * @return	
*//***********************************************************************/
BOOL CMailSlot::SetInfo(DWORD dwReadTimeout)
{
	return SetMailslotInfo(m_hObject, dwReadTimeout);
}

}	// end of namespace wx
}	// end of namespace iris

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "unit/UnitCore.h"
#include <stdio.h>
#include <string.h>
#include <tchar.h>
#include <conio.h>
#include "iris_using.h"
#include "iris_iostream.h"

//======================================================================
// test
IRIS_UNITTEST(CWXMailslotUnitTest, Func)
{
	TCHAR path[MAX_PATH];
	iris::wx::CMailSlot mailslot;
	std::cout << "J[XbgpX͂ĂB" << std::endl;
	std::tcin >> path;

	if( !mailslot.Create(path, 0, 0, nullptr) ) return;

	std::cout << "Iɂ͉L[Ă" << std::endl;
	while(1)
	{
		if( _kbhit() ) 
		{
			std::cout << std::endl;
			break;
		}

		DWORD nNext, nCount, dwRead;
		if( !mailslot.GetInfo(nullptr, &nNext, &nCount, nullptr ) ) continue;

		if( nNext == MAILSLOT_NO_MESSAGE ) continue;

		LPSTR buf = new CHAR [nNext+1];

		mailslot.Read(buf, nNext, &dwRead);

		buf[nNext] = '\0';

		std::cout << buf;

		delete [] buf;
	}
}

#endif	// #if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
