//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXPaintStruct.h
 * @brief		PAINTSTRUCT t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXPaintStruct_H_
#define INCG_IRIS_WXPaintStruct_H_

//======================================================================
// include
#include "WXDeviceContext.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/** 
 * @brief	PAINTSTRUCT NX
 * @note	Attach, Detach, DeleteDCĂяoƂ̓ۏႵȂ
*/
class CPaintStruct : public CDeviceContext
{
private:
	PAINTSTRUCT	m_Paint;	//!< paint \
	HWND		m_hWnd;		//!< EBhEnh
public:
	// RXgN^
	CPaintStruct(void);
	CPaintStruct(HDC hDC);
	CPaintStruct(HWND hWnd);
	// fXgN^
	~CPaintStruct(void);

	PAINTSTRUCT&	GetPaintStruct(void)	{ return m_Paint; }
	operator PAINTSTRUCT& (void)			{ return GetPaintStruct(); }

public:
	// Jn
	HDC		Begin(HWND hWnd);
	// I
	BOOL	End(void);
};


}	// end of namespace wx
}	// end of namespace iris

#endif
