//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXGdiFont.h
 * @brief		GDItHgIuWFNgNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXGdiFont_CPP_

//======================================================================
// include
#include "WXGdiFont.h"

namespace iris {
namespace wx
{

//======================================================================
// class

// CGDIFont
/**********************************************************************//**
 *
 * tHg̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	nHeight			= 
 * @param [in]	nWidth			= 
 * @param [in]	nEscapement		= 
 * @param [in]	nOrientation	= 
 * @param [in]	nWeight			= 
 * @param [in]	bItalic			= 
 * @param [in]	bUnderline		= 
 * @param [in]	bStrikeOut		= 
 * @param [in]	iCharSet		= 
 * @param [in]	iOutPrecision	= 
 * @param [in]	iClipPrecision	= 
 * @param [in]	iQuality		= 
 * @param [in]	iPitchAndFamily	= 
 * @param [in]	pszFaceName		= 
 * @return	
*//***********************************************************************/
template<>
BOOL CGDIFont::Create<CHAR>(int nHeight, int nWidth, int nEscapement, int nOrientation, int nWeight
				, DWORD bItalic, DWORD bUnderline, DWORD bStrikeOut
				, DWORD iCharSet, DWORD iOutPrecision, DWORD iClipPrecision
				, DWORD iQuality, DWORD iPitchAndFamily, LPCSTR  pszFaceName)
{
	HFONT hFont = CreateFontA(nHeight, nWidth, nEscapement, nOrientation, nWeight
		, bItalic, bUnderline, bStrikeOut
		, iCharSet, iOutPrecision, iClipPrecision
		, iQuality, iPitchAndFamily, pszFaceName);
	return TryAttach(hFont);
}
/// CGDIFont::Create Q
template<>
BOOL CGDIFont::Create<WCHAR>(int nHeight, int nWidth, int nEscapement, int nOrientation, int nWeight
				, DWORD bItalic, DWORD bUnderline, DWORD bStrikeOut
				, DWORD iCharSet, DWORD iOutPrecision, DWORD iClipPrecision
				, DWORD iQuality, DWORD iPitchAndFamily, LPCWSTR pszFaceName)
{
	HFONT hFont = CreateFontW(nHeight, nWidth, nEscapement, nOrientation, nWeight
		, bItalic, bUnderline, bStrikeOut
		, iCharSet, iOutPrecision, iClipPrecision
		, iQuality, iPitchAndFamily, pszFaceName);
	return TryAttach(hFont);
}

/**********************************************************************//**
 *
 * tHg̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	lplf	= tHg
 * @return	
*//***********************************************************************/
template<>
BOOL CGDIFont::CreateIndirect<LOGFONTA>(const LOGFONTA* lplf)
{
#if !defined(IRIS_WIN32_WCE)
	HFONT hFont = CreateFontIndirectA(lplf);
	return TryAttach(hFont);
#else
	return FALSE;
#endif
}
/// CGDIFont::CreateIndirect Q
template<>
BOOL CGDIFont::CreateIndirect<LOGFONTW>(const LOGFONTW* lplf)
{
	HFONT hFont = CreateFontIndirectW(lplf);
	return TryAttach(hFont);
}

}	// end of namespace wx
}	// end of namespace iris
