//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXGdiBrush.h
 * @brief		GDIuVIuWFNgNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXGdiBrush_CPP_

//======================================================================
// include
#include "WXGdiBrush.h"

namespace iris {
namespace wx
{

//======================================================================
// class

// CGDIBrush
/**********************************************************************//**
 *
 * uV̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	color	= F
 * @return	
*//***********************************************************************/
BOOL CGDIBrush::CreateSolid(COLORREF color)
{
	if( m_hObject != nullptr ) return FALSE;
	_MyHandle hObj = CreateSolidBrush(color);
	return TryAttach(hObj);
}

/**********************************************************************//**
 *
 * uV̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	nHatch	= nb`X^C(HS_***)
 * @param [in]	color	= F
 * @return	
*//***********************************************************************/
BOOL CGDIBrush::CreateHatch(int nHatch, COLORREF color)
{
#if	!defined(IRIS_WIN32_WCE)
	if( m_hObject != nullptr ) return FALSE;
	_MyHandle hObj = CreateHatchBrush(nHatch, color);
	return TryAttach(hObj);
#else
	return FALSE;
#endif
}

/**********************************************************************//**
 *
 * uV̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	nStyle	= X^C
 * @param [in]	Hatch	= nStyleBS_DIB***w肵Ƃ́ADIBBBS_HATCHED̂Ƃ́Anb`X^C(HS_***)
 * @param [in]	color	= F
 * @return	
*//***********************************************************************/
BOOL CGDIBrush::Create(UINT nStyle, ULONG_PTR Hatch, COLORREF color)
{
	LOGBRUSH log;
	log.lbStyle		= nStyle;
	log.lbHatch		= Hatch;
	log.lbColor		= color;
	return Create(&log);
}

/**********************************************************************//**
 *
 * uV̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	lppen	= y
 * @return	
*//***********************************************************************/
BOOL CGDIBrush::Create(const PLOGBRUSH lpbrush)
{
#if	!defined(IRIS_WIN32_WCE)
	if( m_hObject != nullptr ) return FALSE;
	_MyHandle hObj = CreateBrushIndirect(lpbrush);
	return TryAttach(hObj);
#else
	return FALSE;
#endif
}

/**********************************************************************//**
 *
 * uV̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	lpPackedDIB	= DIB
 * @param [in]	Usage		= 
 * @return	
*//***********************************************************************/
BOOL CGDIBrush::Create(const LPVOID lpPackedDIB, UINT Usage)
{
#if	!defined(IRIS_WIN32_WCE)
	if( m_hObject != nullptr ) return FALSE;
	_MyHandle hObj = CreateDIBPatternBrushPt(lpPackedDIB, Usage);
	return TryAttach(hObj);
#else
	return FALSE;
#endif
}

/**********************************************************************//**
 *
 * uV̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	hBitmap	= p^[rbg}bv
 * @return	
*//***********************************************************************/
BOOL CGDIBrush::Create(HBITMAP hBitmap)
{
#if	!defined(IRIS_WIN32_WCE)
	if( m_hObject != nullptr ) return FALSE;
	_MyHandle hObj = CreatePatternBrush(hBitmap);
	return TryAttach(hObj);
#else
	return FALSE;
#endif
}

}	// end of namespace wx
}	// end of namespace iris
