//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXGdiBitmap.cpp
 * @brief		HBITMAPNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXGdiBitmap_CPP_

//======================================================================
// include
#include "WXGdiBitmap.h"
#include "fnd/image/FndImage.h"
#include "fnd/memory/FndMemory.h"

namespace iris {
namespace wx
{

//======================================================================
// class

/**********************************************************************//**
 *
 * rbg}bv̍쐬
 *
 -----------------------------------------------------------------------
 * @param [in]	nWidth		= 
 * @param [in]	nHeight		= 
 * @param [in]	uPlanes		= J[v[
 * @param [in]	nBitCount	= rbg[x
 * @param [in]	lpBits		= sNZf[^
 * @return	
*//***********************************************************************/
BOOL CGDIBitmap::Create(int nWidth, int nHeight, UINT uPlanes, UINT nBitCount, const void* lpBits)
{
	HBITMAP hBmp = CreateBitmap(nWidth, nHeight, uPlanes, nBitCount, lpBits);
	if( hBmp == nullptr ) return FALSE;
	return TryAttach(hBmp);
}

/**********************************************************************//**
 *
 * rbg}bv̍쐬
 *
 -----------------------------------------------------------------------
 * @param [in]	lpbmp		= rbg}bv
 * @return	
*//***********************************************************************/
BOOL CGDIBitmap::CreateIndirect(const LPBITMAP lpbmp)
{
	if( lpbmp == nullptr ) return FALSE;
#if	!defined(IRIS_WIN32_WCE)
	HBITMAP hBmp = CreateBitmapIndirect(lpbmp);
#else
	HBITMAP hBmp = CreateBitmap(lpbmp->bmWidth, lpbmp->bmHeight, lpbmp->bmPlanes, lpbmp->bmBitsPixel, lpbmp->bmBits);
#endif
	if( hBmp == nullptr ) return FALSE;
	return TryAttach(hBmp);
}

/**********************************************************************//**
 *
 * rbg}bv̍쐬
 *
 -----------------------------------------------------------------------
 * @param [in]	hdc		= foCXReLXg
 * @param [in]	lpbih	= rbg}bṽf[^
 * @param [in]	dwInit	= IvV
 * @param [in]	pjBits	= f[^
 * @param [in]	lpbmi	= rbg}bv
 * @param [in]	Usage	= F̎gp@B(DIB_***)
 * @return	
*//***********************************************************************/
BOOL CGDIBitmap::CreateDIB(HDC hdc, const LPBITMAPINFOHEADER lpbih, DWORD dwInit, const void* pjBits, const LPBITMAPINFO lpbmi, UINT Usage)
{
#if !defined(IRIS_WIN32_WCE)
	HBITMAP hBmp = CreateDIBitmap(hdc, lpbih, dwInit, pjBits, lpbmi, Usage);
	if( hBmp == nullptr ) return FALSE;
	return TryAttach(hBmp);
#else
	return FALSE;
#endif
}

/**********************************************************************//**
 *
 * rbg}bv̍쐬
 *
 -----------------------------------------------------------------------
 * @param [in]	hdc			= foCXReLXg
 * @param [in]	lpbmi		= rbg}bv
 * @param [in]	Usage		= F̎gp@B(DIB_***)
 * @param [out]	ppvBits		= óBDIBrbgl
 * @param [in]	hSection	= t@C}bsOIuWFNg(nullptr)
 * @param [in]	offset		= t@C}bsOIuWFNg̃ItZbg
 * @return	
*//***********************************************************************/
BOOL CGDIBitmap::CreateDIBSection(HDC hdc, const LPBITMAPINFO lpbmi, UINT Usage, void** ppvBits, HANDLE hSection, DWORD offset)
{
	HBITMAP hBmp = ::CreateDIBSection(hdc, lpbmi, Usage, ppvBits, hSection, offset);
	if( hBmp == nullptr ) return FALSE;
	return TryAttach(hBmp);
}

/**********************************************************************//**
 *
 * rbg}bv̓ǂݍ
 *
 -----------------------------------------------------------------------
 * @param [in]	hInstance		= CX^Xnh
 * @param [in]	lpBitmapName	= rbg}bv
 * @return	
*//***********************************************************************/
template<>
BOOL CGDIBitmap::Load<CHAR>(HINSTANCE hInstance, LPCSTR  lpBitmapName)
{
#if !defined(IRIS_WIN32_WCE)
	HBITMAP hBmp = ::LoadBitmapA(hInstance, lpBitmapName);
	return TryAttach(hBmp);
#else
	return FALSE;
#endif
}
/// CGDIBitmap::Load Q
template<>
BOOL CGDIBitmap::Load<WCHAR>(HINSTANCE hInstance, LPCWSTR lpBitmapName)
{
	HBITMAP hBmp = ::LoadBitmapW(hInstance, lpBitmapName);
	return TryAttach(hBmp);
}

/**********************************************************************//**
 *
 * foCXReLXgɊ֘AtĂrbg}bv̍쐬
 *
 -----------------------------------------------------------------------
 * @param [in]	hdc		= foCXReLXg
 * @param [in]	cx		= 
 * @param [in]	cy		= 
 * @return	
*//***********************************************************************/
BOOL CGDIBitmap::CreateCompatible(HDC hdc, int cx, int cy)
{
	HBITMAP hBmp = CreateCompatibleBitmap(hdc, cx, cy);
	return TryAttach(hBmp);
}

/**********************************************************************//**
 *
 * foCXReLXgɊ֘AtĂrbg}bv̍쐬
 *
 -----------------------------------------------------------------------
 * @param [in]	hdc		= foCXReLXg
 * @param [in]	cx		= 
 * @param [in]	cy		= 
 * @return	
*//***********************************************************************/
BOOL CGDIBitmap::CreateFromImage(fnd::IImage* pImage, HDC hdc)
{
	if( pImage == nullptr ) return FALSE;
	BITMAPINFO bmi = {0};
	bmi.bmiHeader.biSize = sizeof(bmi.bmiHeader);
	bmi.bmiHeader.biBitCount	= fnd::IImage::Format<fnd::IImage::PF_RGBA8>::bitcount;
	bmi.bmiHeader.biPlanes		= 1;
	bmi.bmiHeader.biWidth		= pImage->GetWidth();
	bmi.bmiHeader.biHeight		= pImage->GetHeight();
	bmi.bmiHeader.biCompression	= BI_RGB;
#if 1
	void* buf = nullptr;
	if( !CreateDIBSection(hdc, &bmi, DIB_RGB_COLORS, &buf, nullptr, 0) ) return FALSE;
	if( buf == nullptr ) return FALSE;

	if( !pImage->CreateImage(buf, fnd::IImage::PF_RGBA8, 4) ) return FALSE;

	Flush();

#else
	void* buf = irisAlloc(pImage->GetRawDataSize(fnd::IImage::PF_RGBA8, 4), 0);
	if( buf == nullptr ) return FALSE;
	BOOL ret = FALSE;
	if( pImage->CreateImage(buf, fnd::IImage::PF_RGBA8, 4) )
	{
		ret = CreateDIB(hdc, &bmi.bmiHeader, CBM_INIT, buf, &bmi, DIB_RGB_COLORS);
	}
	irisFree(buf);
#endif
	return TRUE;
}

/**********************************************************************//**
 *
 * rbg}bv̎擾
 *
 -----------------------------------------------------------------------
 * @param [in]	lpBmp	= foCXReLXg
 * @return	
*//***********************************************************************/
BOOL CGDIBitmap::GetBitmapInfo(LPBITMAP lpBmp) const
{
	return GetObject(lpBmp, sizeof(BITMAP)) ? TRUE : FALSE;
}

/**********************************************************************//**
 *
 * rbg}bv̎̕擾
 *
 -----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
s32 CGDIBitmap::GetWidth(void) const
{
	BITMAP bmp;
	GetBitmapInfo(&bmp);
	return bmp.bmWidth;
}

/**********************************************************************//**
 *
 * rbg}bv̍̎擾
 *
 -----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
s32 CGDIBitmap::GetHeight(void) const
{
	BITMAP bmp;
	GetBitmapInfo(&bmp);
	return bmp.bmHeight;
}

/**********************************************************************//**
 *
 * f[^̕ύX
 *
 -----------------------------------------------------------------------
 * @param [in]	hdc			= foCXReLXg
 * @param [in]	uStart		= ύX̊JnC
 * @param [in]	uLines		= ύX郉C
 * @param [in]	lpBits		= rbg
 * @param [in]	lpbmi		= rbg}bv
 * @param [in]	ColorUse	= J[CfbNX̎
 * @return	
*//***********************************************************************/
int CGDIBitmap::SetDIBits(HDC hdc, UINT uStart, UINT uLines, const void* lpBits, const LPBITMAPINFO lpbmi, UINT ColorUse)
{
#if	!defined(IRIS_WIN32_WCE) || defined(UNDER_NT)
	return ::SetDIBits(hdc, m_hObject, uStart, uLines, lpBits, lpbmi, ColorUse);
#else
	return FALSE;
#endif
}

/**********************************************************************//**
 *
 * f[^̎擾
 *
 -----------------------------------------------------------------------
 * @param [in]	hdc			= foCXReLXg
 * @param [in]	uStart		= ύX̊JnC
 * @param [in]	uLines		= ύX郉C
 * @param [out]	lpBits		= rbg
 * @param [out]	lpbmi		= rbg}bv
 * @param [in]	Usage		= F̎gp@B(DIB_***)
 * @return	
*//***********************************************************************/
int CGDIBitmap::GetDIBits(HDC hdc, UINT uStart, UINT uLines, LPVOID lpBits, LPBITMAPINFO lpbmi, UINT Usage) const
{
#if	!defined(IRIS_WIN32_WCE) || defined(UNDER_NT)
	return ::GetDIBits(hdc, m_hObject, uStart, uLines, lpBits, lpbmi, Usage);
#else
	return FALSE;
#endif
}

/**********************************************************************//**
 *
 * Flush
 *
 -----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CGDIBitmap::Flush(void)
{
#if	!defined(IRIS_WIN32_WCE)
	return ::GdiFlush();
#else
	return TRUE;
#endif
}

/**********************************************************************//**
 *
 * rbg}bṽTCY擾
 *
 * @note	擾Ώۂ̃TCÝA SetDimensionEx ֐gĐݒ肵̂łȂ΂Ȃ܂
 *
 -----------------------------------------------------------------------
 * @param [out]	lpSize		= o
 * @return	
*//***********************************************************************/
BOOL CGDIBitmap::GetDimensionEx(LPSIZE lpSize) const
{
#if	!defined(IRIS_WIN32_WCE)
	return GetBitmapDimensionEx(m_hObject, lpSize);
#else
	BITMAP bm;
	GetBitmapInfo(&bm);
	if( lpSize == nullptr )	return FALSE;
	lpSize->cx = bm.bmWidth;
	lpSize->cx = bm.bmHeight;
	return TRUE;
#endif
}

/**********************************************************************//**
 *
 * rbg}bṽTCYݒ
 *
 -----------------------------------------------------------------------
 * @param [in]	nWidth	= (0.01mmP)
 * @param [in]	nHeight	= (0.01mmP)
 * @param [out]	lpSize	= ̃TCY(nullptr)
 * @return	
*//***********************************************************************/
BOOL CGDIBitmap::SetDimensionEx(int nWidth, int nHeight, LPSIZE lpSize)
{
#if	!defined(IRIS_WIN32_WCE)
	return SetBitmapDimensionEx(m_hObject, nWidth, nHeight, lpSize);
#else
	IRIS_UNUSED_VARIABLE(nWidth);
	IRIS_UNUSED_VARIABLE(nHeight);
	IRIS_UNUSED_VARIABLE(lpSize);
	return FALSE;
#endif
}

}	// end of namespace wx
}	// end of namespace iris


#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "../debug/unittest/WXDebugUnitTest.h"
#include "WXWndDC.h"
#include "iris_using.h"
#include "../../iris_iostream.h"
#include <stdio.h>
#include <string.h>
#include <tchar.h>

//======================================================================
// function
static LRESULT CALLBACK WindowProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam);

//======================================================================
// class
class CWXGdiBitmapUnitTest : public iris::unit::CUnitTest<CWXGdiBitmapUnitTest>
{
public:
	iris::wx::CGDIBitmap m_bitmap;

protected:
	template<typename TN>
	void	test_base(TN& img)
	{
		TCHAR path[MAX_PATH];
		std::cout << "Jt@C͂ĂB" << std::endl;
		std::tcin >> path;

		if( !img.ReadFile(path) ) 
		{
			std::cout << "t@CI[vɎs܂B" << std::endl;
			return;
		}

		static const int WINDOW_STYLE	= ( WS_CAPTION | WS_SYSMENU | WS_MINIMIZEBOX | WS_MAXIMIZEBOX );
		static const int WINDOW_STYLEEX	= ( WS_EX_OVERLAPPEDWINDOW );
		HWND hWnd = nullptr;

		if( !m_bitmap.CreateFromImage(&img) ) return;
		RECT src = {0, 0, img.GetWidth(), img.GetHeight()};

		// EBhEg̒
		AdjustWindowRectEx(
			&src,
			WINDOW_STYLE,
			FALSE,
			WINDOW_STYLEEX );

		// EBhE̍쐬
		hWnd = wx::dbg::CreateUnitTestWindow(
			WINDOW_STYLEEX,
			GetTestName(),
			GetTestName(),
			WINDOW_STYLE,
			src.right,
			src.bottom,
			WindowProc
			);

		// EBhE̍쐬Ɏs
		if( hWnd == nullptr ) return;

		// EBhE\
		ShowWindow(hWnd, SW_SHOW);
		// EBhE̍XV
		UpdateWindow(hWnd);
		// őOʂ
		SetForegroundWindow(hWnd);

		// bZ[W[v
		wx::dbg::UnitTestMainLoop(hWnd);
	}
};

//======================================================================
// test

#if defined(_IRIS_SUPPORT_PNG)

#include "fnd/image/FndPng.h"

IRIS_UNITTEST_F(CWXGdiBitmapUnitTest, Png)
{
	fnd::CPng img;
	test_base(img);
}

#endif

#include "fnd/image/FndTga.h"

IRIS_UNITTEST_F(CWXGdiBitmapUnitTest, Tga)
{
	fnd::CTga img;
	test_base(img);
}

#if defined(IDB_BITMAP1)

IRIS_UNITTEST_F(CWXGdiBitmapUnitTest, Resource)
{
	static const int WINDOW_STYLE	= ( WS_CAPTION | WS_SYSMENU | WS_MINIMIZEBOX | WS_MAXIMIZEBOX );
	static const int WINDOW_STYLEEX	= ( WS_EX_OVERLAPPEDWINDOW );

	HWND hWnd = nullptr;
	if( !m_bitmap.Load(::GetModuleHandle(nullptr), (LPCTSTR)IDB_BITMAP1) ) return;
	RECT src = {0, 0, m_bitmap.GetWidth(), m_bitmap.GetHeight()};

	// EBhEg̒
	AdjustWindowRectEx(
		&src,
		WINDOW_STYLE,
		FALSE,
		WINDOW_STYLEEX );

	// EBhE̍쐬
	hWnd = wx::dbg::CreateUnitTestWindow(
		WINDOW_STYLEEX,
		m_TestName,
		m_TestName,
		WINDOW_STYLE,
		src.right,
		src.bottom,
		WindowProc
		);

	// EBhE̍쐬Ɏs
	if( hWnd == nullptr ) return;

	// EBhE\
	ShowWindow(hWnd, SW_SHOW);
	// EBhE̍XV
	UpdateWindow(hWnd);
	// őOʂ
	SetForegroundWindow(hWnd);

	// bZ[W[v
	wx::dbg::UnitTestMainLoop(hWnd);
}

#endif

/**********************************************************************//**
 *
 * eXgpEBhEvV[W
 * 
 ----------------------------------------------------------------------
 * @param	hWnd	EBhEnh
 * @param	uMsg	sꂽbZ[W
 * @param	wParam	sꂽbZ[W@
 * @param	lParam	sꂽbZ[WA
 * @return	LRESULTl
*//***********************************************************************/
LRESULT CALLBACK WindowProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	// bZ[W̏
	switch( uMsg )
	{
	case WM_PAINT:
		{
			CWXGdiBitmapUnitTest* lput = CWXGdiBitmapUnitTest::GetCurrent();
			PAINTSTRUCT ps;
			HDC hdc = BeginPaint(hWnd, &ps);
			iris::wx::CDeviceContext dc(hdc);
			CDeviceContext cdc = dc.CreateCompatibleDC();
			cdc.SelectObject(lput->m_bitmap);

			int w = lput->m_bitmap.GetWidth();
			int h = lput->m_bitmap.GetHeight();
#if 1
			dc.Rectangle(0, 0, w, h);
			BLENDFUNCTION btn;
			btn.BlendOp = AC_SRC_OVER;
			btn.BlendFlags = 0;
			btn.AlphaFormat = AC_SRC_ALPHA;
			btn.SourceConstantAlpha = 255;
			dc.AlphaBlend(0, 0, w, h, cdc, 0, 0, w, h, btn);
#else
			dc.BitBlt(0, 0, w, h, cdc, 0, 0, SRCCOPY);
#endif
			dc.Detach();
			EndPaint(hWnd, &ps);
		}
		break;
	default:
		return ::iris::wx::dbg::UnitTest_WindowProc( hWnd, uMsg, wParam, lParam );
	}
	return 0L;
}

#endif
