//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXVSInstallRegistry.h
 * @brief		Visual Studio WXg t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXVSInstallRegistry_H_
#define INCG_IRIS_WXVSInstallRegistry_H_

//======================================================================
// include
#include "../../registry/WXRegistry.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/// Visual Studio WXgNX
class CVSInstallRegistry : public IIrisObject
{
public:
	typedef enum
	{
		eNONE= 0,
		eVS,			//!< Visual Studio
		eVB,			//!< Visual Basic
		eVC,			//!< Visual C++
		eVCS,			//!< Visual C#
		eVWD,			//!< Visual Web Developer
		eTYPENUM
	};
	typedef enum
	{
		NONE	= 0,
		VS		= 1<<eVS,			//!< Visual Studio
		VB		= 1<<eVB,			//!< Visual Basic
		VC		= 1<<eVC,			//!< Visual C++
		VCS		= 1<<eVCS,			//!< Visual C#
		VWD		= 1<<eVWD,			//!< Visual Web Developer
	};
private:
	CRegistry	m_Registry;		//!< WXg
	int			m_AD;			//!< o[W()
	int			m_Type;			//!< ^Cv

public:
	// RXgN^
	CVSInstallRegistry(void);

public:
	// J
	bool		Open(int AD, int Type);
	// 
	void		Close(void);
	// 
	DWORD		Find(DWORD dwIndex, int Type);
	DWORD		Find(DWORD dwIndex, int AD, int Type);

public:
	// CXg[pX̎擾
	bool		GetPath (LPTSTR lpString, DWORD dwSize);
	bool		GetPathA(LPSTR  lpString, DWORD dwSize);
	bool		GetPathW(LPWSTR lpString, DWORD dwSize);

	// st@C̃pX擾
	bool		GetExePath (LPTSTR lpString, DWORD dwSize);
	bool		GetExePathA(LPSTR  lpString, DWORD dwSize);
	bool		GetExePathW(LPWSTR lpString, DWORD dwSize);

	// st@C̃fBNgpX擾
	bool		GetExeDirectoryPath (LPTSTR lpString, DWORD dwSize);
	bool		GetExeDirectoryPathA(LPSTR  lpString, DWORD dwSize);
	bool		GetExeDirectoryPathW(LPWSTR lpString, DWORD dwSize);

	// visual studio ̃^Cv擾
	int			GetType(void);

public:
	/// WXg̎擾
			CRegistry*	GetRegistry(void)			{ return &m_Registry; }
	const	CRegistry*	GetRegistry(void)	const	{ return &m_Registry; }
	/// o[W()̎擾
	int					GetVersion(void)			{ return m_AD; }

public:
	static BOOL	_EnumProcEntry(CRegistry& rKey, DWORD dwIndex, LPVOID lpArg);
	static BOOL	_FindEnumProcEntry(CRegistry& rKey, DWORD dwIndex, LPVOID lpArg);

private:
	BOOL	_EnumProc(CRegistry& rKey, DWORD dwIndex);
	BOOL	_FindEnumProc(CRegistry& rKey, DWORD dwIndex, int AD);
};

}	// end of namespace wx
}	// end of namespace iris

#endif
