//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXStackWalker.cpp
 * @brief		WXStackWalker t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXStackWalker_CPP_

//======================================================================
// include
#include "WXStackWalker.h"
#include "../../../../../iris_xchar.hpp"

namespace iris {
namespace wx {
namespace dbg
{

//======================================================================
// class

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CStackWalker::CStackWalker(void)
{
	ZeroMemory(&m_Context, sizeof(m_Context));
	m_Context.ContextFlags = CONTEXT_FULL;

	ZeroMemory(&m_Frame, sizeof(m_Frame));
	m_Frame.AddrPC.Mode      = AddrModeFlat;
	m_Frame.AddrStack.Mode   = AddrModeFlat;
	m_Frame.AddrFrame.Mode   = AddrModeFlat;
	m_Frame.AddrReturn.Mode  = AddrModeFlat;
	m_Frame.AddrBStore.Mode  = AddrModeFlat;
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CStackWalker::~CStackWalker(void)
{
	End();
}

/**********************************************************************//**
 *
 * Jn
 * 
 -----------------------------------------------------------------------
 * @param [in]	hProcess	= vZXnh
 * @param [in]	hThread		= Xbhnh
 * @return	
*//***********************************************************************/
bool CStackWalker::Begin(HANDLE hProcess, HANDLE hThread)
{
	if( !m_Symbol.Attach(hProcess) ) return false;
	if( !m_Thread.Attach(hThread) ) return false;

#if 0
#if defined(_M_IX86)
    __asm    call(x);
    __asm x: pop eax;
    __asm    mov m_Context.Eip, eax;
    __asm    mov m_Context.Ebp, ebp;
    __asm    mov m_Context.Esp, esp;
#else
    RtlCaptureContext(&m_Context);
#endif

#else
	if( !m_Thread.GetContext(&m_Context) ) return false;
#endif

#if		defined(_M_IX86)
	m_Frame.AddrPC.Offset    = m_Context.Eip;
	m_Frame.AddrStack.Offset = m_Context.Esp;
	m_Frame.AddrFrame.Offset = m_Context.Ebp;
#elif	defined(_M_AMD64)
	m_Frame.AddrPC.Offset    = m_Context.Rip;
	m_Frame.AddrStack.Offset = m_Context.Rsp;
	m_Frame.AddrFrame.Offset = m_Context.Rbp;
#elif	defined(_M_IA64)
	m_Frame.AddrPC.Offset    = m_Context.StIIP;
	m_Frame.AddrStack.Offset = m_Context.IntSp;
	m_Frame.AddrFrame.Offset = m_Context.RsBSP;
#else
	m_Frame.AddrPC.Offset    = m_Context.Eip;
	m_Frame.AddrStack.Offset = m_Context.Esp;
	m_Frame.AddrFrame.Offset = m_Context.Ebp;
#endif
	return true;
}

/**********************************************************************//**
 *
 * ǂ
 * 
 -----------------------------------------------------------------------
 * @param [in]	ReadMemoryRoutine			= 
 * @param [in]	FunctionTableAccessRoutine	= 
 * @param [in]	GetModuleBaseRoutine		= 
 * @param [in]	TranslateAddress			= 
 * @return	
*//***********************************************************************/
bool CStackWalker::Walk(PREAD_PROCESS_MEMORY_ROUTINE ReadMemoryRoutine, PFUNCTION_TABLE_ACCESS_ROUTINE FunctionTableAccessRoutine
		, PGET_MODULE_BASE_ROUTINE GetModuleBaseRoutine, PTRANSLATE_ADDRESS_ROUTINE TranslateAddress)
{
#if		defined(_M_IX86)
	const DWORD machineType = IMAGE_FILE_MACHINE_I386;
#elif	defined(_M_AMD64)
	const DWORD machineType = IMAGE_FILE_MACHINE_AMD64;
#elif	defined(_M_IA64)
	const DWORD machineType = IMAGE_FILE_MACHINE_IA64;
#else
	const DWORD machineType = IMAGE_FILE_MACHINE_UNKNOWN;
#endif
	if( !::StackWalk(machineType
		, m_Symbol, m_Thread
		, &m_Frame, &m_Context, ReadMemoryRoutine
		, FunctionTableAccessRoutine, GetModuleBaseRoutine, TranslateAddress) )
	{
		return false;
	}
	if(m_Frame.AddrPC.Offset == m_Frame.AddrReturn.Offset)
	{
		// GhXɂȂ̂ŏI
		return false;
	}
	if(m_Frame.AddrPC.Offset == 0)
	{
		// sȃX^bNt[
		return false;
	}       
	if(m_Frame.AddrReturn.Offset == 0)
	{
		// Ō̃X^bNt[
		return false;
	}


	// W[̎擾
	IMAGEHLP_MODULE ihm = { sizeof(IMAGEHLP_MODULE), };
	if( !m_Symbol.GetModuleInfo(m_Frame.AddrPC.Offset, &ihm) )
	{
		// W[񂪎擾łȂĂƂ݂Ȃ
		return true;
	}
	return true;
}

/**********************************************************************//**
 *
 * I
 *
*//***********************************************************************/
void CStackWalker::End(void)
{
	m_Symbol.Detach();
	m_Thread.Detach();
}

/**********************************************************************//**
 *
 * V{̎擾
 * 
 -----------------------------------------------------------------------
 * @param [out]	lpszSymbolName	= o̓obt@
 * @param [in]	length			= o̓obt@
 * @return	
*//***********************************************************************/
bool CStackWalker::GetSymbolName(LPTSTR lpszSymbolName, u32 length) const
{
	if( lpszSymbolName == nullptr ) return false;
#define USE_IMAGEHLP_SYMBOL

#if	defined(USE_IMAGEHLP_SYMBOL)
	typedef IMAGEHLP_SYMBOL	SYMINFO;
#else	 
	typedef SYMINFO			SYMINFO;
#endif
	SYMINFO* pSymbol = nullptr;
	u8 buffer[sizeof(SYMINFO) + MAX_SYM_NAME * sizeof(TCHAR)] = {0};
	pSymbol = pointer_cast<SYMINFO*>(buffer);
	pSymbol->SizeOfStruct = sizeof(SYMINFO);
#if	defined(USE_IMAGEHLP_SYMBOL)
	pSymbol->MaxNameLength	= MAX_SYM_NAME;
#else
	pSymbol->MaxNameLen		= MAX_SYM_NAME;
#endif

	DWORD disp=0;
	if( m_Symbol.GetSymFromAddr(m_Frame.AddrPC.Offset, &disp, (PIMAGEHLP_SYMBOL)pSymbol) )
	{
		lpszSymbolName[0] = 0;
		return false;
	}
	xcstoxcs_s(lpszSymbolName, length, pSymbol->Name);
	return true;
}

/**********************************************************************//**
 *
 * C̎擾
 * 
 -----------------------------------------------------------------------
 * @param [out]	lpihl	= C
 * @return	
*//***********************************************************************/
bool CStackWalker::GetLine(PIMAGEHLP_LINE lpihl) const
{
	IRIS_ASSERT( lpihl->SizeOfStruct== sizeof(IMAGEHLP_LINE) );
	DWORD disp=0;
	if( !m_Symbol.GetLineFromAddr(m_Frame.AddrPC.Offset, &disp, lpihl) ) 
	{
		return false;
	}
	return true;
}


}	// end of namespace dbg
}	// end of namespace wx
}	// end of namespace iris

