//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXDirectoryEntry.h
 * @brief		DIRECTORY ENTRY t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXDirectoryEntry_H_
#define INCG_IRIS_WXDirectoryEntry_H_

//======================================================================
// include
#include "../../../../../iris_object.h"
#include "WXDebugHelp.h"

#if	defined(IRIS_WIN32_WCE)
#error	not support.
#endif

namespace iris {
namespace wx
{

//======================================================================
// class
template<USHORT DirectoryEntry>
class CDirectoryEntry : public IIrisObject
{
	template<USHORT DE>struct type_impl { typedef VOID value_type; };
	template<>struct type_impl<IMAGE_DIRECTORY_ENTRY_IMPORT> { typedef IMAGE_IMPORT_DESCRIPTOR	value_type; };
	template<>struct type_impl<IMAGE_DIRECTORY_ENTRY_EXPORT> { typedef IMAGE_EXPORT_DIRECTORY	value_type; };

public:
	typedef typename type_impl<DirectoryEntry>::value_type	value_type;
	typedef value_type										*value_ptr;
	typedef value_type										&value_ref;

public:
	value_ptr	m_pEntry;	//!< Gg[
	ULONG		m_nSize;	//!< TCY

public:
	/// RXgN^
	CDirectoryEntry(PVOID pBase, BOOLEAN bMappedAsImage)
		: m_pEntry(nullptr)
		, m_nSize(0)
	{
		m_pEntry = ToData(pBase, bMappedAsImage, &m_nSize);
	}

public:
	value_ref	operator *  (void)	{ return *m_pEntry; }
	value_ptr	operator ->	(void)	{ return m_pEntry; }
	value_ptr	ptr(void)			{ return m_pEntry; }

	operator value_ptr		(void)	{ return m_pEntry; }

public:
	/// f[^擾
	static value_ptr	ToData(PVOID pBase, BOOLEAN bMappedAsImage, PULONG pSize)
	{
		return static_cast<value_ptr>(ImageDirectoryEntryToData(pBase, bMappedAsImage, DirectoryEntry, pSize));
	}
	/// f[^擾
	static value_ptr	ToData(PVOID pBase, BOOLEAN bMappedAsImage)
	{
		ULONG uSize = 0;
		return ToData(pBase, bMappedAsImage, &uSize);
	}
};

}	// end of namespace wx
}	// end of namespace iris

#endif
