//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXDebugEvent.h
 * @brief		DEBUG_EVENT t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXDebugEvent_H_
#define INCG_IRIS_WXDebugEvent_H_

//======================================================================
// include
#include "iris_object.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/**
 * @brief	fobOCxg NX
*/
class CDebugEvent : public INonCopyable<CDebugEvent>
{
protected:
	DEBUG_EVENT	m_Event;
public:
	// RXgN^
	CDebugProcessInfo(void);

public:
	//! Cxgҋ@
	BOOL	Wait(DWORD dwTimeout)
	{
		return ::WaitForDebugEvent(&m_Event, dwTimeout);
	}
	//! s
	BOOL	Continue(DWORD dwStatus)
	{
		return ::ContinueDebugEvent(m_Event.dwProcessId, m_Event.dwThreadId, dwStatus);
	}
};

}	// end of namespace wx
}	// end of namespace iris

#endif
