//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXCrtReport.h
 * @brief		WXCrtReport t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXCrtReport_H_
#define INCG_IRIS_WXCrtReport_H_

//======================================================================
// include
#include "iris_object.h"
#include "crtdbg.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/**
 * @brief	CrtReport NX
*/
class CCrtReport : public IIrisObject
{
public:
	typedef enum CRT_TYPE
	{
		TYPE_WARN	= 1<<_CRT_WARN,
		TYPE_ERROR	= 1<<_CRT_ERROR,
		TYPE_ASSERT	= 1<<_CRT_ASSERT,
		TYPE_ERRCNT	= 1<<_CRT_ERRCNT,
		TYPE_ALL	= TYPE_WARN|TYPE_ERROR|TYPE_ASSERT|TYPE_ERRCNT,
	} CRT_TYPE;
public:
	// [hݒ
	static void				SetMode(int mode, u32 flags=TYPE_ALL);

	// t@Co̓[hɐݒ
	static void				SetRedirectMode(_HFILE file=_CRTDBG_FILE_STDOUT, u32 flags=TYPE_ALL);

	template<typename FUNC>
	static int				Hook(FUNC pfnFunc);

	template<typename FUNC>
	static int				Unhook(FUNC pfnFunc);

	static _CRT_REPORT_HOOK	HookOnce(_CRT_REPORT_HOOK pfnFunc);
};


}	// end of namespace wx
}	// end of namespace iris


#endif
