//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXListBox.h
 * @brief		ListBoxt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXListBox_H_
#define INCG_IRIS_WXListBox_H_

//======================================================================
// include
#include "../../app/WXSubClass.h"
#include <windowsx.h>

//======================================================================
// define
#define LB_SORTITEMS	LVM_SORTITEMS

//======================================================================
// types
typedef int (CALLBACK *PFNLBCOMPARE)(LPARAM, LPARAM, LPARAM);

namespace iris {
namespace wx
{

//======================================================================
// declare 
class CListBox;

//======================================================================
// function
// windowsx.hɒ`Ă̂̓Rg
// LB_ADDFILE
LRESULT ListBox_AddFile(HWND hWnd, WPARAM wParam, LPARAM lParam);
// ڂ̒ǉ
//int		ListBox_AddString(HWND hWnd, LPCTSTR pString);
// ڂ̍폜
//BOOL	ListBox_DeleteString(HWND hWnd, int nIndex);
// t@Cڂ̎擾
//int	ListBox_Dir(HWND hWnd, int DDL, LPCTSTR path);
#if (WINVER < 0x030a)
// ̌iOvj
int		ListBox_FindString(HWND hWnd, int nIndex, LPCTSTR pString);
// ̌iSvj
int		ListBox_FindStringExact(HWND hWnd, int nIndex, LPCTSTR pString);
#endif
// ŏ̑IځiAJ[j擾
int		ListBox_GetAnchorIndex(HWND hWnd);
// ڐ̎擾
//int		ListBox_GetCount(HWND hWnd);
// Xg{bNX̃Lbg̈ʒu擾
int		ListBox_GetCreateIndex(HWND hWnd);
#if (WINVER < 0x030a)
// Iڂ̎擾
int		ListBox_GetCurSel(HWND hWnd);
// XN[\̎擾
int		ListBox_GetHorizontalExtent(HWND hWnd);
// ACeɊ֘Atꂽl̎擾
//LRESULT	ListBox_GetItemData(HWND hWnd, int nIndex);
// ڂ̍̎擾
int		ListBox_GetItemHeight(HWND hWnd, int nIndex);
// Xg\̈̋E`擾
int		ListBox_GetItemRect(HWND hWnd, int nIndex, LPRECT lprc);
#endif
// [P̎擾
LCID	ListBox_GetLocale(HWND hWnd);
#if (WINVER < 0x030a)
// ڂ̏Ԃ擾
BOOL	ListBox_GetSel(HWND hWnd, int nIndex);
// Iڐ̎擾
int		ListBox_GetSelCount(HWND hWnd);
// IڂɊ֘AÂꂽl̔z擾
int		ListBox_GetSelItems(HWND hWnd, int nMaxItems, LPINT lpIndex);
// ڂ̕擾
//int		ListBox_GetText(HWND hWnd, int nIndex, LPTSTR lpBuf);
// ڂ̕񒷎擾
//int		ListBox_GetTextLen(HWND hWnd, int nIndex);
// 擪̃CfbNX擾
int		ListBox_GetTopIndex(HWND hWnd);
#endif
// ̊蓖
int		ListBox_InitStorage(HWND hWnd, int nItems, UINT nBytes);
// ڂ̑}
//int		ListBox_InsertString(HWND hWnd, int nIndex, LPCTSTR pString);
// w肳ꂽʒuɍł߂Xg {bNXڂ擾
LRESULT	ListBox_ItemFromPoint(HWND hWnd, POINT pt);
BOOL	ListBox_ItemFromPoint(HWND hWnd, POINT pt, int& nIndex);
// Sڂ폜
//BOOL	ListBox_ResetContent(HWND hWnd);
#if (WINVER < 0x030a)
// w蕶ɑOv鍀ڂI
int		ListBox_SelectString(HWND hWnd, int nIndex, LPCTSTR pString);
// w肵͈͂̍ڂI܂B}`̂
LRESULT	ListBox_SelItemRange(HWND hWnd, BOOL bSel, short First, short Last);
#endif
// w肵͈͂̍ڂI܂B}`̂
// IʒuJnʒȕꍇ͔͈͂
LRESULT	ListBox_SelItemRangeEx(HWND hWnd, int First, int Last);
// ŏ̑IځiAJ[jݒ
void	ListBox_SetAnchorIndex(HWND hWnd, int nIndex);
#if (WINVER < 0x030a)
// R̕ݒ(LBS_MULTICOLUMN)
void	ListBox_SetColumnWidth(HWND hWnd, int pixelWidth);
#endif
// LB_SETCOUNT
LRESULT	ListBox_SetCount(HWND hWnd, int nCount);
#if (WINVER < 0x030a)
// ڂ̑I
BOOL	ListBox_SetCurSel(HWND hWnd, int nIndex);
#endif
// Xg{bNX̎w肵ڌʒu܂ŃXN[
int		ListBox_SetCreateIndex(HWND hWnd, int nIndex, BOOL bScroll=1);
// XN[\̎w
BOOL	ListBox_SetHorizonTalextent(HWND hWnd, int pixelWidth);
// lACeɊ֘At
//BOOL	ListBox_SetItemData(HWND hWnd, int nIndex, LPARAM Data);
#if (WINVER < 0x030a)
// ڂ̍̎w
BOOL	ListBox_SetItemHeight(HWND hWnd, int nIndex, int pixelHeight);
#endif
// [P̐ݒ
LCID	ListBox_SetLocale(HWND hWnd, WORD Country, WORD Lang);
LCID	ListBox_SetLocale(HWND hWnd, LCID Locale);
#if (WINVER < 0x030a)
// wCfbNX̑IE
BOOL	ListBox_SetSel(HWND hWnd, BOOL bSel, int nIndex);
// ^uXgbv̐ƈʒu̐ݒ
LRESULT ListBox_SetTabStops(HWND hWnd, WPARAM wParam, LPARAM lParam);
// 擪̃CfbNXw
BOOL	ListBox_SetTopIndex(HWND hWnd, int nIndex);
#endif

//======================================================================
// class
//! Xg{bNXNX
class CListBox : public CSubClass
{
public:
	// RXgN^
	CListBox(void);
	CListBox(HWND hWnd);
	// fXgN^
	~CListBox(void);
public:
	// ftHg\[g֐
	static	int	CALLBACK DefaultCompare(LPARAM lp1, LPARAM lp2, LPARAM lpData);
public:
    // EBhE̍쐬
    virtual HWND Create(DWORD dwStyle
					, LPCTSTR lpszWindowName
					, const RECT &rRect
					, HWND hWndParent, int nID
					, HINSTANCE hInstance
					, void* pParam=nullptr );
    virtual HWND Create(DWORD dwStyle
					, LPCTSTR lpszWindowName
					, int x, int y, int w, int h
					, HWND hWndParent, int nID
					, HINSTANCE hInstance
					, void *pParam = nullptr );

    // EBhE̍쐬
    virtual HWND CreateEx(DWORD dwExStyle
					, DWORD dwStyle
					, LPCTSTR lpszWindowName
					, const RECT &rRect
					, HWND hWndParent, int nID
					, HINSTANCE hInstance
					, void* pParam=nullptr );
    virtual HWND CreateEx(DWORD dwExStyle
					, DWORD dwStyle
					, LPCTSTR lpszWindowName
					, int x, int y, int w, int h
					, HWND hWndParent, int nID
					, HINSTANCE hInstance
					, void *pParam = nullptr );
protected:
    // EBhEvV[W
	virtual LRESULT WndProc( HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam );

public:
	// wrap
	// LB_ADDFILE
	LRESULT AddFile(WPARAM wParam, LPARAM lParam);
	// ڂ̒ǉ
	int		AddString(LPCTSTR pString);
	// ڂ̍폜
	BOOL	DeleteString(int nIndex);
	// t@Cڂ̎擾
	LRESULT	Dir(int DDL, LPCTSTR path);
	// ̌iOvj
	int		FindString(int nIndex, LPCTSTR pString);
	// ̌iSvj
	int		FindStringExact(int nIndex, LPCTSTR pString);
	// ŏ̑IځiAJ[j擾
	int		GetAnchorIndex(void) const;
	// ڐ̎擾
	int		GetCount(void) const;
	// Xg{bNX̃Lbg̈ʒu擾
	int		GetCreateIndex(void) const;
	// Iڂ̎擾
	int		GetCurSel(void) const;
	// XN[\̎擾
	int		GetHorizontalExtent(void) const;
	// ACeɊ֘Atꂽl̎擾
	LRESULT	GetItemData(int nIndex) const;
	// ڂ̍̎擾
	int		GetItemHeight(int nIndex) const;
	// Xg\̈̋E`擾
	int		GetItemRect(int nIndex, LPRECT lprc) const;
	// [P̎擾
	LCID	GetLocale(void) const;
	// ڂ̏Ԃ擾
	BOOL	GetSel(int nIndex) const;
	// Iڐ̎擾
	int		GetSelCount(void) const;
	// IڂɊ֘AÂꂽl̔z擾
	int		GetSelItems(int nMaxItems, LPINT lpIndex) const;
	// ڂ̕擾
	int		GetText(int nIndex, LPTSTR lpBuf) const;
	// ڂ̕񒷎擾
	int		GetTextLen(int nIndex) const;
	// 擪̃CfbNX擾
	int		GetTopIndex(void) const;
	// ̊蓖
	LRESULT	InitStorage(int nItems, UINT nBytes);
	// ڂ̑}
	int		InsertString(int nIndex, LPCTSTR pString);
	// LB_ITEMFROMPOINT
	LRESULT	ItemFromPoint(POINT pt);
	BOOL	ItemFromPoint(POINT pt, int& nIndex);
	// Sڂ폜
	BOOL	ResetContent(void);
	// w蕶ɑOv鍀ڂI
	int		SelectString(int nIndex, LPCTSTR pString);
	// w肵͈͂̍ڂI܂B}`̂
	LRESULT	SelItemRange(BOOL bSel, short First, short Last);
	// w肵͈͂̍ڂI܂B}`̂
	// IʒuJnʒȕꍇ͔͈͂
	LRESULT	SelItemRangeEx(int First, int Last);
	// ŏ̑IځiAJ[jݒ
	void	SetAnchorIndex(int nIndex);
	// R̕ݒ(LBS_MULTICOLUMN)
	void	SetColumnWidth(int pixelWidth);
	// LB_SETCOUNT
	LRESULT	SetCount(int nCount);
	// ڂ̑I
	BOOL	SetCurSel(int nIndex);
	// Xg{bNX̎w肵ڌʒu܂ŃXN[
	int		SetCreateIndex(int nIndex, BOOL bScroll=1);
	// XN[\̎w
	BOOL	SetHorizonTalextent(int pixelWidth);
	// lACeɊ֘At
	BOOL	SetItemData(int nIndex, LPARAM Data);
	// ڂ̍̎w
	BOOL	SetItemHeight(int nIndex, int pixelHeight);
	// [P̐ݒ
	LCID	SetLocale(WORD Country, WORD Lang);
	LCID	SetLocale(LCID Locale);
	// wCfbNX̑IE
	BOOL	SetSel(BOOL bSel, int nIndex);
	// ^uXgbv̐ƈʒu̐ݒ
	LRESULT SetTabStops(WPARAM wParam, LPARAM lParam);
	// 擪̃CfbNXw
	BOOL	SetTopIndex(int nIndex);
};

}	// end of namespace wx
}	// end of namespace iris

#endif	// _WXListBox_H_

