//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXToolTipCtrl.h
 * @brief		c[`bvt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXToolTipCtrl_H_
#define INCG_IRIS_WXToolTipCtrl_H_

//======================================================================
// icnlude
#include "../app/WXSubClass.h"
#include <commctrl.h>

namespace iris {
namespace wx
{

//======================================================================
// declare 
class CToolTipCtrl;

//======================================================================
// function
// ANeBuԂ̐؂ւ
void		ToolTip_Activate(HWND hWnd, BOOL bActivate);
// c[̒ǉ
BOOL		ToolTip_AddTool (HWND hWnd, LPTOOLINFO  lpti);
BOOL		ToolTip_AddToolA(HWND hWnd, LPTOOLINFOA lpti);
BOOL		ToolTip_AddToolW(HWND hWnd, LPTOOLINFOW lpti);
// Ή̈̎擾
BOOL		ToolTip_AdjustRect(HWND hWnd, LPRECT lprc, BOOL bLarger);
// c[̍폜
void		ToolTip_DelTool (HWND hWnd, LPTOOLINFO  lpti);
void		ToolTip_DelToolA(HWND hWnd, LPTOOLINFOA lpti);
void		ToolTip_DelToolW(HWND hWnd, LPTOOLINFOW lpti);
// o^c[̗
LRESULT		ToolTip_EnumTools (HWND hWnd, UINT uIndex, LPTOOLINFO  lpti);
LRESULT		ToolTip_EnumToolsA(HWND hWnd, UINT uIndex, LPTOOLINFOA lpti);
LRESULT		ToolTip_EnumToolsW(HWND hWnd, UINT uIndex, LPTOOLINFOW lpti);
// c[qg̃TCY擾
LRESULT		ToolTip_GetBubbleSize (HWND hWnd, LPTOOLINFO  lpti);
LRESULT		ToolTip_GetBubbleSizeA(HWND hWnd, LPTOOLINFOA lpti);
LRESULT		ToolTip_GetBubbleSizeW(HWND hWnd, LPTOOLINFOW lpti);
// ݂̃c[擾
BOOL		ToolTip_GetCurrentTool (HWND hWnd, LPTOOLINFO  lpti);
BOOL		ToolTip_GetCurrentToolA(HWND hWnd, LPTOOLINFOA lpti);
BOOL		ToolTip_GetCurrentToolW(HWND hWnd, LPTOOLINFOW lpti);
// xԂ̎擾
int			ToolTip_GetDelayTime(HWND hWnd);
int			ToolTip_GetDelayTime(HWND hWnd, DWORD dwDuration);
// }[W擾
void		ToolTip_GetMargin(HWND hWnd, LPRECT lprc);
// ő啝擾
int			ToolTip_GetMaxTipWidth(HWND hWnd);
// eLXg擾
void		ToolTip_GetText (HWND hWnd, LPTOOLINFO  lpti);
void		ToolTip_GetTextA(HWND hWnd, LPTOOLINFOA lpti);
void		ToolTip_GetTextW(HWND hWnd, LPTOOLINFOW lpti);
// wiF̎擾
COLORREF	ToolTip_GetTipBkColor(HWND hWnd);
// F̎擾
COLORREF	ToolTip_GetTipTextColor(HWND hWnd);
// o^Ăc[̎擾
int			ToolTip_GetToolCount(HWND hWnd);
// c[̎擾
BOOL		ToolTip_GetToolInfo (HWND hWnd, LPTOOLINFO  lpti);
BOOL		ToolTip_GetToolInfoA(HWND hWnd, LPTOOLINFOA lpti);
BOOL		ToolTip_GetToolInfoW(HWND hWnd, LPTOOLINFOW lpti);
// qbgeXg
BOOL		ToolTip_HitTest (HWND hWnd, LPTTHITTESTINFO  lphti);
BOOL		ToolTip_HitTestA(HWND hWnd, LPTTHITTESTINFOA lphti);
BOOL		ToolTip_HitTestW(HWND hWnd, LPTTHITTESTINFOW lphti);
// ̈̍XV
BOOL		ToolTip_NewToolRect (HWND hWnd, LPTOOLINFO  lpti);
BOOL		ToolTip_NewToolRectA(HWND hWnd, LPTOOLINFOA lpti);
BOOL		ToolTip_NewToolRectW(HWND hWnd, LPTOOLINFOW lpti);
// 
void		ToolTip_Pop(HWND hWnd);
// }EXbZ[WM
LRESULT		ToolTip_RelayEvent(HWND hWnd, LPMSG msg);
// xԂ̐ݒ
void		ToolTip_SetDelayTime(HWND hWnd, int nDelay);
void		ToolTip_SetDelayTime(HWND hWnd, DWORD dwDuration, int nDelay);
// }[Wݒ
void		ToolTip_SetMargin(HWND hWnd, LPRECT lprc);
void		ToolTip_SetMargin(HWND hWnd, LONG top, LONG left, LONG bottom, LONG right);
// ő啝ݒ
int			ToolTip_SetMaxTipWidth(HWND hWnd, int nWidth);
// wiF̕ύX
void		ToolTip_SetTipBkColor(HWND hWnd, COLORREF color);
// F̕ύX
void		ToolTip_SetTipTextColor(HWND hWnd, COLORREF color);
// ^Cgݒ
LRESULT		ToolTip_SetTitle (HWND hWnd, WPARAM icon, LPCTSTR lpszTitle);
LRESULT		ToolTip_SetTitleA(HWND hWnd, WPARAM icon, LPCSTR  lpszTitle);
LRESULT		ToolTip_SetTitleW(HWND hWnd, WPARAM icon, LPCWSTR lpszTitle);
// c[̐ݒ
BOOL		ToolTip_SetToolInfo (HWND hWnd, LPTOOLINFO  lpti);
BOOL		ToolTip_SetToolInfoA(HWND hWnd, LPTOOLINFOA lpti);
BOOL		ToolTip_SetToolInfoW(HWND hWnd, LPTOOLINFOW lpti);
// ĕ`
void		ToolTip_Update(HWND hWnd);
// o^eLXg̍Đݒ
void		ToolTip_UpdateTipText (HWND hWnd, LPTOOLINFO  lpti);
void		ToolTip_UpdateTipTextA(HWND hWnd, LPTOOLINFOA lpti);
void		ToolTip_UpdateTipTextW(HWND hWnd, LPTOOLINFOW lpti);
// 
void		ToolTip_WindowFromPoint(HWND hWnd, LPPOINT lppt);

//======================================================================
// class
//! c[`bvNX
class CToolTipCtrl : public CSubClass
{
public:
	// RXgN^
	CToolTipCtrl(void);
	CToolTipCtrl(HWND hWnd);
	// fXgN^
	~CToolTipCtrl(void);
public:
    // EBhE̍쐬
    virtual HWND Create(DWORD dwStyle
					 , HWND hWndParent, int nID
					 , HINSTANCE hInstance
					 , void *pParam = nullptr );
    // EBhE̍쐬
    virtual HWND CreateEx(DWORD dwExStyle
					 , DWORD dwStyle
					 , HWND hWndParent, int nID
					 , HINSTANCE hInstance
					 , void *pParam = nullptr );
protected:
    // EBhEvV[W
	virtual LRESULT WndProc( HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam );
public:
	// wrap
	// ANeBuԂ̐؂ւ
	void		Activate(BOOL bActivate);
	template<typename CHARTYPE_>
	BOOL		AddTool(UINT uFlags, UINT_PTR uID, CHARTYPE_* lpszText, HINSTANCE hInstance=nullptr, const RECT* lprc=nullptr );
	// c[̒ǉ
	template<typename TN>
	BOOL		AddTool(TN lpti);
	// Ή̈̎擾
	BOOL		AdjustRect(LPRECT lprc, BOOL bLarger);
	// c[̍폜
	template<typename TN>
	void		DelTool(TN lpti);
	void		DelTool (UINT uFlags, UINT_PTR uID);
	void		DelToolA(UINT uFlags, UINT_PTR uID);
	void		DelToolW(UINT uFlags, UINT_PTR uID);
	// o^c[̗
	template<typename TN>
	LRESULT		EnumTools(UINT uIndex, TN lpti);
	// c[qg̃TCY擾
	template<typename TN>
	LRESULT		GetBubbleSize(TN lpti) const;
	// ݂̃c[擾
	template<typename TN>
	BOOL		GetCurrentTool(TN  lpti) const;
	// xԂ̎擾
	int			GetDelayTime(void) const;
	int			GetDelayTime(DWORD dwDuration) const;
	// }[W擾
	void		GetMargin(LPRECT lprc) const;
	// ő啝擾
	int			GetMaxTipWidth(void) const;
	// eLXg擾
	template<typename TN>
	void		GetText(TN lpti) const;
	template<typename CHARTYPE_>
	void		GetText(UINT uFlags, UINT_PTR uID, CHARTYPE_* lpszText) const;
	// wiF̎擾
	COLORREF	GetTipBkColor(void) const;
	// F̎擾
	COLORREF	GetTipTextColor(void) const;
	// o^Ăc[̎擾
	int			GetToolCount(void) const;
	// c[̎擾
	template<typename TN>
	BOOL		GetToolInfo(TN  lpti) const;
	// qbgeXg
	template<typename TN>
	BOOL		HitTest(TN lphti);
	template<typename TN>
	BOOL		HitTest(POINT pt, TN lpti);
	// ̈̍XV
	template<typename TN>
	BOOL		NewToolRect(TN lpti);
	// 
	void		Pop(void);
	// }EXbZ[WM
	LRESULT		RelayEvent(LPMSG msg);
	// xԂ̐ݒ
	void		SetDelayTime(int nDelay);
	void		SetDelayTime(DWORD dwDuration, int nDelay);
	// }[Wݒ
	void		SetMargin(LPRECT lprc);
	void		SetMargin(LONG top, LONG left, LONG bottom, LONG right);
	// ő啝ݒ
	int			SetMaxTipWidth(int nWidth);
	// wiF̕ύX
	void		SetTipBkColor(COLORREF color);
	// F̕ύX
	void		SetTipTextColor(COLORREF color);
	// ^Cgݒ
	template<typename CHARTYPE_>
	LRESULT		SetTitle(WPARAM icon, const CHARTYPE_* lpszTitle);
	// c[̐ݒ
	template<typename TN>
	BOOL		SetToolInfo(TN lpti);
	// ĕ`
	void		Update(void);
	// o^eLXg̍Đݒ
	template<typename TN>
	void		UpdateTipText(TN  lpti);
	template<typename CHARTYPE_>
	void		UpdateTipText(UINT uFlags, UINT_PTR uID, CHARTYPE_* lpszText, HINSTANCE hInstance=nullptr);
	// 
	void		WindowFromPoint(LPPOINT lppt);

};

}	// end of namespace wx
}	// end of namespace iris

#endif
