//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXFrameWindow.cpp
 * @brief		t[EBhENXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXFrameWindow_CPP_

//======================================================================
// include
#include "WXFrameWindow.h"

namespace iris {
namespace wx
{

//======================================================================
// struct
//! qEBhE̗񋓃R[obNɓnp[^\
typedef struct tagEnumChildProcParam
{
	BOOL*	pSignal;	// VOi
	HWND	hWnd;		// 
	HWND	hParent;
	RECT	rc;
} ENUMCHILDPROCPARAM, *LPENUMCHILDPROCPARAM;

//======================================================================
// function
/**********************************************************************//**
 *
 * ׂĂ̎qEBhEŏ̃t[EBhËvZ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= EBhEnh
 * @param [io]	lParam		= LPENUMCHILDPROCPARAM
*//***********************************************************************/
BOOL CALLBACK FrameWindowRectEnumProc(HWND hWnd, LPARAM lParam)
{
	LPENUMCHILDPROCPARAM param = (LPENUMCHILDPROCPARAM)lParam;
	if( !(*param->pSignal) ) 
	{
		*param->pSignal = TRUE;
		return FALSE;
	}
	RECT rc;
	if( hWnd == param->hWnd ) return TRUE;					// ͖
	if( GetParent(hWnd) != param->hParent ) return TRUE;	// q̂ݏiȉ͖j
	LPRECT lprc = &param->rc;
	GetWindowRect(hWnd, &rc);
	LONG w = rc.right - rc.left;
	LONG h = rc.bottom - rc.top;
	if( w > h )
	{
		LONG y1 = rc.top - lprc->top;
		LONG y2 = lprc->bottom - rc.bottom;
		if( y1 > y2 )
			lprc->bottom = rc.top;
		else
			lprc->top = rc.bottom;
	}
	else
	{
		LONG x1 = rc.left - lprc->left;
		LONG x2 = lprc->right - rc.right;
		if( x1 > x2 )
			lprc->right = rc.left;
		else
			lprc->left = rc.right;
	}
	return TRUE;
}

//======================================================================
// class

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CFrameWindow::CFrameWindow(void)
: m_Signal(FALSE)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CFrameWindow::~CFrameWindow(void)
{
}

/**********************************************************************//**
 *
 * t[EBhẼEBhËvZ
 *
 ----------------------------------------------------------------------
 * @param [in]	hParent		= ẽEBhEnh
 * @param [out]	lprc		= o͗̈
*//***********************************************************************/
bool CFrameWindow::CalcWindowRect(HWND hParent, LPRECT lprc)
{
	ENUMCHILDPROCPARAM param;
	param.pSignal	= &m_Signal;
	param.hWnd		= m_hWnd;
	param.hParent	= hParent;
	if( !::GetClientRect(hParent, &param.rc) ) return false;
	::ClientToScreen(hParent, (LPPOINT)&param.rc);
	::ClientToScreen(hParent, ((LPPOINT)&param.rc) + 1);
	if( m_Signal )
	{
		m_Signal = FALSE;
		while(!m_Signal) {}
	}
	m_Signal = TRUE;
	EnumChildWindows(hParent, FrameWindowRectEnumProc, (LPARAM)&param);
	m_Signal = FALSE;
	if( lprc != nullptr ) *lprc = param.rc;
	return true;
}

/**********************************************************************//**
 *
 * SetFrameWindowSize
 *
 ----------------------------------------------------------------------
 * @param [in]	w			= 
 * @param [in]	h			= 
 * @param [in]	bRepaint	= ĕ`tO
 * @return	
*//***********************************************************************/
BOOL CFrameWindow::SetFrameWindowSize(int w, int h, BOOL bRepaint)
{
	HWND hWnd = GetParent();
	RECT src, nrc, rc = { 0, 0, w, h };
	::GetWindowRect(hWnd, &src);
	CalcWindowRect(hWnd, &nrc);
	::AdjustWindowRect(&rc, GetWindowLong(GWL_STYLE), GetMenu() == nullptr ? FALSE : TRUE );
	int width = src.right - src.left;
	int height = src.bottom - src.top;
	width  += w - (nrc.right - nrc.left);
	height += h - (nrc.bottom - nrc.top);
	CWindow* pWindow = Find(hWnd);
	if( pWindow == nullptr ) return FALSE;
	return pWindow->SetWindowSize(width, height, bRepaint);
}

/**********************************************************************//**
 *
 * 쐬iŐeEBhEւ̊֘Ats܂j
 *
 ----------------------------------------------------------------------
 * @param [in]	lpszClassName	= EBhENX̖O
 * @param [in]	lpszWindowName	= EBhE̖O
 * @param [in]	hWndParent		= ẽEBhEnh
 * @param [in]	nID				= j[ID
 * @return EBhEnh
*//***********************************************************************/
HWND CFrameWindow::Create(LPCTSTR lpszClassName, LPCTSTR lpszWindowName, HWND hWndParent, UINT nID)
{
	RECT rc = {0};
	if( !CalcWindowRect(hWndParent, &rc) )
	{
		::ScreenToClient(hWndParent, (LPPOINT)&rc);
		::ScreenToClient(hWndParent, ((LPPOINT)&rc) + 1);
	}

	HWND hWnd = CWindow::Create(lpszClassName
		, lpszWindowName
		, WS_CHILD | WS_VISIBLE | WS_CLIPCHILDREN
		, rc
		, hWndParent
		, nID
		, nullptr
		, 0);
	if( hWnd != nullptr )
	{
		CWindow* pWindow = Find(hWndParent);
		if( pWindow != nullptr ) pWindow->InsertSubject(nullptr, this);	// I[ɑ}
	}
	return hWnd;
}

/**********************************************************************//**
 *
 * EBhEvV[W
 *
 * @note	q󂯎WM_COMMAND߂̂܂ܐeɑM
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= EBhEnh
 * @param [in]	uMsg	= sꂽbZ[W
 * @param [in]	wParam	= sꂽbZ[W@
 * @param [in]	lParam	= sꂽbZ[WA
 * @return	LRESULTl
*//***********************************************************************/
LRESULT CFrameWindow::WndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch( uMsg )
	{
	case WM_COMMAND:
		::SendMessage(::GetParent(hWnd), uMsg, wParam, lParam);
		break;
	}
	return CWindow::WndProc(hWnd, uMsg, wParam, lParam);
}

/**********************************************************************//**
 *
 * evV[W󂯂bZ[WM
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= eEBhE
 * @param [in]	uMsg	= evV[W󂯂
 * @param [in]	wParam	= evV[W󂯂
 * @param [in]	lParam	= evV[W󂯂
*//***********************************************************************/
LRESULT	CFrameWindow::RecvParentMessage(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch( uMsg )
	{
	case WM_SIZE:
		{
			switch(wParam)
			{
			case SIZE_MAXIMIZED:
			case SIZE_RESTORED:
				RECT rc = {0};
				if( CalcWindowRect(hWnd, &rc) )
				{
					if( (rc.right <= rc.left) || (rc.bottom <= rc.top) ) 
					{
						break;
					}
					if( !::ScreenToClient(hWnd, (LPPOINT)&rc) ) break;
					if( !::ScreenToClient(hWnd, ((LPPOINT)&rc) + 1) ) break;
					MoveWindow(rc.left, rc.top, rc.right-rc.left, rc.bottom-rc.top, 0);
				}
				break;
			}
		}
		break;
	}
	return CWindow::RecvParentMessage(hWnd, uMsg, wParam, lParam);
}

}	// end of namespace wx
}	// end of namespace iris
