//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXRenderTextureUp.cpp
 * @brief		Texture `NX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_DXRenderTextureUp_CPP_

//======================================================================
// include
#include "DXRenderTextureUp.h"
#include "DXTexture.h"
#include "../env/DXFVF.h"
#include "iris_debug.h"

namespace iris {
namespace dx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CDXRenderTextureUp::CDXRenderTextureUp(void)
{
}

/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	color		= F
 * @param [in]	tex_size	= eNX`TCY
*//***********************************************************************/
CDXRenderTextureUp::CDXRenderTextureUp(const intr::DXICOLOR& color, const D3DXVECTOR2& tex_size)
: IDXRenderTexture(color, tex_size)
{
}

/**********************************************************************//**
 *
 * fXgN^
 * 
*//***********************************************************************/
CDXRenderTextureUp::~CDXRenderTextureUp(void)
{
	Release();
}

/**********************************************************************//**
 *
 * 쐬
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
bool CDXRenderTextureUp::Create(void)
{
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
	return true;
#else
	return false;
#endif
}

/**********************************************************************//**
 *
 * 
 * 
*//***********************************************************************/
void CDXRenderTextureUp::Release(void)
{
	IDXPrimitive::Release();
}

/**********************************************************************//**
 *
 * Zbg
 * 
*//***********************************************************************/
void CDXRenderTextureUp::Reset(void)
{
}

/**********************************************************************//**
 *
 * XgA
 * 
*//***********************************************************************/
void CDXRenderTextureUp::Restore(void)
{
}

/**********************************************************************//**
 *
 * eNX`ݒ
 * 
 ----------------------------------------------------------------------
 * @param [in]	pTexture	= eNX`NX
*//***********************************************************************/
void CDXRenderTextureUp::SetTexture(const IDXTexture* pTexture)
{
	IDXRenderTexture::SetTexture(pTexture);
	IDXPrimitive::SetTexture(pTexture->GetTexture());
}

/**********************************************************************//**
 *
 * `
 * 
*//***********************************************************************/
void CDXRenderTextureUp::DrawPrimitive(void)
{
	CDXDeviceX& pDevice = GetDeviceX();

	// lp`쐬
	CDXFVF<FVF> ver[4];
	f32 u0 = m_UV0.x;
	f32 v0 = m_UV0.y;
	f32 u1 = m_UV1.x;
	f32 v1 = m_UV1.y;
#if 0
	f32 w = m_TexSize.x;
	f32 h = m_TexSize.y;
	ver[0].vertex( 0.0f, 0.0f, 0.0f).normal(  0.0f,  0.0f, -1.0f).diffuse( m_Color).uv( u0, v0 );
#ifdef _IRIS_DX_RIGHTHAND
	ver[1].vertex( 0.0f,    h, 0.0f).normal(  0.0f,  0.0f, -1.0f).diffuse( m_Color).uv( u0, v1 );
	ver[2].vertex(    w, 0.0f, 0.0f).normal(  0.0f,  0.0f, -1.0f).diffuse( m_Color).uv( u1, v0 );
#else
	ver[1].vertex(    w, 0.0f, 0.0f).normal(  0.0f,  0.0f, -1.0f).diffuse( m_Color).uv( u1, v0 );
	ver[2].vertex( 0.0f,    h, 0.0f).normal(  0.0f,  0.0f, -1.0f).diffuse( m_Color).uv( u0, v1 );
#endif
	ver[3].vertex(    w,    h, 0.0f).normal(  0.0f,  0.0f, -1.0f).diffuse( m_Color).uv( u1, v1 );
#else

	f32 cx = m_TexSize.x / 2.0f;
	f32 cy = m_TexSize.y / 2.0f;
	ver[0].vertex(-cx,  cy, 0.0f).normal(0.0f, 0.0f, -1.0f).diffuse(m_Color).uv(u0, v0);
#ifdef _IRIS_DX_RIGHTHAND
	ver[1].vertex(-cx, -cy, 0.0f).normal(0.0f, 0.0f, -1.0f).diffuse(m_Color).uv(u0, v1);
	ver[2].vertex( cx,  cy, 0.0f).normal(0.0f, 0.0f, -1.0f).diffuse(m_Color).uv(u1, v0);
#else
	ver[1].vertex( cx,  cy, 0.0f).normal(0.0f, 0.0f, -1.0f).diffuse(m_Color).uv(u1, v0);
	ver[2].vertex(-cx, -cy, 0.0f).normal(0.0f, 0.0f, -1.0f).diffuse(m_Color).uv(u0, v1);
#endif
	ver[3].vertex( cx, -cy, 0.0f).normal(0.0f, 0.0f, -1.0f).diffuse(m_Color).uv(u1, v1);
#endif

#if	defined(_IRIS_SUPPORT_DXMOBILE)
	// TODO : Ή
	//pDevice->DrawPrimitiveUP(D3DPT_TRIANGLESTRIP, 2, ver, CDXFVF<FVF>::SIZE );
#else
	pDevice->SetFVF( FVF );
	pDevice->DrawPrimitiveUP(D3DPT_TRIANGLESTRIP, 2, ver, CDXFVF<FVF>::SIZE );
#endif
}

}	// end of namespace dx
}	// end of namespace iris

