//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXSpriteTexture.h
 * @brief		DXSpriteTexture t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_DXSpriteTexture_H_
#define INCG_IRIS_DXSpriteTexture_H_

//======================================================================
// include
#include "DXSprite.h"
#include "../texture/DXRenderTexture.h"

namespace iris {
namespace dx
{

//======================================================================
// class
/**
 * @biref	XvCgeNX`NX
*/
class CDXSpriteTexture : public IDXMtxLayerObject, public IDXRenderTexture
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
	, protected CDXSprite
#endif
{
public:
	typedef CDXDeviceObject<LPDXTEXTURE>	TEXTURE;
protected:
	TEXTURE				m_pTexture;	//!< eNX`
	UINT				m_Width;	//!< 
	UINT				m_Height;	//!< 

public:
	// RXgN^
	CDXSpriteTexture(void);
	CDXSpriteTexture(const intr::DXICOLOR& color, const D3DXVECTOR2& tex_size);
	// fXgN^
	virtual ~CDXSpriteTexture(void);
public:
	//! 쐬
	virtual bool	Create(void);
	// XV
	virtual void	Update(f32 time);
	// `
	virtual	void	Draw(void);
	//! 
	virtual	void	Release(void);

protected:
	//! Zbg
	virtual	void	Reset(void);
	//! XgA
	virtual	void	Restore(void);

	// width,height
	virtual UINT		GetWidth(void)		const	{ return m_Width; }
	virtual UINT		GetHeight(void)		const	{ return m_Height; }

	void				GetRect(LPRECT lprc) const;

public:
	//! XvCg̐ݒ
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
			void	SetSprite(const SPRITE& sprite)	{ m_pSprite = sprite; }
#endif
	// eNX`̐ݒ
	virtual	void	SetTexture(const IDXTexture* pTexture);
};

}	// end of namespace dx
}	// end of namespace iris

#endif
