//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXSpriteTexture.cpp
 * @brief		DXSpriteTexture t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_DXSpriteTexture_CPP_

//======================================================================
// include
#include "DXSpriteTexture.h"
#include "../DXDevice.h"
#include "../../DXCoordinates.h"
#include "../../DXError.h"

namespace iris {
namespace dx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CDXSpriteTexture::CDXSpriteTexture(void)
: m_pTexture(nullptr)
, m_Width(0)
, m_Height(0)
{
}

/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	color		= F
 * @param [in]	tex_size	= eNX`TCY
*//***********************************************************************/
CDXSpriteTexture::CDXSpriteTexture(const intr::DXICOLOR& color, const D3DXVECTOR2& tex_size)
: IDXRenderTexture(color, tex_size)
, m_pTexture(nullptr)
, m_Width(0)
, m_Height(0)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CDXSpriteTexture::~CDXSpriteTexture(void)
{
	Release();
}

/**********************************************************************//**
 *
 * XV
 * 
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
bool CDXSpriteTexture::Create(void)
{
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
	CDXDevice* pDxDevice = GetDXDevice();
	if( pDxDevice == nullptr ) return false;
	m_pSprite = pDxDevice->GetSprite();
#endif
	return true;
}

/**********************************************************************//**
 *
 * XV
 * 
 ----------------------------------------------------------------------
 * @param [in]	time	= XV
*//***********************************************************************/
void CDXSpriteTexture::Update(f32 time)
{
	IRIS_UNUSED_VARIABLE(time);
}

/**********************************************************************//**
 *
 * `
 * 
*//***********************************************************************/
void CDXSpriteTexture::Draw(void)
{
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
	CDXDevice* pDxDevice = GetDXDevice();
	IRIS_ASSERT( pDxDevice != nullptr );
	if( !m_pSprite.is_valid() ) return;
	if( m_pTexture.is_valid() )
	{
		if( FAILED(pDxDevice->GetDevice().SetTexture(0, m_pTexture)) )
		{
			IRIS_WARNING("failed SetTexture.");
		}
	}
	RECT rect = {	static_cast<LONG>(m_UV0.x * m_Width),
					static_cast<LONG>(m_UV0.y * m_Height),
					static_cast<LONG>(m_UV1.x * m_Width),
					static_cast<LONG>(m_UV1.y * m_Height)
	};
	//D3DXVECTOR3 center( (rect.right-rect.left)/2.0f, (rect.bottom-rect.top)/2.0f, 0.0f);
	D3DXVECTOR3 center(0.0f, 0.0f, 0.0f);

	// [hWϊ
	D3DXMATRIX matW;
	D3DXMatrixScaling(&matW, m_TexSize.x/((m_UV1.x-m_UV0.x) * m_Width), m_TexSize.y/((m_UV1.y-m_UV0.y) * m_Height), 1.0f);
	D3DXMatrixMultiply(&matW, &m_Mtx, &matW);
	pDxDevice->SetRenderState(D3DRS_CULLMODE, DXCULL_FACE);
	m_pSprite->SetTransform(&matW);
	m_pSprite->Begin(D3DXSPRITE_ALPHABLEND);
	DX_CHECK_RESULT( m_pSprite->Draw( m_pTexture
									, &rect
									, &center
									, &center
									, m_Color ) );
	m_pSprite->End();

	if( m_pTexture.is_valid() ) pDxDevice->GetDevice().SetTexture(0, nullptr);
#endif
}

/**********************************************************************//**
 *
 * 
 * 
*//***********************************************************************/
void CDXSpriteTexture::Release(void)
{
}

/**********************************************************************//**
 *
 * Zbg
 * 
*//***********************************************************************/
void CDXSpriteTexture::Reset(void)
{
}

/**********************************************************************//**
 *
 * XgA
 * 
*//***********************************************************************/
void CDXSpriteTexture::Restore(void)
{
}

/**********************************************************************//**
 *
 * eNX`̈̎擾
 * 
 ----------------------------------------------------------------------
 * @param [in] lprc	= o
*//***********************************************************************/
void CDXSpriteTexture::GetRect(LPRECT lprc) const
{
	IRIS_ASSERT( lprc != nullptr );
	lprc->left = lprc->top = 0;
	lprc->right = GetWidth();
	lprc->bottom = GetHeight();
}

/**********************************************************************//**
 *
 * eNX`ݒ
 * 
 ----------------------------------------------------------------------
 * @param [in]	pTexture	= eNX`NX
*//***********************************************************************/
void CDXSpriteTexture::SetTexture(const IDXTexture* pTexture)
{
	IDXRenderTexture::SetTexture(pTexture);
	m_pTexture = pTexture->GetTexture();
	m_Width		= pTexture->GetWidth();
	m_Height	= pTexture->GetHeight();
}

}	// end of namespace dx
}	// end of namespace iris
